/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, 2012-2015

*/

#extension GL_EXT_geometry_shader4 : enable

GS_VARYING out vec4 fsColor;

// done with OpenGL 2.1 API calls from CPU-side
// layout(points) in;
// layout(triangle_strip, max_vertices = 24) out;

// implied from OpenGL 4.0+ specs/ any bigger value slows down badly
// layout(triangles, invocations = 1) in;

const int NUMBER_OF_CUBE_VERTICES = 8;
const int NUMBER_OF_CUBE_FACES = 6;
const vec4[NUMBER_OF_CUBE_VERTICES] indexSigns = vec4[]( vec4(1.0,  1.0,  1.0,  1.0), vec4(1.0,  1.0,  1.0, -1.0),
                                                         vec4(1.0,  1.0, -1.0, -1.0), vec4(1.0,  1.0, -1.0,  1.0),
                                                         vec4(1.0, -1.0,  1.0,  1.0), vec4(1.0, -1.0,  1.0, -1.0),
                                                         vec4(1.0, -1.0, -1.0, -1.0), vec4(1.0, -1.0, -1.0,  1.0)
                                                       ); // Object space sign coordinate of cube corner for P, K, I, J vectors
const ivec4[NUMBER_OF_CUBE_FACES] faces = ivec4[]( ivec4(0, 1, 3, 2), ivec4(5, 4, 6, 7), ivec4(4, 5, 0, 1),
                                                   ivec4(3, 2, 7, 6), ivec4(0, 3, 4, 7), ivec4(2, 1, 6, 5)
                                                 ); // Vertex indices of the cube faces
const vec4 I = vec4(0.5, 0, 0, 0);
const vec4 J = vec4(0, 0.5, 0, 0);
const vec4 K = vec4(0, 0, 0.5, 0);

vec4 objCube[NUMBER_OF_CUBE_VERTICES]; // Object space coordinate of cube corner
vec4 ndcCube[NUMBER_OF_CUBE_VERTICES]; // Normalized device coordinate of cube corner

vec4 objCubeVertex(in vec4, in vec4, in vec4, in vec4, in int);
void emitFace(in int);
void emitVertex(in int);

void main()
{
  vec4 P = gl_PositionIn[0];

  // Create & transform the corners of the cube:
  for (int vertex = 0; vertex < NUMBER_OF_CUBE_VERTICES; ++vertex)
  {
    objCube[vertex] = objCubeVertex(P, K, I, J, vertex);
    ndcCube[vertex] = gl_ModelViewProjectionMatrix * objCube[vertex];
  }

  // Emit the six faces:
  for (int face = 0; face < NUMBER_OF_CUBE_FACES; ++face)
    emitFace(face);
}

vec4 objCubeVertex(in vec4 P, in vec4 K, in vec4 I, in vec4 J, in int vertex)
{
  return (indexSigns[vertex][0] * P + indexSigns[vertex][1] * K + indexSigns[vertex][2] * I + indexSigns[vertex][3] * J);
}

void emitFace(in int face)
{
  emitVertex(faces[face][1]); emitVertex(faces[face][0]);
  emitVertex(faces[face][3]); emitVertex(faces[face][2]);
  // emitVertex(faces[face][0]); emitVertex(faces[face][1]);
  // emitVertex(faces[face][2]); emitVertex(faces[face][3]);
  EndPrimitive();
}

void emitVertex(in int vertex)
{
  fsColor = (0.5 + objCube[vertex]);
  fsColor.z = 1.0 - fsColor.z; // z axis inverted for volume cube so as to match the other shader volume rendering methods
  gl_Position = ndcCube[vertex];
  EmitVertex();
}