/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, Michael Kargas, 2008-2009-2010

*/

FS_VARYING vec2 coord;

uniform sampler2D textureDisplacement2DTexture;

uniform float textureDisplacementTimer;
uniform float textureDisplacementTransparency;
uniform bool textureDisplacementOldLCDStyleTransparency;

const float devideRation = 512.0;

void applyOldStyleTransparency();

void main()
{
  if (textureDisplacementOldLCDStyleTransparency)
    applyOldStyleTransparency();

  vec2 textureCoords = gl_TexCoord[0].st;
  float timer = textureDisplacementTimer / 4096.0;
  float sinTimer = sin(timer);

  textureCoords.s += 0.075 * sinTimer * sin( (coord.y / devideRation + timer) * 16.0 );
  textureCoords.t += 0.125 * sinTimer * sin( (coord.x / devideRation + 1.5 * timer) * 12.0 );

  vec4 color = textureDisplacementTransparency * texture2D(textureDisplacement2DTexture, textureCoords);

  gl_FragColor = color;
}