/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, 2008-2015

*/

FS_VARYING vec2 coord;

uniform sampler2D spotCircleRandom2DTexture;

uniform float spotCircleTimer;
uniform float spotCircleTransparency;
uniform bool spotCircleOldLCDStyleTransparency;

uniform float spotCircleCenterX;
uniform float spotCircleCenterY;
uniform float spotCircleRadius;
uniform float spotCirclePreCalcAlphaValues;
uniform bool spotCircleWithNoiseEffect;

const vec3 SPOT_CIRCLE_OUTER_COLOR = vec3(0.0);

vec3 rand3(in vec2 seed);
float smootherstep(in float, in float, in float);
void applyOldStyleTransparency();

void main()
{
  if (spotCircleOldLCDStyleTransparency)
    applyOldStyleTransparency();

  float spotCircleDistance = distance(vec2(spotCircleCenterX, spotCircleCenterY), coord.xy);
  // using integer number checks for the anti-alias effect!
  int spotCircleDistanceInteger = int(spotCircleDistance);
  int spotCircleRadiusInteger   = int(spotCircleRadius);
  if (spotCircleDistanceInteger < spotCircleRadiusInteger) // inside of spot circle
  {
    if (spotCircleWithNoiseEffect)
    {
      #if USE_SPOT_CIRCLE_RANDOM_2D_TEXTURE_CONDITION
          vec3 allRandomColors = texture2D(spotCircleRandom2DTexture, vec2(fract(gl_TexCoord[0].st + fract(spotCircleTimer)))).rgb;
      #else
          vec3 allRandomColors = rand3(fract(gl_TexCoord[0].st + fract(spotCircleTimer)));
      #endif
      vec3 randomColor = vec3((allRandomColors.r + allRandomColors.g + allRandomColors.b) / 3.0);
      gl_FragColor = vec4(randomColor, smootherstep(0.0, 1.0, spotCircleTransparency * spotCirclePreCalcAlphaValues));
    }
    else
      gl_FragColor = vec4(SPOT_CIRCLE_OUTER_COLOR, 0.0);
  }
  else if (spotCircleDistanceInteger > spotCircleRadiusInteger) // outside of spot circle
    gl_FragColor = vec4(SPOT_CIRCLE_OUTER_COLOR, smootherstep(0.0, 1.0, spotCircleTransparency * spotCirclePreCalcAlphaValues));
  else // if (distanceInteger == spotCircleRadiusInteger) // for the anti-alias effect on spot circle!
    gl_FragColor = vec4(SPOT_CIRCLE_OUTER_COLOR, smootherstep(0.0, 1.0, spotCircleTransparency * spotCirclePreCalcAlphaValues * fract(spotCircleDistance)));
}