/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.mixer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TClip;

public class TSoftClip
extends TClip
implements Runnable {
    private static final Class[] CONTROL_CLASSES = new Class[0];
    private static final int BUFFER_SIZE = 16384;
    private Mixer m_mixer;
    private SourceDataLine m_line;
    private byte[] m_abClip;
    private int m_nRepeatCount;
    private Thread m_thread;

    public TSoftClip(Mixer object, AudioFormat audioFormat) {
        super(null);
        this.m_mixer = object;
        object = new DataLine.Info(SourceDataLine.class, audioFormat);
        this.m_line = (SourceDataLine)AudioSystem.getLine((Line.Info)object);
    }

    @Override
    public void open(AudioInputStream audioInputStream) {
        Object object = audioInputStream.getFormat();
        this.setFormat((AudioFormat)object);
        if (((AudioFormat)object).getFrameSize() <= 0) {
            throw new IllegalArgumentException("frame size must be positive");
        }
        if (TDebug.TraceClip) {
            TDebug.out("TSoftClip.open(): format: " + object);
        }
        object = new byte[16384];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 != -1) {
            block6: {
                try {
                    n2 = audioInputStream.read((byte[])object, 0, 16384);
                }
                catch (IOException iOException) {
                    if (!TDebug.TraceClip && !TDebug.TraceAllExceptions) break block6;
                    TDebug.out(iOException);
                }
            }
            if (n2 < 0) continue;
            if (TDebug.TraceClip) {
                TDebug.out("TSoftClip.open(): Trying to write: " + n2);
            }
            byteArrayOutputStream.write((byte[])object, 0, n2);
            if (!TDebug.TraceClip) continue;
            TDebug.out("TSoftClip.open(): Written: " + n2);
        }
        this.m_abClip = byteArrayOutputStream.toByteArray();
        this.setBufferSize(this.m_abClip.length);
        this.m_line.open(this.getFormat());
    }

    @Override
    public int getFrameLength() {
        if (this.isOpen()) {
            return this.getBufferSize() / this.getFormat().getFrameSize();
        }
        return -1;
    }

    @Override
    public long getMicrosecondLength() {
        if (this.isOpen()) {
            return (long)((float)this.getFrameLength() * this.getFormat().getFrameRate() * 1000000.0f);
        }
        return -1L;
    }

    @Override
    public void setFramePosition(int n2) {
    }

    @Override
    public void setMicrosecondPosition(long l2) {
    }

    @Override
    public int getFramePosition() {
        return -1;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public void setLoopPoints(int n2, int n3) {
    }

    @Override
    public void loop(int n2) {
        if (TDebug.TraceClip) {
            TDebug.out("TSoftClip.loop(int): called; count = " + n2);
        }
        this.m_nRepeatCount = n2;
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    @Override
    public void flush() {
    }

    @Override
    public void drain() {
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public void start() {
        if (TDebug.TraceClip) {
            TDebug.out("TSoftClip.start(): called");
        }
        if (TDebug.TraceClip) {
            TDebug.out("TSoftClip.start(): calling 'loop(0)' [hack]");
        }
        this.loop(0);
    }

    @Override
    public void stop() {
    }

    @Override
    public int available() {
        return -1;
    }

    @Override
    public void run() {
        while (this.m_nRepeatCount >= 0) {
            this.m_line.write(this.m_abClip, 0, this.m_abClip.length);
            --this.m_nRepeatCount;
        }
    }
}

