/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.file;

import javax.sound.sampled.AudioFormat;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.AudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;

public abstract class TAudioOutputStream
implements AudioOutputStream {
    private AudioFormat m_audioFormat;
    private long m_lLength;
    private long m_lCalculatedLength;
    private TDataOutputStream m_dataOutputStream;
    private boolean m_bDoBackPatching;
    private boolean m_bHeaderWritten;

    protected TAudioOutputStream(AudioFormat audioFormat, long l2, TDataOutputStream tDataOutputStream, boolean bl) {
        this.m_audioFormat = audioFormat;
        this.m_lLength = l2;
        this.m_lCalculatedLength = 0L;
        this.m_dataOutputStream = tDataOutputStream;
        this.m_bDoBackPatching = bl;
        this.m_bHeaderWritten = false;
    }

    @Override
    public AudioFormat getFormat() {
        return this.m_audioFormat;
    }

    @Override
    public long getLength() {
        return this.m_lLength;
    }

    public long getCalculatedLength() {
        return this.m_lCalculatedLength;
    }

    protected TDataOutputStream getDataOutputStream() {
        return this.m_dataOutputStream;
    }

    @Override
    public int write(byte[] byArray, int n2, int n3) {
        long l2;
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("TAudioOutputStream.write(): wanted length: " + n3);
        }
        if (!this.m_bHeaderWritten) {
            this.writeHeader();
            this.m_bHeaderWritten = true;
        }
        if ((l2 = this.getLength()) != -1L && this.m_lCalculatedLength + (long)n3 > l2) {
            if (TDebug.TraceAudioOutputStream) {
                TDebug.out("TAudioOutputStream.write(): requested more bytes to write than possible.");
            }
            if ((n3 = (int)(l2 - this.m_lCalculatedLength)) < 0) {
                n3 = 0;
            }
        }
        if (n3 > 0) {
            this.m_dataOutputStream.write(byArray, n2, n3);
            this.m_lCalculatedLength += (long)n3;
        }
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("TAudioOutputStream.write(): calculated (total) length: " + this.m_lCalculatedLength + " bytes = " + this.m_lCalculatedLength / (long)this.getFormat().getFrameSize() + " frames");
        }
        return n3;
    }

    protected abstract void writeHeader();

    @Override
    public void close() {
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("TAudioOutputStream.close(): called");
        }
        if (this.m_bDoBackPatching) {
            if (TDebug.TraceAudioOutputStream) {
                TDebug.out("TAudioOutputStream.close(): patching header");
            }
            this.patchHeader();
        }
        this.m_dataOutputStream.close();
    }

    protected void patchHeader() {
        TDebug.out("TAudioOutputStream.patchHeader(): called");
    }

    protected void setLengthFromCalculatedLength() {
        this.m_lLength = this.m_lCalculatedLength;
    }
}

