/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.file;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.tritonus.share.TDebug;

public abstract class TAudioFileReader
extends AudioFileReader {
    private int m_nMarkLimit = -1;
    private boolean m_bRereading;

    protected TAudioFileReader(int n2) {
        this(n2, false);
    }

    public TAudioFileReader(int n2, boolean bl) {
        this.m_nMarkLimit = n2;
        this.m_bRereading = bl;
    }

    private int getMarkLimit() {
        return this.m_nMarkLimit;
    }

    private boolean isRereading() {
        return this.m_bRereading;
    }

    @Override
    public AudioFileFormat getAudioFileFormat(File object) {
        AudioFileFormat audioFileFormat;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioFileFormat(File): begin");
        }
        long l2 = ((File)object).length();
        object = new FileInputStream((File)object);
        try {
            audioFileFormat = this.getAudioFileFormat((InputStream)object, l2);
        }
        finally {
            ((InputStream)object).close();
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioFileFormat(File): end");
        }
        return audioFileFormat;
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL object) {
        AudioFileFormat audioFileFormat;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioFileFormat(URL): begin");
        }
        long l2 = TAudioFileReader.getDataLength((URL)object);
        object = ((URL)object).openStream();
        try {
            audioFileFormat = this.getAudioFileFormat((InputStream)object, l2);
        }
        finally {
            ((InputStream)object).close();
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioFileFormat(URL): end");
        }
        return audioFileFormat;
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) {
        AudioFileFormat audioFileFormat;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioFileFormat(InputStream): begin");
        }
        inputStream.mark(this.getMarkLimit());
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream, -1L);
        }
        finally {
            inputStream.reset();
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioFileFormat(InputStream): end");
        }
        return audioFileFormat;
    }

    public abstract AudioFileFormat getAudioFileFormat(InputStream var1, long var2);

    @Override
    public AudioInputStream getAudioInputStream(File object) {
        AudioInputStream audioInputStream;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioInputStream(File): begin");
        }
        long l2 = ((File)object).length();
        object = new FileInputStream((File)object);
        try {
            audioInputStream = this.getAudioInputStream((InputStream)object, l2);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)object).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)object).close();
            throw iOException;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioInputStream(File): end");
        }
        return audioInputStream;
    }

    @Override
    public AudioInputStream getAudioInputStream(URL object) {
        AudioInputStream audioInputStream;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioInputStream(URL): begin");
        }
        long l2 = TAudioFileReader.getDataLength((URL)object);
        object = ((URL)object).openStream();
        try {
            audioInputStream = this.getAudioInputStream((InputStream)object, l2);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)object).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)object).close();
            throw iOException;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioInputStream(URL): end");
        }
        return audioInputStream;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream inputStream) {
        AudioInputStream audioInputStream;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioInputStream(InputStream): begin");
        }
        inputStream.mark(this.getMarkLimit());
        try {
            audioInputStream = this.getAudioInputStream(inputStream, -1L);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            inputStream.reset();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            inputStream.reset();
            throw iOException;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioInputStream(InputStream): end");
        }
        return audioInputStream;
    }

    protected AudioInputStream getAudioInputStream(InputStream inputStream, long l2) {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioInputStream(InputStream, long): begin");
        }
        if (this.isRereading()) {
            inputStream = new BufferedInputStream(inputStream, this.getMarkLimit());
            inputStream.mark(this.getMarkLimit());
        }
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, l2);
        if (this.isRereading()) {
            inputStream.reset();
        }
        inputStream = new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("TAudioFileReader.getAudioInputStream(InputStream, long): end");
        }
        return inputStream;
    }

    protected static int calculateFrameSize(int n2, int n3) {
        return (n2 + 7) / 8 * n3;
    }

    private static long getDataLength(URL object) {
        long l2 = -1L;
        object = ((URL)object).openConnection();
        ((URLConnection)object).connect();
        int n2 = ((URLConnection)object).getContentLength();
        if (n2 > 0) {
            l2 = n2;
        }
        return l2;
    }

    public static int readLittleEndianInt(InputStream inputStream) {
        int n2;
        int n3;
        int n4;
        int n5 = inputStream.read();
        if ((n5 | (n4 = inputStream.read()) | (n3 = inputStream.read()) | (n2 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public static short readLittleEndianShort(InputStream inputStream) {
        int n2;
        int n3 = inputStream.read();
        if ((n3 | (n2 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n3);
    }

    public static double readIeeeExtended(DataInputStream dataInputStream) {
        double d2;
        int n2 = dataInputStream.readUnsignedShort();
        long l2 = dataInputStream.readUnsignedShort();
        long l3 = dataInputStream.readUnsignedShort();
        long l4 = l2 << 16 | l3;
        l2 = dataInputStream.readUnsignedShort();
        l3 = dataInputStream.readUnsignedShort();
        long l5 = l2 << 16 | l3;
        if (n2 == 0 && l4 == 0L && l5 == 0L) {
            d2 = 0.0;
        } else if (n2 == Short.MAX_VALUE) {
            d2 = 3.4028234663852886E38;
        } else {
            n2 -= 16383;
            d2 = (double)l4 * Math.pow(2.0, n2 -= 31);
            d2 += (double)l5 * Math.pow(2.0, n2 -= 32);
        }
        return d2;
    }
}

