/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.sampled.FloatSampleTools;

public class FloatSampleBuffer {
    private static final boolean LAZY_DEFAULT = true;
    private ArrayList channels = new ArrayList();
    private int sampleCount = 0;
    private int channelCount = 0;
    private float sampleRate = 0.0f;
    private int originalFormatType = 0;
    public static final int DITHER_MODE_AUTOMATIC = 0;
    public static final int DITHER_MODE_ON = 1;
    public static final int DITHER_MODE_OFF = 2;
    private float ditherBits = 0.7f;
    private int ditherMode = 0;

    public FloatSampleBuffer() {
        this(0, 0, 1.0f);
    }

    public FloatSampleBuffer(int n2, int n3, float f2) {
        this.init(n2, n3, f2, true);
    }

    public FloatSampleBuffer(byte[] byArray, int n2, int n3, AudioFormat audioFormat) {
        this(audioFormat.getChannels(), n3 / (audioFormat.getSampleSizeInBits() / 8 * audioFormat.getChannels()), audioFormat.getSampleRate());
        this.initFromByteArray(byArray, n2, n3, audioFormat);
    }

    protected void init(int n2, int n3, float f2) {
        this.init(n2, n3, f2, true);
    }

    protected void init(int n2, int n3, float f2, boolean bl) {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("invalid parameters in initialization of FloatSampleBuffer.");
        }
        this.setSampleRate(f2);
        if (this.getSampleCount() != n3 || this.getChannelCount() != n2) {
            this.createChannels(n2, n3, bl);
        }
    }

    private void createChannels(int n2, int n3, boolean bl) {
        this.sampleCount = n3;
        this.channelCount = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            this.insertChannel(n3, false, bl);
        }
        if (!bl) {
            while (this.channels.size() > n2) {
                this.channels.remove(this.channels.size() - 1);
            }
        }
    }

    public void initFromByteArray(byte[] byArray, int n2, int n3, AudioFormat audioFormat) {
        this.initFromByteArray(byArray, n2, n3, audioFormat, true);
    }

    public void initFromByteArray(byte[] byArray, int n2, int n3, AudioFormat audioFormat, boolean bl) {
        if (n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.initFromByteArray: buffer too small.");
        }
        this.init(audioFormat.getChannels(), n3 /= audioFormat.getFrameSize(), audioFormat.getSampleRate(), bl);
        this.originalFormatType = FloatSampleTools.getFormatType(audioFormat);
        FloatSampleTools.byte2float(byArray, n2, this.channels, 0, this.sampleCount, audioFormat);
    }

    public void initFromFloatSampleBuffer(FloatSampleBuffer floatSampleBuffer) {
        this.init(floatSampleBuffer.getChannelCount(), floatSampleBuffer.getSampleCount(), floatSampleBuffer.getSampleRate());
        for (int i2 = 0; i2 < this.getChannelCount(); ++i2) {
            System.arraycopy(floatSampleBuffer.getChannel(i2), 0, this.getChannel(i2), 0, this.sampleCount);
        }
    }

    public void reset() {
        this.init(0, 0, 1.0f, false);
    }

    public void reset(int n2, int n3, float f2) {
        this.init(n2, n3, f2, false);
    }

    public int getByteArrayBufferSize(AudioFormat audioFormat) {
        return this.getByteArrayBufferSize(audioFormat, this.getSampleCount());
    }

    public int getByteArrayBufferSize(AudioFormat audioFormat, int n2) {
        FloatSampleTools.getFormatType(audioFormat);
        return audioFormat.getFrameSize() * n2;
    }

    public int convertToByteArray(byte[] byArray, int n2, AudioFormat audioFormat) {
        return this.convertToByteArray(0, this.getSampleCount(), byArray, n2, audioFormat);
    }

    public int convertToByteArray(int n2, int n3, byte[] byArray, int n4, AudioFormat audioFormat) {
        int n5 = this.getByteArrayBufferSize(audioFormat, n3);
        if (n4 + n5 > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: buffer too small.");
        }
        if (audioFormat.getSampleRate() != this.getSampleRate()) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different samplerates.");
        }
        if (audioFormat.getChannels() != this.getChannelCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different channel count.");
        }
        FloatSampleTools.float2byte(this.channels, n2, byArray, n4, n3, audioFormat, this.getConvertDitherBits(FloatSampleTools.getFormatType(audioFormat)));
        return n5;
    }

    public byte[] convertToByteArray(AudioFormat audioFormat) {
        byte[] byArray = new byte[this.getByteArrayBufferSize(audioFormat)];
        this.convertToByteArray(byArray, 0, audioFormat);
        return byArray;
    }

    public void changeSampleCount(int n2, boolean bl) {
        int n3 = this.getSampleCount();
        if (n3 == n2) {
            return;
        }
        Object[] objectArray = null;
        if (bl) {
            objectArray = this.getAllChannels();
        }
        this.init(this.getChannelCount(), n2, this.getSampleRate());
        if (bl) {
            int n4 = n2 < n3 ? n2 : n3;
            for (int i2 = 0; i2 < this.getChannelCount(); ++i2) {
                float[] i3 = (float[])objectArray[i2];
                float[] fArray = this.getChannel(i2);
                if (i3 != fArray) {
                    System.arraycopy(i3, 0, fArray, 0, n4);
                }
                if (n3 >= n2) continue;
                for (int i4 = n3; i4 < n2; ++i4) {
                    fArray[i4] = 0.0f;
                }
            }
        }
    }

    public void makeSilence() {
        if (this.getChannelCount() > 0) {
            this.makeSilence(0);
            for (int i2 = 1; i2 < this.getChannelCount(); ++i2) {
                this.copyChannel(0, i2);
            }
        }
    }

    public void makeSilence(int n2) {
        float[] fArray = this.getChannel(n2);
        for (int i2 = 0; i2 < this.getSampleCount(); ++i2) {
            fArray[i2] = 0.0f;
        }
    }

    public void addChannel(boolean bl) {
        this.insertChannel(this.getChannelCount(), bl);
    }

    public void insertChannel(int n2, boolean bl) {
        this.insertChannel(n2, bl, true);
    }

    public void insertChannel(int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = this.channels.size();
        float[] fArray = null;
        if (n4 > n3) {
            for (n3 = this.getChannelCount(); n3 < n4; ++n3) {
                float[] fArray2 = (float[])this.channels.get(n3);
                if ((!bl2 || fArray2.length < this.getSampleCount()) && (bl2 || fArray2.length != this.getSampleCount())) continue;
                fArray = fArray2;
                this.channels.remove(n3);
                break;
            }
        }
        if (fArray == null) {
            fArray = new float[this.getSampleCount()];
        }
        this.channels.add(n2, fArray);
        ++this.channelCount;
        if (bl) {
            this.makeSilence(n2);
        }
    }

    public void removeChannel(int n2) {
        this.removeChannel(n2, true);
    }

    public void removeChannel(int n2, boolean bl) {
        if (!bl) {
            this.channels.remove(n2);
        } else if (n2 < this.getChannelCount() - 1) {
            this.channels.add(this.channels.remove(n2));
        }
        --this.channelCount;
    }

    public void copyChannel(int n2, int n3) {
        float[] fArray = this.getChannel(n2);
        float[] fArray2 = this.getChannel(n3);
        System.arraycopy(fArray, 0, fArray2, 0, this.getSampleCount());
    }

    public void copy(int n2, int n3, int n4) {
        for (int i2 = 0; i2 < this.getChannelCount(); ++i2) {
            this.copy(i2, n2, n3, n4);
        }
    }

    public void copy(int n2, int n3, int n4, int n5) {
        float[] fArray = this.getChannel(n2);
        int n6 = this.getSampleCount();
        if (n3 + n5 > n6 || n4 + n5 > n6 || n3 < 0 || n4 < 0 || n5 < 0) {
            throw new IndexOutOfBoundsException("parameters exceed buffer size");
        }
        System.arraycopy(fArray, n3, fArray, n4, n5);
    }

    public void expandChannel(int n2) {
        if (this.getChannelCount() != 1) {
            throw new IllegalArgumentException("FloatSampleBuffer: can only expand channels for mono signals.");
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            this.addChannel(false);
            this.copyChannel(0, i2);
        }
    }

    public void mixDownChannels() {
        float[] fArray = this.getChannel(0);
        int n2 = this.getSampleCount();
        for (int i2 = this.getChannelCount() - 1; i2 > 0; --i2) {
            float[] fArray2 = this.getChannel(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                int n3 = i3;
                fArray[n3] = fArray[n3] + fArray2[i3];
            }
            this.removeChannel(i2);
        }
    }

    public void setSamplesFromBytes(byte[] byArray, int n2, AudioFormat audioFormat, int n3, int n4) {
        if (n3 < 0 || n4 < 0 || n2 < 0) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: negative inByteOffset, floatOffset, or frameCount");
        }
        if (n2 + n4 * audioFormat.getFrameSize() > byArray.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: input buffer too small.");
        }
        if (n3 + n4 > this.getSampleCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: frameCount too large");
        }
        FloatSampleTools.byte2float(byArray, n2, this.channels, n3, n4, audioFormat);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float f2) {
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Invalid samplerate for FloatSampleBuffer.");
        }
        this.sampleRate = f2;
    }

    public float[] getChannel(int n2) {
        if (n2 < 0 || n2 >= this.getChannelCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer: invalid channel number.");
        }
        return (float[])this.channels.get(n2);
    }

    public Object[] getAllChannels() {
        Object[] objectArray = new Object[this.getChannelCount()];
        for (int i2 = 0; i2 < this.getChannelCount(); ++i2) {
            objectArray[i2] = this.getChannel(i2);
        }
        return objectArray;
    }

    public void setDitherBits(float f2) {
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("DitherBits must be greater than 0");
        }
        this.ditherBits = f2;
    }

    public float getDitherBits() {
        return this.ditherBits;
    }

    public void setDitherMode(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal DitherMode");
        }
        this.ditherMode = n2;
    }

    public int getDitherMode() {
        return this.ditherMode;
    }

    protected float getConvertDitherBits(int n2) {
        boolean bl = false;
        switch (this.ditherMode) {
            case 0: {
                bl = (this.originalFormatType & 7) > (n2 & 7);
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
            }
        }
        if (bl) {
            return this.ditherBits;
        }
        return 0.0f;
    }
}

