/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.io.InputStream;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiDevice;

public abstract class TSequencer
extends TMidiDevice
implements Sequencer {
    private static final float MPQ_BPM_FACTOR = 6.0E7f;
    private static final Sequencer.SyncMode[] EMPTY_SYNCMODE_ARRAY = new Sequencer.SyncMode[0];
    private boolean m_bRunning = false;
    private Sequence m_sequence = null;
    private Set m_metaListeners = new ArraySet();
    private Set[] m_aControllerListeners = new Set[128];
    private float m_fNominalTempoInMPQ;
    private float m_fTempoFactor;
    private Collection m_masterSyncModes;
    private Collection m_slaveSyncModes;
    private Sequencer.SyncMode m_masterSyncMode;
    private Sequencer.SyncMode m_slaveSyncMode;
    private BitSet m_muteBitSet;
    private BitSet m_soloBitSet;
    private BitSet m_enabledBitSet;
    private long m_lLoopStartPoint;
    private long m_lLoopEndPoint;
    private int m_nLoopCount;

    protected TSequencer(MidiDevice.Info info, Collection collection, Collection collection2) {
        super(info);
        this.setTempoFactor(1.0f);
        this.setTempoInMPQ(500000.0f);
        this.m_masterSyncModes = collection;
        this.m_slaveSyncModes = collection2;
        if (this.getMasterSyncModes().length > 0) {
            this.m_masterSyncMode = this.getMasterSyncModes()[0];
        }
        if (this.getSlaveSyncModes().length > 0) {
            this.m_slaveSyncMode = this.getSlaveSyncModes()[0];
        }
        this.m_muteBitSet = new BitSet();
        this.m_soloBitSet = new BitSet();
        this.m_enabledBitSet = new BitSet();
        this.updateEnabled();
        this.setLoopStartPoint(0L);
        this.setLoopEndPoint(-1L);
        this.setLoopCount(0);
    }

    @Override
    public void setSequence(Sequence sequence) {
        if (this.getSequence() != sequence) {
            this.m_sequence = sequence;
            this.setSequenceImpl();
            this.setTempoFactor(1.0f);
        }
    }

    protected void setSequenceImpl() {
    }

    @Override
    public void setSequence(InputStream object) {
        object = MidiSystem.getSequence((InputStream)object);
        this.setSequence((Sequence)object);
    }

    @Override
    public Sequence getSequence() {
        return this.m_sequence;
    }

    @Override
    public void setLoopStartPoint(long l2) {
        this.m_lLoopStartPoint = l2;
    }

    @Override
    public long getLoopStartPoint() {
        return this.m_lLoopStartPoint;
    }

    @Override
    public void setLoopEndPoint(long l2) {
        this.m_lLoopEndPoint = l2;
    }

    @Override
    public long getLoopEndPoint() {
        return this.m_lLoopEndPoint;
    }

    @Override
    public void setLoopCount(int n2) {
        this.m_nLoopCount = n2;
    }

    @Override
    public int getLoopCount() {
        return this.m_nLoopCount;
    }

    @Override
    public synchronized void start() {
        this.checkOpen();
        if (!this.isRunning()) {
            this.m_bRunning = true;
            this.startImpl();
        }
    }

    protected void startImpl() {
    }

    @Override
    public synchronized void stop() {
        this.checkOpen();
        if (this.isRunning()) {
            this.stopImpl();
            this.m_bRunning = false;
        }
    }

    protected void stopImpl() {
    }

    @Override
    public synchronized boolean isRunning() {
        return this.m_bRunning;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer is not open");
        }
    }

    protected int getResolution() {
        Sequence sequence = this.getSequence();
        int n2 = sequence != null ? sequence.getResolution() : 1;
        return n2;
    }

    protected void setRealTempo() {
        float f2 = this.getTempoFactor();
        if (f2 == 0.0f) {
            f2 = 0.01f;
        }
        f2 = this.getTempoInMPQ() / f2;
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setRealTempo(): real tempo: " + f2);
        }
        this.setTempoImpl(f2);
    }

    @Override
    public float getTempoInBPM() {
        return 6.0E7f / this.getTempoInMPQ();
    }

    @Override
    public void setTempoInBPM(float f2) {
        f2 = 6.0E7f / f2;
        this.setTempoInMPQ(f2);
    }

    @Override
    public float getTempoInMPQ() {
        return this.m_fNominalTempoInMPQ;
    }

    @Override
    public void setTempoInMPQ(float f2) {
        this.m_fNominalTempoInMPQ = f2;
        this.setRealTempo();
    }

    @Override
    public void setTempoFactor(float f2) {
        this.m_fTempoFactor = f2;
        this.setRealTempo();
    }

    @Override
    public float getTempoFactor() {
        return this.m_fTempoFactor;
    }

    protected abstract void setTempoImpl(float var1);

    @Override
    public long getTickLength() {
        long l2 = 0L;
        if (this.getSequence() != null) {
            l2 = this.getSequence().getTickLength();
        }
        return l2;
    }

    @Override
    public long getMicrosecondLength() {
        long l2 = 0L;
        if (this.getSequence() != null) {
            l2 = this.getSequence().getMicrosecondLength();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMetaEventListener(MetaEventListener metaEventListener) {
        Set set = this.m_metaListeners;
        synchronized (set) {
            return this.m_metaListeners.add(metaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetaEventListener(MetaEventListener metaEventListener) {
        Set set = this.m_metaListeners;
        synchronized (set) {
            this.m_metaListeners.remove(metaEventListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator getMetaEventListeners() {
        Set set = this.m_metaListeners;
        synchronized (set) {
            return this.m_metaListeners.iterator();
        }
    }

    protected void sendMetaMessage(MetaMessage metaMessage) {
        Iterator iterator = this.getMetaEventListeners();
        while (iterator.hasNext()) {
            MetaEventListener metaEventListener = (MetaEventListener)iterator.next();
            MetaMessage metaMessage2 = (MetaMessage)metaMessage.clone();
            metaEventListener.meta(metaMessage2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] addControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Set[] setArray = this.m_aControllerListeners;
        synchronized (this.m_aControllerListeners) {
            if (nArray == null) {
                for (int i2 = 0; i2 < 128; ++i2) {
                    this.addControllerListener(i2, controllerEventListener);
                }
            } else {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    this.addControllerListener(nArray[i3], controllerEventListener);
                }
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return this.getListenedControllers(controllerEventListener);
        }
    }

    private void addControllerListener(int n2, ControllerEventListener controllerEventListener) {
        if (this.m_aControllerListeners[n2] == null) {
            this.m_aControllerListeners[n2] = new ArraySet();
        }
        this.m_aControllerListeners[n2].add(controllerEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] removeControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Set[] setArray = this.m_aControllerListeners;
        synchronized (this.m_aControllerListeners) {
            if (nArray == null) {
                for (int i2 = 0; i2 < 128; ++i2) {
                    this.removeControllerListener(i2, controllerEventListener);
                }
            } else {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    this.removeControllerListener(nArray[i3], controllerEventListener);
                }
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return this.getListenedControllers(controllerEventListener);
        }
    }

    private void removeControllerListener(int n2, ControllerEventListener controllerEventListener) {
        if (this.m_aControllerListeners[n2] != null) {
            this.m_aControllerListeners[n2].add(controllerEventListener);
        }
    }

    private int[] getListenedControllers(ControllerEventListener controllerEventListener) {
        int[] nArray = new int[128];
        int n2 = 0;
        for (int i2 = 0; i2 < 128; ++i2) {
            if (this.m_aControllerListeners[i2] == null || !this.m_aControllerListeners[i2].contains(controllerEventListener)) continue;
            nArray[n2] = i2;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    protected void sendControllerEvent(ShortMessage shortMessage) {
        int n2 = shortMessage.getData1();
        if (this.m_aControllerListeners[n2] != null) {
            for (ControllerEventListener controllerEventListener : this.m_aControllerListeners[n2]) {
                ShortMessage shortMessage2 = (ShortMessage)shortMessage.clone();
                controllerEventListener.controlChange(shortMessage2);
            }
        }
    }

    protected void notifyListeners(MidiMessage midiMessage) {
        if (midiMessage instanceof MetaMessage) {
            this.sendMetaMessage((MetaMessage)midiMessage);
            return;
        }
        if (midiMessage instanceof ShortMessage && ((ShortMessage)midiMessage).getCommand() == 176) {
            this.sendControllerEvent((ShortMessage)midiMessage);
        }
    }

    @Override
    public Sequencer.SyncMode getMasterSyncMode() {
        return this.m_masterSyncMode;
    }

    @Override
    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
        if (this.m_masterSyncModes.contains(syncMode)) {
            if (!this.getMasterSyncMode().equals(syncMode)) {
                this.m_masterSyncMode = syncMode;
                this.setMasterSyncModeImpl(syncMode);
                return;
            }
        } else {
            throw new IllegalArgumentException("sync mode not allowed: " + syncMode);
        }
    }

    protected void setMasterSyncModeImpl(Sequencer.SyncMode syncMode) {
    }

    @Override
    public Sequencer.SyncMode[] getMasterSyncModes() {
        return this.m_masterSyncModes.toArray(EMPTY_SYNCMODE_ARRAY);
    }

    @Override
    public Sequencer.SyncMode getSlaveSyncMode() {
        return this.m_slaveSyncMode;
    }

    @Override
    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
        if (this.m_slaveSyncModes.contains(syncMode)) {
            if (!this.getSlaveSyncMode().equals(syncMode)) {
                this.m_slaveSyncMode = syncMode;
                this.setSlaveSyncModeImpl(syncMode);
                return;
            }
        } else {
            throw new IllegalArgumentException("sync mode not allowed: " + syncMode);
        }
    }

    protected void setSlaveSyncModeImpl(Sequencer.SyncMode syncMode) {
    }

    @Override
    public Sequencer.SyncMode[] getSlaveSyncModes() {
        return this.m_slaveSyncModes.toArray(EMPTY_SYNCMODE_ARRAY);
    }

    @Override
    public boolean getTrackSolo(int n2) {
        boolean bl = false;
        if (this.getSequence() != null && n2 < this.getSequence().getTracks().length) {
            bl = this.m_soloBitSet.get(n2);
        }
        return bl;
    }

    @Override
    public void setTrackSolo(int n2, boolean bl) {
        boolean bl2;
        if (this.getSequence() != null && n2 < this.getSequence().getTracks().length && bl != (bl2 = this.m_soloBitSet.get(n2))) {
            if (bl) {
                this.m_soloBitSet.set(n2);
            } else {
                this.m_soloBitSet.clear(n2);
            }
            this.updateEnabled();
            this.setTrackSoloImpl(n2, bl);
        }
    }

    protected void setTrackSoloImpl(int n2, boolean bl) {
    }

    @Override
    public boolean getTrackMute(int n2) {
        boolean bl = false;
        if (this.getSequence() != null && n2 < this.getSequence().getTracks().length) {
            bl = this.m_muteBitSet.get(n2);
        }
        return bl;
    }

    @Override
    public void setTrackMute(int n2, boolean bl) {
        boolean bl2;
        if (this.getSequence() != null && n2 < this.getSequence().getTracks().length && bl != (bl2 = this.m_muteBitSet.get(n2))) {
            if (bl) {
                this.m_muteBitSet.set(n2);
            } else {
                this.m_muteBitSet.clear(n2);
            }
            this.updateEnabled();
            this.setTrackMuteImpl(n2, bl);
        }
    }

    protected void setTrackMuteImpl(int n2, boolean bl) {
    }

    private void updateEnabled() {
        int n2;
        BitSet bitSet = (BitSet)this.m_enabledBitSet.clone();
        if (this.m_soloBitSet.length() > 0) {
            this.m_enabledBitSet = (BitSet)this.m_soloBitSet.clone();
        } else {
            for (n2 = 0; n2 < this.m_muteBitSet.size(); ++n2) {
                if (this.m_muteBitSet.get(n2)) {
                    this.m_enabledBitSet.clear(n2);
                    continue;
                }
                this.m_enabledBitSet.set(n2);
            }
        }
        bitSet.xor(this.m_enabledBitSet);
        for (n2 = 0; n2 < bitSet.size(); ++n2) {
            if (!bitSet.get(n2)) continue;
            this.setTrackEnabledImpl(n2, this.m_enabledBitSet.get(n2));
        }
    }

    protected void setTrackEnabledImpl(int n2, boolean bl) {
    }

    protected boolean isTrackEnabled(int n2) {
        return this.m_enabledBitSet.get(n2);
    }

    public void setLatency(int n2) {
    }

    public int getLatency() {
        return -1;
    }
}

