/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import org.tritonus.share.midi.TMidiDevice;

public abstract class TDirectSynthesizer
extends TMidiDevice
implements Synthesizer {
    private int[] m_anBanks = new int[16];

    public TDirectSynthesizer(MidiDevice.Info info) {
        super(info, false, true);
        for (int i2 = 0; i2 < this.m_anBanks.length; ++i2) {
            this.m_anBanks[i2] = -1;
        }
    }

    @Override
    protected void openImpl() {
    }

    @Override
    protected void closeImpl() {
    }

    @Override
    protected void receive(MidiMessage midiMessage, long l2) {
        if (midiMessage instanceof ShortMessage) {
            midiMessage = (ShortMessage)midiMessage;
            int n2 = ((ShortMessage)midiMessage).getChannel();
            int n3 = ((ShortMessage)midiMessage).getCommand();
            int n4 = ((ShortMessage)midiMessage).getData1();
            int n5 = ((ShortMessage)midiMessage).getData2();
            switch (n3) {
                case 128: {
                    this.getChannel(n2).noteOff(n4, n5);
                    return;
                }
                case 144: {
                    this.getChannel(n2).noteOn(n4, n5);
                    return;
                }
                case 160: {
                    this.getChannel(n2).setPolyPressure(n4, n5);
                    return;
                }
                case 176: {
                    switch (n4) {
                        case 0: {
                            this.m_anBanks[n2] = n5 << 7;
                            return;
                        }
                        case 32: {
                            int n6 = n2;
                            this.m_anBanks[n6] = this.m_anBanks[n6] | n5;
                            return;
                        }
                        case 120: {
                            this.getChannel(n2).allSoundOff();
                            return;
                        }
                        case 121: {
                            this.getChannel(n2).resetAllControllers();
                            return;
                        }
                        case 122: {
                            this.getChannel(n2).localControl(n5 == 127);
                            return;
                        }
                        case 123: {
                            this.getChannel(n2).allNotesOff();
                            return;
                        }
                        case 124: {
                            this.getChannel(n2).setOmni(false);
                            return;
                        }
                        case 125: {
                            this.getChannel(n2).setOmni(true);
                            return;
                        }
                        case 126: {
                            this.getChannel(n2).setMono(true);
                            return;
                        }
                        case 127: {
                            this.getChannel(n2).setMono(false);
                            return;
                        }
                    }
                    this.getChannel(n2).controlChange(n4, n5);
                    return;
                }
                case 192: {
                    if (this.m_anBanks[n2] != -1) {
                        this.getChannel(n2).programChange(this.m_anBanks[n2], n4);
                        this.m_anBanks[n2] = -1;
                        return;
                    }
                    this.getChannel(n2).programChange(n4);
                    return;
                }
                case 208: {
                    this.getChannel(n2).setChannelPressure(n4);
                    return;
                }
                case 224: {
                    this.getChannel(n2).setPitchBend(n4 | n5 << 7);
                }
            }
        }
    }

    private MidiChannel getChannel(int n2) {
        return this.getChannels()[n2];
    }
}

