/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.jocl.NativePointerObject;

public final class Pointer
extends NativePointerObject {
    public static Pointer to(byte[] byArray) {
        return new Pointer(ByteBuffer.wrap(byArray));
    }

    public static Pointer to(char[] cArray) {
        return new Pointer(CharBuffer.wrap(cArray));
    }

    public static Pointer to(short[] sArray) {
        return new Pointer(ShortBuffer.wrap(sArray));
    }

    public static Pointer to(int[] nArray) {
        return new Pointer(IntBuffer.wrap(nArray));
    }

    public static Pointer to(float[] fArray) {
        return new Pointer(FloatBuffer.wrap(fArray));
    }

    public static Pointer to(long[] lArray) {
        return new Pointer(LongBuffer.wrap(lArray));
    }

    public static Pointer to(double[] dArray) {
        return new Pointer(DoubleBuffer.wrap(dArray));
    }

    public static Pointer to(Buffer buffer) {
        if (buffer == null || !buffer.isDirect() && !buffer.hasArray()) {
            throw new IllegalArgumentException("Buffer may not be null and must have an array or be direct");
        }
        return new Pointer(buffer);
    }

    public static Pointer to(NativePointerObject nativePointerObject) {
        if (nativePointerObject == null) {
            throw new IllegalArgumentException("Pointer may not point to null objects");
        }
        return new Pointer(new NativePointerObject[]{nativePointerObject});
    }

    public static Pointer to(NativePointerObject ... nativePointerObjectArray) {
        if (nativePointerObjectArray == null) {
            throw new IllegalArgumentException("Pointer may not point to null objects");
        }
        return new Pointer(nativePointerObjectArray);
    }

    public Pointer() {
    }

    protected Pointer(Buffer buffer) {
        super(buffer);
    }

    private Pointer(NativePointerObject[] nativePointerObjectArray) {
        super(nativePointerObjectArray);
    }

    protected Pointer(Pointer pointer) {
        super(pointer);
    }

    protected Pointer(Pointer pointer, long l2) {
        super(pointer, l2);
    }

    final boolean isDirectBufferPointer() {
        return this.getBuffer() != null && this.getBuffer().isDirect();
    }

    @Override
    public final Pointer withByteOffset(long l2) {
        return new Pointer(this, l2);
    }
}

