/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.nio.Buffer;
import java.util.Arrays;

public class NativePointerObject {
    private long nativePointer;
    private long byteOffset;
    private Buffer buffer;
    private NativePointerObject[] pointers;

    protected NativePointerObject() {
        this.buffer = null;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    NativePointerObject(Buffer buffer) {
        this.buffer = buffer;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    NativePointerObject(NativePointerObject[] nativePointerObjectArray) {
        this.buffer = null;
        this.pointers = nativePointerObjectArray;
        this.byteOffset = 0L;
    }

    NativePointerObject(NativePointerObject nativePointerObject) {
        this.buffer = nativePointerObject.buffer;
        this.pointers = nativePointerObject.pointers;
        this.byteOffset = nativePointerObject.byteOffset;
    }

    NativePointerObject(NativePointerObject nativePointerObject, long l2) {
        this(nativePointerObject);
        this.byteOffset += l2;
    }

    protected long getNativePointer() {
        return this.nativePointer;
    }

    long getByteOffset() {
        return this.byteOffset;
    }

    void setBuffer(Buffer buffer) {
        this.buffer = buffer;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    Buffer getBuffer() {
        return this.buffer;
    }

    NativePointerObject withByteOffset(long l2) {
        return new NativePointerObject(this, l2);
    }

    public String toString() {
        if (this.buffer != null) {
            return "NativePointerObject[buffer=" + this.buffer + ",byteOffset=" + this.byteOffset + "]";
        }
        if (this.pointers != null) {
            return "NativePointerObject[pointers=" + Arrays.toString(this.pointers) + ",byteOffset=" + this.byteOffset + "]";
        }
        return "NativePointerObject[nativePointer=0x" + Long.toHexString(this.getNativePointer()) + ",byteOffset=" + this.byteOffset + "]";
    }

    public int hashCode() {
        return (((31 + (this.buffer == null ? 0 : this.buffer.hashCode())) * 31 + (int)(this.byteOffset ^ this.byteOffset >>> 32)) * 31 + (int)(this.nativePointer ^ this.nativePointer >>> 32)) * 31 + Arrays.hashCode(this.pointers);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (NativePointerObject)object;
        if (this.buffer == null ? ((NativePointerObject)object).buffer != null : !this.buffer.equals(((NativePointerObject)object).buffer)) {
            return false;
        }
        if (this.byteOffset != ((NativePointerObject)object).byteOffset) {
            return false;
        }
        if (this.nativePointer != ((NativePointerObject)object).nativePointer) {
            return false;
        }
        return Arrays.equals(this.pointers, ((NativePointerObject)object).pointers);
    }
}

