/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture.spi;

import com.sun.opengl.util.texture.spi.LEDataInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class TGAImage$Header {
    public static final int TYPE_NEW = 0;
    public static final int TYPE_OLD = 1;
    public static final int TYPE_UNK = 2;
    public static final int NO_IMAGE = 0;
    public static final int UCOLORMAPPED = 1;
    public static final int UTRUECOLOR = 2;
    public static final int UBLACKWHITE = 3;
    public static final int COLORMAPPED = 9;
    public static final int TRUECOLOR = 10;
    public static final int BLACKWHITE = 11;
    public static final int ID_ATTRIBPERPIXEL = 15;
    public static final int ID_RIGHTTOLEFT = 16;
    public static final int ID_TOPTOBOTTOM = 32;
    public static final int ID_INTERLEAVE = 192;
    public static final int I_NOTINTERLEAVED = 0;
    public static final int I_TWOWAY = 1;
    public static final int I_FOURWAY = 2;
    private int tgaType = 1;
    private int idLength;
    private int colorMapType;
    private int imageType;
    private int firstEntryIndex;
    private int colorMapLength;
    private byte colorMapEntrySize;
    private int xOrigin;
    private int yOrigin;
    private int width;
    private int height;
    private byte pixelDepth;
    private byte imageDescriptor;
    private byte[] imageIDbuf;
    private String imageID;

    TGAImage$Header() {
    }

    TGAImage$Header(LEDataInputStream lEDataInputStream) {
        this.idLength = lEDataInputStream.readUnsignedByte();
        this.colorMapType = lEDataInputStream.readUnsignedByte();
        this.imageType = lEDataInputStream.readUnsignedByte();
        this.firstEntryIndex = lEDataInputStream.readUnsignedShort();
        this.colorMapLength = lEDataInputStream.readUnsignedShort();
        this.colorMapEntrySize = lEDataInputStream.readByte();
        this.xOrigin = lEDataInputStream.readUnsignedShort();
        this.yOrigin = lEDataInputStream.readUnsignedShort();
        this.width = lEDataInputStream.readUnsignedShort();
        this.height = lEDataInputStream.readUnsignedShort();
        this.pixelDepth = lEDataInputStream.readByte();
        this.imageDescriptor = lEDataInputStream.readByte();
        if (this.idLength > 0) {
            this.imageIDbuf = new byte[this.idLength];
            lEDataInputStream.read(this.imageIDbuf, 0, this.idLength);
            this.imageID = new String(this.imageIDbuf, "US-ASCII");
        }
    }

    public int tgaType() {
        return this.tgaType;
    }

    public int idLength() {
        return this.idLength;
    }

    public int colorMapType() {
        return this.colorMapType;
    }

    public int imageType() {
        return this.imageType;
    }

    public int firstEntryIndex() {
        return this.firstEntryIndex;
    }

    public int colorMapLength() {
        return this.colorMapLength;
    }

    public byte colorMapEntrySize() {
        return this.colorMapEntrySize;
    }

    public int xOrigin() {
        return this.xOrigin;
    }

    public int yOrigin() {
        return this.yOrigin;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public byte pixelDepth() {
        return this.pixelDepth;
    }

    public byte imageDescriptor() {
        return this.imageDescriptor;
    }

    public byte attribPerPixel() {
        return (byte)(this.imageDescriptor & 0xF);
    }

    public boolean rightToLeft() {
        return (this.imageDescriptor & 0x10) != 0;
    }

    public boolean topToBottom() {
        return (this.imageDescriptor & 0x20) != 0;
    }

    public byte interleave() {
        return (byte)((this.imageDescriptor & 0xC0) >> 6);
    }

    public byte[] imageIDbuf() {
        return this.imageIDbuf;
    }

    public String imageID() {
        return this.imageID;
    }

    public String toString() {
        return new StringBuffer("TGA Header  id length: ").append(this.idLength).append(" color map type: ").append(this.colorMapType).append(" image type: ").append(this.imageType).append(" first entry index: ").append(this.firstEntryIndex).append(" color map length: ").append(this.colorMapLength).append(" color map entry size: ").append(this.colorMapEntrySize).append(" x Origin: ").append(this.xOrigin).append(" y Origin: ").append(this.yOrigin).append(" width: ").append(this.width).append(" height: ").append(this.height).append(" pixel depth: ").append(this.pixelDepth).append(" image descriptor: ").append(this.imageDescriptor).append(this.imageIDbuf == null ? "" : new StringBuffer(" ID String: ").append(this.imageID).toString()).toString();
    }

    public int size() {
        return 18 + this.idLength;
    }

    private void write(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)this.idLength);
        byteBuffer.put((byte)this.colorMapType);
        byteBuffer.put((byte)this.imageType);
        byteBuffer.putShort((short)this.firstEntryIndex);
        byteBuffer.putShort((short)this.colorMapLength);
        byteBuffer.put(this.colorMapEntrySize);
        byteBuffer.putShort((short)this.xOrigin);
        byteBuffer.putShort((short)this.yOrigin);
        byteBuffer.putShort((short)this.width);
        byteBuffer.putShort((short)this.height);
        byteBuffer.put(this.pixelDepth);
        byteBuffer.put(this.imageDescriptor);
        if (this.idLength > 0) {
            try {
                byte[] byArray = this.imageID.getBytes("US-ASCII");
                byteBuffer.put(byArray);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
    }

    static byte access$000(TGAImage$Header tGAImage$Header) {
        return tGAImage$Header.pixelDepth;
    }

    static int access$100(TGAImage$Header tGAImage$Header) {
        return tGAImage$Header.height;
    }

    static void access$200(TGAImage$Header tGAImage$Header, ByteBuffer byteBuffer) {
        tGAImage$Header.write(byteBuffer);
    }

    static int access$302(TGAImage$Header tGAImage$Header, int n2) {
        tGAImage$Header.imageType = n2;
        return tGAImage$Header.imageType;
    }

    static int access$402(TGAImage$Header tGAImage$Header, int n2) {
        tGAImage$Header.width = n2;
        return tGAImage$Header.width;
    }

    static int access$102(TGAImage$Header tGAImage$Header, int n2) {
        tGAImage$Header.height = n2;
        return tGAImage$Header.height;
    }

    static byte access$002(TGAImage$Header tGAImage$Header, byte by) {
        tGAImage$Header.pixelDepth = by;
        return tGAImage$Header.pixelDepth;
    }

    static byte access$502(TGAImage$Header tGAImage$Header, byte by) {
        tGAImage$Header.imageDescriptor = by;
        return tGAImage$Header.imageDescriptor;
    }
}

