/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture.spi;

import com.sun.opengl.util.texture.spi.SGIImage$Header;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SGIImage {
    private SGIImage$Header header;
    private int format;
    private byte[] data;
    private int[] rowStart;
    private int[] rowSize;
    private int rleEnd;
    private byte[] tmpData;
    private byte[] tmpRead;
    private static final int MAGIC = 474;

    private SGIImage(SGIImage$Header sGIImage$Header) {
        this.header = sGIImage$Header;
    }

    public static SGIImage read(String string) {
        return SGIImage.read(new FileInputStream(string));
    }

    public static SGIImage read(InputStream inputStream) {
        inputStream = new DataInputStream(new BufferedInputStream(inputStream));
        Object object = new SGIImage$Header((DataInputStream)inputStream);
        object = new SGIImage((SGIImage$Header)object);
        ((SGIImage)object).decodeImage((DataInputStream)inputStream);
        return object;
    }

    public void write(String string, boolean bl) {
        this.write(new File(string), bl);
    }

    public void write(File file, boolean bl) {
        this.writeImage(file, this.data, this.header.xsize, this.header.ysize, this.header.zsize, bl);
    }

    public static SGIImage createFromData(int n2, int n3, boolean bl, byte[] byArray) {
        SGIImage$Header sGIImage$Header = new SGIImage$Header();
        new SGIImage$Header().xsize = (short)n2;
        sGIImage$Header.ysize = (short)n3;
        sGIImage$Header.zsize = (short)(bl ? 4 : 3);
        SGIImage sGIImage = new SGIImage(sGIImage$Header);
        new SGIImage(sGIImage$Header).data = byArray;
        return sGIImage;
    }

    public static boolean isSGIImage(InputStream inputStream) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!inputStream.markSupported()) {
            throw new IOException("Can not test non-destructively whether given InputStream is an SGI RGB image");
        }
        inputStream = new DataInputStream(inputStream);
        ((FilterInputStream)inputStream).mark(4);
        short s2 = ((DataInputStream)inputStream).readShort();
        ((FilterInputStream)inputStream).reset();
        return s2 == 474;
    }

    public int getWidth() {
        return this.header.xsize;
    }

    public int getHeight() {
        return this.header.ysize;
    }

    public int getFormat() {
        return this.format;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return this.header.toString();
    }

    private void decodeImage(DataInputStream dataInputStream) {
        int n2;
        int n3;
        if (this.header.storage == 1) {
            n3 = this.header.ysize * this.header.zsize;
            this.rowStart = new int[n3];
            this.rowSize = new int[n3];
            this.rleEnd = (n3 << 3) + 512;
            for (n2 = 0; n2 < n3; ++n2) {
                this.rowStart[n2] = dataInputStream.readInt();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.rowSize[n2] = dataInputStream.readInt();
            }
            this.tmpRead = new byte[this.header.xsize << 8];
        }
        this.tmpData = this.readAll(dataInputStream);
        n3 = this.header.xsize;
        n2 = this.header.ysize;
        short s2 = this.header.zsize;
        int n4 = 0;
        this.data = new byte[n3 * n2 << 2];
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (s2 >= 4) {
                this.getRow(byArray, i2, 0);
                this.getRow(byArray2, i2, 1);
                this.getRow(byArray3, i2, 2);
                this.getRow(byArray4, i2, 3);
                this.rgbatorgba(byArray, byArray2, byArray3, byArray4, this.data, n4);
            } else if (s2 == 3) {
                this.getRow(byArray, i2, 0);
                this.getRow(byArray2, i2, 1);
                this.getRow(byArray3, i2, 2);
                this.rgbtorgba(byArray, byArray2, byArray3, this.data, n4);
            } else if (s2 == 2) {
                this.getRow(byArray, i2, 0);
                this.getRow(byArray4, i2, 1);
                this.latorgba(byArray, byArray4, this.data, n4);
            } else {
                this.getRow(byArray, i2, 0);
                this.bwtorgba(byArray, this.data, n4);
            }
            n4 += 4 * n3;
        }
        this.rowStart = null;
        this.rowSize = null;
        this.tmpData = null;
        this.tmpRead = null;
        this.format = 6408;
        this.header.zsize = (short)4;
    }

    /*
     * Unable to fully structure code
     */
    private void getRow(byte[] var1_1, int var2_2, int var3_3) {
        block4: {
            if (this.header.storage != 1) break block4;
            var4_4 = this.rowStart[var2_2 + var3_3 * this.header.ysize] - this.rleEnd;
            System.arraycopy(this.tmpData, var4_4, this.tmpRead, 0, this.rowSize[var2_2 + var3_3 * this.header.ysize]);
            var2_2 = 0;
            var3_3 = 0;
            block0: while (true) lbl-1000:
            // 3 sources

            {
                block5: {
                    if ((var5_6 = (var4_4 = this.tmpRead[var2_2++]) & 127) == 0) {
                        return;
                    }
                    if ((var4_4 & 128) == 0) break block5;
                    while (true) {
                        if (var5_6-- <= 0) ** GOTO lbl-1000
                        var1_1[var3_3++] = this.tmpRead[var2_2++];
                    }
                }
                var4_4 = this.tmpRead[var2_2++];
                while (true) {
                    if (var5_6-- <= 0) continue block0;
                    var1_1[var3_3++] = var4_4;
                }
                break;
            }
        }
        var4_5 = var2_2 * this.header.xsize + var3_3 * this.header.xsize * this.header.ysize;
        System.arraycopy(this.tmpData, var4_5, var1_1, 0, this.header.xsize);
    }

    private void bwtorgba(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[4 * i2 + n2] = byArray[i2];
            byArray2[4 * i2 + n2 + 1] = byArray[i2];
            byArray2[4 * i2 + n2 + 2] = byArray[i2];
            byArray2[4 * i2 + n2 + 3] = -1;
        }
    }

    private void latorgba(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[4 * i2 + n2] = byArray[i2];
            byArray3[4 * i2 + n2 + 1] = byArray[i2];
            byArray3[4 * i2 + n2 + 2] = byArray[i2];
            byArray3[4 * i2 + n2 + 3] = byArray2[i2];
        }
    }

    private void rgbtorgba(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2) {
        for (int i2 = 0; i2 < byArray3.length; ++i2) {
            byArray4[4 * i2 + n2] = byArray[i2];
            byArray4[4 * i2 + n2 + 1] = byArray2[i2];
            byArray4[4 * i2 + n2 + 2] = byArray3[i2];
            byArray4[4 * i2 + n2 + 3] = -1;
        }
    }

    private void rgbatorgba(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n2) {
        for (int i2 = 0; i2 < byArray3.length; ++i2) {
            byArray5[4 * i2 + n2] = byArray[i2];
            byArray5[4 * i2 + n2 + 1] = byArray2[i2];
            byArray5[4 * i2 + n2 + 2] = byArray3[i2];
            byArray5[4 * i2 + n2 + 3] = byArray4[i2];
        }
    }

    private static byte imgref(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        return byArray[n5 * n6 * n4 + n5 * n3 + n2];
    }

    private void writeHeader(DataOutputStream dataOutputStream, int n2, int n3, int n4, boolean bl) {
        dataOutputStream.writeShort(474);
        dataOutputStream.write(bl ? 1 : 0);
        dataOutputStream.write(1);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(n4);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(255);
        dataOutputStream.writeInt(0);
        for (n2 = 0; n2 < 80; ++n2) {
            dataOutputStream.write(0);
        }
        dataOutputStream.writeInt(0);
        for (n2 = 0; n2 < 404; ++n2) {
            dataOutputStream.write(0);
        }
    }

    private void writeImage(File file, byte[] byArray, int n2, int n3, int n4, boolean bl) {
        int n5;
        byte[] byArray2 = new byte[n2 * n3 * n4];
        int n6 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = i2; i3 < n2 * n3 * n4; i3 += n4) {
                byArray2[n6++] = byArray[i3];
            }
        }
        byArray = byArray2;
        int[] nArray = new int[n3 * n4];
        int[] nArray2 = new int[n3 * n4];
        byArray2 = new byte[2 * n2 * n3 * n4];
        n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        int n10 = n3;
        if (bl) {
            n8 = n3 - 1;
            n10 = -1;
            n9 = -1;
        }
        for (int i4 = 0; i4 < n4; ++i4) {
            for (int i5 = n8; i5 != n10; i5 += n9) {
                int n11;
                int n12 = 0;
                boolean bl2 = false;
                int n13 = n7;
                int n14 = n7++;
                byte by = 0;
                for (n5 = 0; n5 < n2; ++n5) {
                    boolean bl3 = false;
                    if (bl2) {
                        if (SGIImage.imgref(byArray, n5, i5, i4, n2, n3, n4) != by) {
                            bl3 = true;
                        }
                    } else if (n5 + 3 < n2) {
                        bl3 = true;
                        for (n11 = 1; n11 <= 3; ++n11) {
                            if (SGIImage.imgref(byArray, n5, i5, i4, n2, n3, n4) == SGIImage.imgref(byArray, n5 + n11, i5, i4, n2, n3, n4)) continue;
                            bl3 = false;
                        }
                    }
                    if (bl3 || n12 == 127) {
                        if (n5 > 0) {
                            byArray2[n14] = bl2 ? n12 : (byte)(n12 | 0x80);
                        }
                        if (bl2) {
                            if (bl3) {
                                bl2 = false;
                            }
                            byArray2[n7++] = by;
                        } else {
                            if (bl3) {
                                bl2 = true;
                            }
                            by = SGIImage.imgref(byArray, n5, i5, i4, n2, n3, n4);
                        }
                        if (n5 > 0) {
                            n14 = n7++;
                            n12 = 0;
                        }
                    }
                    if (!bl2) {
                        byArray2[n7++] = SGIImage.imgref(byArray, n5, i5, i4, n2, n3, n4);
                    }
                    n12 = (byte)(n12 + 1);
                    if (n5 != n2 - 1) continue;
                    if (bl2) {
                        byArray2[n14] = n12;
                        byArray2[n7++] = by;
                    } else {
                        byArray2[n14] = (byte)(n12 | 0x80);
                    }
                    byArray2[n7++] = 0;
                }
                n11 = n7 - n13;
                if (bl) {
                    nArray2[n3 * i4 + (n3 - i5 - 1)] = n11;
                } else {
                    nArray2[n3 * i4 + i5] = n11;
                }
                if (bl) {
                    nArray[n3 * i4 + (n3 - i5 - 1)] = n6;
                } else {
                    nArray[n3 * i4 + i5] = n6;
                }
                n6 += n11;
            }
        }
        int n15 = n7;
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.writeHeader(dataOutputStream, n2, n3, n4, true);
        for (n5 = 0; n5 < n3 * n4; ++n5) {
            dataOutputStream.writeInt(nArray[n5] + 512 + (2 * n3 * n4 << 2));
        }
        for (n5 = 0; n5 < n3 * n4; ++n5) {
            dataOutputStream.writeInt(nArray2[n5]);
        }
        for (n5 = 0; n5 < n15; ++n5) {
            dataOutputStream.write(byArray2[n5]);
        }
        dataOutputStream.close();
    }

    private byte[] readAll(DataInputStream dataInputStream) {
        byte[] byArray;
        int n2;
        byte[] byArray2 = new byte[16384];
        int n3 = 0;
        do {
            n2 = dataInputStream.read(byArray2, n3, byArray2.length - n3);
            if (n3 == byArray2.length) {
                byArray = new byte[2 * byArray2.length];
                System.arraycopy(byArray2, 0, byArray, 0, n3);
                byArray2 = byArray;
            }
            if (n2 <= 0) continue;
            n3 += n2;
        } while (!(n2 == -1 || dataInputStream.available() == 0));
        if (n3 != byArray2.length) {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            byArray2 = byArray;
        }
        return byArray2;
    }
}

