/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture.spi;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.spi.DDSImage$Header;
import com.sun.opengl.util.texture.spi.DDSImage$ImageInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class DDSImage {
    private FileInputStream fis;
    private FileChannel chan;
    private ByteBuffer buf;
    private DDSImage$Header header;
    public static final int DDSD_CAPS = 1;
    public static final int DDSD_HEIGHT = 2;
    public static final int DDSD_WIDTH = 4;
    public static final int DDSD_PITCH = 8;
    public static final int DDSD_BACKBUFFERCOUNT = 32;
    public static final int DDSD_ZBUFFERBITDEPTH = 64;
    public static final int DDSD_ALPHABITDEPTH = 128;
    public static final int DDSD_LPSURFACE = 2048;
    public static final int DDSD_PIXELFORMAT = 4096;
    public static final int DDSD_MIPMAPCOUNT = 131072;
    public static final int DDSD_LINEARSIZE = 524288;
    public static final int DDSD_DEPTH = 0x800000;
    public static final int DDPF_ALPHAPIXELS = 1;
    public static final int DDPF_ALPHA = 2;
    public static final int DDPF_FOURCC = 4;
    public static final int DDPF_PALETTEINDEXED4 = 8;
    public static final int DDPF_PALETTEINDEXEDTO8 = 16;
    public static final int DDPF_PALETTEINDEXED8 = 32;
    public static final int DDPF_RGB = 64;
    public static final int DDPF_COMPRESSED = 128;
    public static final int DDPF_RGBTOYUV = 256;
    public static final int DDPF_YUV = 512;
    public static final int DDPF_ZBUFFER = 1024;
    public static final int DDPF_PALETTEINDEXED1 = 2048;
    public static final int DDPF_PALETTEINDEXED2 = 4096;
    public static final int DDPF_ZPIXELS = 8192;
    public static final int DDSCAPS_TEXTURE = 4096;
    public static final int DDSCAPS_MIPMAP = 0x400000;
    public static final int DDSCAPS_COMPLEX = 8;
    public static final int DDSCAPS2_CUBEMAP = 512;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEX = 1024;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEX = 2048;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEY = 4096;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEY = 8192;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEZ = 16384;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEZ = 32768;
    public static final int D3DFMT_UNKNOWN = 0;
    public static final int D3DFMT_R8G8B8 = 20;
    public static final int D3DFMT_A8R8G8B8 = 21;
    public static final int D3DFMT_X8R8G8B8 = 22;
    public static final int D3DFMT_DXT1 = 827611204;
    public static final int D3DFMT_DXT2 = 844388420;
    public static final int D3DFMT_DXT3 = 861165636;
    public static final int D3DFMT_DXT4 = 877942852;
    public static final int D3DFMT_DXT5 = 894720068;
    private static final int MAGIC = 542327876;

    public static DDSImage read(String string) {
        return DDSImage.read(new File(string));
    }

    public static DDSImage read(File file) {
        DDSImage dDSImage = new DDSImage();
        dDSImage.readFromFile(file);
        return dDSImage;
    }

    public static DDSImage read(ByteBuffer byteBuffer) {
        DDSImage dDSImage = new DDSImage();
        dDSImage.readFromBuffer(byteBuffer);
        return dDSImage;
    }

    public void close() {
        try {
            if (this.chan != null) {
                this.chan.close();
                this.chan = null;
            }
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
            this.buf = null;
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public static DDSImage createFromData(int n2, int n3, int n4, ByteBuffer[] byteBufferArray) {
        DDSImage dDSImage = new DDSImage();
        dDSImage.initFromData(n2, n3, n4, byteBufferArray);
        return dDSImage;
    }

    public static boolean isDDSImage(InputStream inputStream) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!inputStream.markSupported()) {
            throw new IOException("Can not test non-destructively whether given InputStream is a DDS image");
        }
        inputStream.mark(4);
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = inputStream.read();
            if (n3 < 0) {
                inputStream.reset();
                return false;
            }
            n2 = n2 >>> 8 | n3 << 24;
        }
        inputStream.reset();
        return n2 == 542327876;
    }

    public void write(String string) {
        this.write(new File(string));
    }

    public void write(File object) {
        object = new FileOutputStream((File)object);
        FileChannel fileChannel = ((FileOutputStream)object).getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(DDSImage$Header.access$000());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.header.write(byteBuffer);
        byteBuffer.rewind();
        fileChannel.write(byteBuffer);
        this.buf.position(DDSImage$Header.access$000());
        fileChannel.write(this.buf);
        fileChannel.force(true);
        fileChannel.close();
        ((FileOutputStream)object).close();
    }

    public boolean isSurfaceDescFlagSet(int n2) {
        return (this.header.flags & n2) != 0;
    }

    public boolean isPixelFormatFlagSet(int n2) {
        return (this.header.pfFlags & n2) != 0;
    }

    public int getPixelFormat() {
        if (this.isCompressed()) {
            return this.getCompressionFormat();
        }
        if (this.isPixelFormatFlagSet(64)) {
            if (this.isPixelFormatFlagSet(1)) {
                if (this.getDepth() == 32 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255 && this.header.pfABitMask == -16777216) {
                    return 21;
                }
            } else {
                if (this.getDepth() == 24 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255) {
                    return 20;
                }
                if (this.getDepth() == 32 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255) {
                    return 22;
                }
            }
        }
        return 0;
    }

    public boolean isCubemap() {
        return (this.header.ddsCaps1 & 8) != 0 && (this.header.ddsCaps2 & 0x200) != 0;
    }

    public boolean isCubemapSidePresent(int n2) {
        return this.isCubemap() && (this.header.ddsCaps2 & n2) != 0;
    }

    public boolean isCompressed() {
        return this.isPixelFormatFlagSet(4);
    }

    public int getCompressionFormat() {
        return this.header.pfFourCC;
    }

    public int getWidth() {
        return this.header.width;
    }

    public int getHeight() {
        return this.header.height;
    }

    public int getDepth() {
        return this.header.pfRGBBitCount;
    }

    public int getNumMipMaps() {
        if (!this.isSurfaceDescFlagSet(131072)) {
            return 0;
        }
        return this.header.mipMapCountOrAux;
    }

    public DDSImage$ImageInfo getMipMap(int n2) {
        return this.getMipMap(0, n2);
    }

    public DDSImage$ImageInfo getMipMap(int n2, int n3) {
        if (!this.isCubemap() && n2 != 0) {
            throw new RuntimeException(new StringBuffer("Illegal side for 2D texture: ").append(n2).toString());
        }
        if (this.isCubemap() && !this.isCubemapSidePresent(n2)) {
            throw new RuntimeException(new StringBuffer("Illegal side, side not present: ").append(n2).toString());
        }
        if (this.getNumMipMaps() > 0 && (n3 < 0 || n3 >= this.getNumMipMaps())) {
            throw new RuntimeException(new StringBuffer("Illegal mipmap number ").append(n3).append(" (0..").append(this.getNumMipMaps() - 1).append(")").toString());
        }
        int n4 = DDSImage$Header.access$000();
        if (this.isCubemap()) {
            n4 += this.sideShiftInBytes(n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += this.mipMapSizeInBytes(n2);
        }
        this.buf.limit(n4 + this.mipMapSizeInBytes(n3));
        this.buf.position(n4);
        ByteBuffer byteBuffer = this.buf.slice();
        this.buf.position(0);
        this.buf.limit(this.buf.capacity());
        return new DDSImage$ImageInfo(byteBuffer, this.mipMapWidth(n3), this.mipMapHeight(n3), this.isCompressed(), this.getCompressionFormat());
    }

    public DDSImage$ImageInfo[] getAllMipMaps() {
        return this.getAllMipMaps(0);
    }

    public DDSImage$ImageInfo[] getAllMipMaps(int n2) {
        int n3 = this.getNumMipMaps();
        if (n3 == 0) {
            n3 = 1;
        }
        DDSImage$ImageInfo[] dDSImage$ImageInfoArray = new DDSImage$ImageInfo[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dDSImage$ImageInfoArray[i2] = this.getMipMap(n2, i2);
        }
        return dDSImage$ImageInfoArray;
    }

    public static String getCompressionFormatName(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < 4; ++i2) {
            char c2 = (char)(n2 & 0xFF);
            stringBuffer.append(c2);
            n2 >>= 8;
        }
        return stringBuffer.toString();
    }

    public static ByteBuffer allocateBlankBuffer(int n2, int n3, int n4) {
        n2 *= n3;
        switch (n4) {
            case 33776: 
            case 33777: {
                n2 /= 2;
                break;
            }
            case 33778: 
            case 33779: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("Illegal OpenGL texture internal format ").append(n4).toString());
            }
        }
        if (n2 == 0) {
            n2 = 1;
        }
        return BufferUtil.newByteBuffer(n2);
    }

    public void debugPrint() {
        PrintStream printStream = System.err;
        printStream.println(new StringBuffer("Compressed texture: ").append(this.isCompressed()).toString());
        if (this.isCompressed()) {
            int n2 = this.getCompressionFormat();
            String string = DDSImage.getCompressionFormatName(n2);
            printStream.println(new StringBuffer("Compression format: 0x").append(Integer.toHexString(n2)).append(" (").append(string).append(")").toString());
        }
        printStream.println(new StringBuffer("Width: ").append(this.header.width).append(" Height: ").append(this.header.height).toString());
        printStream.println(new StringBuffer("header.pitchOrLinearSize: ").append(this.header.pitchOrLinearSize).toString());
        printStream.println(new StringBuffer("header.pfRBitMask: 0x").append(Integer.toHexString(this.header.pfRBitMask)).toString());
        printStream.println(new StringBuffer("header.pfGBitMask: 0x").append(Integer.toHexString(this.header.pfGBitMask)).toString());
        printStream.println(new StringBuffer("header.pfBBitMask: 0x").append(Integer.toHexString(this.header.pfBBitMask)).toString());
        printStream.println("SurfaceDesc flags:");
        if (!(false | this.printIfRecognized(printStream, this.header.flags, 1, "DDSD_CAPS") | this.printIfRecognized(printStream, this.header.flags, 2, "DDSD_HEIGHT") | this.printIfRecognized(printStream, this.header.flags, 4, "DDSD_WIDTH") | this.printIfRecognized(printStream, this.header.flags, 8, "DDSD_PITCH") | this.printIfRecognized(printStream, this.header.flags, 32, "DDSD_BACKBUFFERCOUNT") | this.printIfRecognized(printStream, this.header.flags, 64, "DDSD_ZBUFFERBITDEPTH") | this.printIfRecognized(printStream, this.header.flags, 128, "DDSD_ALPHABITDEPTH") | this.printIfRecognized(printStream, this.header.flags, 2048, "DDSD_LPSURFACE") | this.printIfRecognized(printStream, this.header.flags, 4096, "DDSD_PIXELFORMAT") | this.printIfRecognized(printStream, this.header.flags, 131072, "DDSD_MIPMAPCOUNT") | this.printIfRecognized(printStream, this.header.flags, 524288, "DDSD_LINEARSIZE") | this.printIfRecognized(printStream, this.header.flags, 0x800000, "DDSD_DEPTH"))) {
            printStream.println("(none)");
        }
        printStream.println(new StringBuffer("Raw SurfaceDesc flags: 0x").append(Integer.toHexString(this.header.flags)).toString());
        printStream.println("Pixel format flags:");
        if (!(false | this.printIfRecognized(printStream, this.header.pfFlags, 1, "DDPF_ALPHAPIXELS") | this.printIfRecognized(printStream, this.header.pfFlags, 2, "DDPF_ALPHA") | this.printIfRecognized(printStream, this.header.pfFlags, 4, "DDPF_FOURCC") | this.printIfRecognized(printStream, this.header.pfFlags, 8, "DDPF_PALETTEINDEXED4") | this.printIfRecognized(printStream, this.header.pfFlags, 16, "DDPF_PALETTEINDEXEDTO8") | this.printIfRecognized(printStream, this.header.pfFlags, 32, "DDPF_PALETTEINDEXED8") | this.printIfRecognized(printStream, this.header.pfFlags, 64, "DDPF_RGB") | this.printIfRecognized(printStream, this.header.pfFlags, 128, "DDPF_COMPRESSED") | this.printIfRecognized(printStream, this.header.pfFlags, 256, "DDPF_RGBTOYUV") | this.printIfRecognized(printStream, this.header.pfFlags, 512, "DDPF_YUV") | this.printIfRecognized(printStream, this.header.pfFlags, 1024, "DDPF_ZBUFFER") | this.printIfRecognized(printStream, this.header.pfFlags, 2048, "DDPF_PALETTEINDEXED1") | this.printIfRecognized(printStream, this.header.pfFlags, 4096, "DDPF_PALETTEINDEXED2") | this.printIfRecognized(printStream, this.header.pfFlags, 8192, "DDPF_ZPIXELS"))) {
            printStream.println("(none)");
        }
        printStream.println(new StringBuffer("Raw pixel format flags: 0x").append(Integer.toHexString(this.header.pfFlags)).toString());
        printStream.println(new StringBuffer("Depth: ").append(this.getDepth()).toString());
        printStream.println(new StringBuffer("Number of mip maps: ").append(this.getNumMipMaps()).toString());
        int n3 = this.getPixelFormat();
        printStream.print("Pixel format: ");
        switch (n3) {
            case 20: {
                printStream.println("D3DFMT_R8G8B8");
                return;
            }
            case 21: {
                printStream.println("D3DFMT_A8R8G8B8");
                return;
            }
            case 22: {
                printStream.println("D3DFMT_X8R8G8B8");
                return;
            }
            case 827611204: {
                printStream.println("D3DFMT_DXT1");
                return;
            }
            case 844388420: {
                printStream.println("D3DFMT_DXT2");
                return;
            }
            case 861165636: {
                printStream.println("D3DFMT_DXT3");
                return;
            }
            case 877942852: {
                printStream.println("D3DFMT_DXT4");
                return;
            }
            case 894720068: {
                printStream.println("D3DFMT_DXT5");
                return;
            }
            case 0: {
                printStream.println("D3DFMT_UNKNOWN");
                return;
            }
        }
        printStream.println(new StringBuffer("(unknown pixel format ").append(n3).append(")").toString());
    }

    private DDSImage() {
    }

    private void readFromFile(File comparable) {
        this.fis = new FileInputStream((File)comparable);
        this.chan = this.fis.getChannel();
        comparable = this.chan.map(FileChannel.MapMode.READ_ONLY, 0L, (int)comparable.length());
        this.readFromBuffer((ByteBuffer)comparable);
    }

    private void readFromBuffer(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.header = new DDSImage$Header();
        this.header.read(byteBuffer);
        this.fixupHeader();
    }

    private void initFromData(int n2, int n3, int n4, ByteBuffer[] byteBufferArray) {
        int n5;
        int n6 = n3 * n4;
        boolean bl = false;
        switch (n2) {
            case 20: {
                n6 *= 3;
                n5 = n3 * 3;
                break;
            }
            case 21: {
                n6 <<= 2;
                n5 = n3 << 2;
                break;
            }
            case 22: {
                n6 <<= 2;
                n5 = n3 << 2;
                break;
            }
            case 827611204: 
            case 844388420: 
            case 861165636: 
            case 877942852: 
            case 894720068: {
                n5 = n6 = DDSImage.computeCompressedBlockSize(n3, n4, 1, n2);
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("d3dFormat must be one of the known formats");
            }
        }
        int n7 = 0;
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            if (byteBufferArray[i2].remaining() != n6) {
                throw new IllegalArgumentException(new StringBuffer("Mipmap level ").append(i2).append(" didn't match expected data size (expected ").append(n6).append(", got ").append(byteBufferArray[i2].remaining()).append(")").toString());
            }
            n6 /= 4;
            n7 += byteBufferArray[i2].remaining();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n7 + DDSImage$Header.access$000());
        byteBuffer.position(DDSImage$Header.access$000());
        for (n6 = 0; n6 < byteBufferArray.length; ++n6) {
            byteBuffer.put(byteBufferArray[n6]);
        }
        this.buf = byteBuffer;
        this.header = new DDSImage$Header();
        this.header.size = DDSImage$Header.access$100();
        this.header.flags = 4103;
        if (byteBufferArray.length > 1) {
            this.header.flags |= 0x20000;
            this.header.mipMapCountOrAux = byteBufferArray.length;
        }
        this.header.width = n3;
        this.header.height = n4;
        if (bl) {
            this.header.flags |= 0x80000;
            this.header.pfFlags |= 4;
            this.header.pfFourCC = n2;
        } else {
            this.header.flags |= 8;
            this.header.pfFlags |= 0x40;
            switch (n2) {
                case 20: {
                    this.header.pfRGBBitCount = 24;
                    break;
                }
                case 21: {
                    this.header.pfRGBBitCount = 32;
                    this.header.pfFlags |= 1;
                    break;
                }
                case 22: {
                    this.header.pfRGBBitCount = 32;
                }
            }
            this.header.pfRBitMask = 0xFF0000;
            this.header.pfGBitMask = 65280;
            this.header.pfBBitMask = 255;
            if (n2 == 21) {
                this.header.pfABitMask = -16777216;
            }
        }
        this.header.pitchOrLinearSize = n5;
        this.header.pfSize = DDSImage$Header.access$200();
    }

    private void fixupHeader() {
        if (this.isCompressed() && !this.isSurfaceDescFlagSet(524288)) {
            int n2 = this.header.backBufferCountOrDepth;
            if (n2 == 0) {
                n2 = 1;
            }
            this.header.pitchOrLinearSize = DDSImage.computeCompressedBlockSize(this.getWidth(), this.getHeight(), n2, this.getCompressionFormat());
            this.header.flags |= 0x80000;
        }
    }

    private static int computeCompressedBlockSize(int n2, int n3, int n4, int n5) {
        n2 = (n2 + 3) / 4 * ((n3 + 3) / 4) * ((n4 + 3) / 4);
        switch (n5) {
            case 827611204: {
                n2 <<= 3;
                break;
            }
            default: {
                n2 <<= 4;
            }
        }
        return n2;
    }

    private int mipMapWidth(int n2) {
        int n3 = this.getWidth();
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 >>= 1;
        }
        return Math.max(n3, 1);
    }

    private int mipMapHeight(int n2) {
        int n3 = this.getHeight();
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 >>= 1;
        }
        return Math.max(n3, 1);
    }

    private int mipMapSizeInBytes(int n2) {
        int n3 = this.mipMapWidth(n2);
        n2 = this.mipMapHeight(n2);
        if (this.isCompressed()) {
            int n4 = this.getCompressionFormat() == 827611204 ? 8 : 16;
            return (n3 + 3) / 4 * ((n2 + 3) / 4) * n4;
        }
        return n3 * n2 * (this.getDepth() / 8);
    }

    private int sideSizeInBytes() {
        int n2 = this.getNumMipMaps();
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.mipMapSizeInBytes(i2);
        }
        return n3;
    }

    private int sideShiftInBytes(int n2) {
        int[] nArray = new int[]{1024, 2048, 4096, 8192, 16384, 32768};
        int n3 = 0;
        int n4 = this.sideSizeInBytes();
        for (int i2 = 0; i2 < 6; ++i2) {
            if ((nArray[i2] & n2) != 0) {
                return n3;
            }
            n3 += n4;
        }
        throw new RuntimeException(new StringBuffer("Illegal side: ").append(n2).toString());
    }

    private boolean printIfRecognized(PrintStream printStream, int n2, int n3, String string) {
        if ((n2 & n3) != 0) {
            printStream.println(string);
            return true;
        }
        return false;
    }
}

