/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import java.awt.Dimension;
import java.nio.Buffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class TileRenderer {
    private static final int DEFAULT_TILE_WIDTH = 256;
    private static final int DEFAULT_TILE_HEIGHT = 256;
    private static final int DEFAULT_TILE_BORDER = 0;
    public static final int TR_TILE_WIDTH = 0;
    public static final int TR_TILE_HEIGHT = 1;
    public static final int TR_TILE_BORDER = 2;
    public static final int TR_IMAGE_WIDTH = 3;
    public static final int TR_IMAGE_HEIGHT = 4;
    public static final int TR_ROWS = 5;
    public static final int TR_COLUMNS = 6;
    public static final int TR_CURRENT_ROW = 7;
    public static final int TR_CURRENT_COLUMN = 8;
    public static final int TR_CURRENT_TILE_WIDTH = 9;
    public static final int TR_CURRENT_TILE_HEIGHT = 10;
    public static final int TR_ROW_ORDER = 11;
    public static final int TR_TOP_TO_BOTTOM = 1;
    public static final int TR_BOTTOM_TO_TOP = 2;
    private Dimension imageSize = new Dimension();
    private int imageFormat;
    private int imageType;
    private Buffer imageBuffer;
    private Dimension tileSize = new Dimension();
    private Dimension tileSizeNB = new Dimension();
    private int tileBorder;
    private int tileFormat;
    private int tileType;
    private Buffer tileBuffer;
    private boolean perspective;
    private double left;
    private double right;
    private double bottom;
    private double top;
    private double near;
    private double far;
    private int rowOrder;
    private int rows;
    private int columns;
    private int currentTile;
    private int currentTileWidth;
    private int currentTileHeight;
    private int currentRow;
    private int currentColumn;
    private int[] viewportSave = new int[4];

    public TileRenderer() {
        this.tileSize.width = 256;
        this.tileSize.height = 256;
        this.tileBorder = 0;
        this.rowOrder = 2;
        this.currentTile = -1;
    }

    private void setup() {
        this.columns = (this.imageSize.width + this.tileSizeNB.width - 1) / this.tileSizeNB.width;
        this.rows = (this.imageSize.height + this.tileSizeNB.height - 1) / this.tileSizeNB.height;
        this.currentTile = 0;
        assert (this.columns >= 0);
        assert (this.rows >= 0);
    }

    public void setTileSize(int n2, int n3, int n4) {
        assert (n4 >= 0);
        assert (n2 > 0);
        assert (n3 > 0);
        assert (n2 >= 2 * n4);
        assert (n3 >= 2 * n4);
        this.tileBorder = n4;
        this.tileSize.width = n2;
        this.tileSize.height = n3;
        this.tileSizeNB.width = n2 - 2 * n4;
        this.tileSizeNB.height = n3 - 2 * n4;
        this.setup();
    }

    public void setTileBuffer(int n2, int n3, Buffer buffer) {
        this.tileFormat = n2;
        this.tileType = n3;
        this.tileBuffer = buffer;
    }

    public void setImageSize(int n2, int n3) {
        this.imageSize.width = n2;
        this.imageSize.height = n3;
        this.setup();
    }

    public void setImageBuffer(int n2, int n3, Buffer buffer) {
        this.imageFormat = n2;
        this.imageType = n3;
        this.imageBuffer = buffer;
    }

    public int getParam(int n2) {
        switch (n2) {
            case 0: {
                return this.tileSize.width;
            }
            case 1: {
                return this.tileSize.height;
            }
            case 2: {
                return this.tileBorder;
            }
            case 3: {
                return this.imageSize.width;
            }
            case 4: {
                return this.imageSize.height;
            }
            case 5: {
                return this.rows;
            }
            case 6: {
                return this.columns;
            }
            case 7: {
                if (this.currentTile < 0) {
                    return -1;
                }
                return this.currentRow;
            }
            case 8: {
                if (this.currentTile < 0) {
                    return -1;
                }
                return this.currentColumn;
            }
            case 9: {
                return this.currentTileWidth;
            }
            case 10: {
                return this.currentTileHeight;
            }
            case 11: {
                return this.rowOrder;
            }
        }
        throw new IllegalArgumentException("Invalid enumerant as argument");
    }

    public void setRowOrder(int n2) {
        if (n2 == 1 || n2 == 2) {
            this.rowOrder = n2;
            return;
        }
        throw new IllegalArgumentException("Must pass TR_TOP_TO_BOTTOM or TR_BOTTOM_TO_TOP");
    }

    public void trOrtho(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.perspective = false;
        this.left = d2;
        this.right = d3;
        this.bottom = d4;
        this.top = d5;
        this.near = d6;
        this.far = d7;
    }

    public void trFrustum(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.perspective = true;
        this.left = d2;
        this.right = d3;
        this.bottom = d4;
        this.top = d5;
        this.near = d6;
        this.far = d7;
    }

    public void trPerspective(double d2, double d3, double d4, double d5) {
        double d6 = d4 * Math.tan(d2 * 3.14159265 / 360.0);
        double d7 = -d6;
        double d8 = d7 * d3;
        double d9 = d6 * d3;
        this.trFrustum(d8, d9, d7, d6, d4, d5);
    }

    public void beginTile(GL gL) {
        if (this.currentTile <= 0) {
            this.setup();
            gL.glGetIntegerv(2978, this.viewportSave, 0);
        }
        if (this.rowOrder == 2) {
            this.currentRow = this.currentTile / this.columns;
            this.currentColumn = this.currentTile % this.columns;
        } else {
            this.currentRow = this.rows - this.currentTile / this.columns - 1;
            this.currentColumn = this.currentTile % this.columns;
        }
        assert (this.currentRow < this.rows);
        assert (this.currentColumn < this.columns);
        int n2 = this.tileBorder;
        int n3 = this.currentRow < this.rows - 1 ? this.tileSize.height : this.imageSize.height - (this.rows - 1) * this.tileSizeNB.height + 2 * n2;
        int n4 = this.currentColumn < this.columns - 1 ? this.tileSize.width : this.imageSize.width - (this.columns - 1) * this.tileSizeNB.width + 2 * n2;
        this.currentTileWidth = n4;
        this.currentTileHeight = n3;
        gL.glViewport(0, 0, n4, n3);
        int[] nArray = new int[1];
        gL.glGetIntegerv(2976, nArray, 0);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        double d2 = this.left + (this.right - this.left) * (double)(this.currentColumn * this.tileSizeNB.width - n2) / (double)this.imageSize.width;
        double d3 = d2 + (this.right - this.left) * (double)n4 / (double)this.imageSize.width;
        double d4 = this.bottom + (this.top - this.bottom) * (double)(this.currentRow * this.tileSizeNB.height - n2) / (double)this.imageSize.height;
        double d5 = d4 + (this.top - this.bottom) * (double)n3 / (double)this.imageSize.height;
        if (this.perspective) {
            gL.glFrustum(d2, d3, d4, d5, this.near, this.far);
        } else {
            gL.glOrtho(d2, d3, d4, d5, this.near, this.far);
        }
        gL.glMatrixMode(nArray[0]);
    }

    public boolean endTile(GL gL) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        assert (this.currentTile >= 0);
        gL.glFlush();
        gL.glGetIntegerv(3330, nArray, 0);
        gL.glGetIntegerv(3331, nArray2, 0);
        gL.glGetIntegerv(3332, nArray3, 0);
        gL.glGetIntegerv(3333, nArray4, 0);
        if (this.tileBuffer != null) {
            n5 = this.tileBorder;
            n4 = this.tileBorder;
            n3 = this.tileSizeNB.width;
            n2 = this.tileSizeNB.height;
            gL.glReadPixels(n5, n4, n3, n2, this.tileFormat, this.tileType, this.tileBuffer);
        }
        if (this.imageBuffer != null) {
            n5 = this.tileBorder;
            n4 = this.tileBorder;
            n3 = this.currentTileWidth - 2 * this.tileBorder;
            n2 = this.currentTileHeight - 2 * this.tileBorder;
            int n6 = this.tileSizeNB.width * this.currentColumn;
            int n7 = this.tileSizeNB.height * this.currentRow;
            gL.glPixelStorei(3330, this.imageSize.width);
            gL.glPixelStorei(3331, n7);
            gL.glPixelStorei(3332, n6);
            gL.glPixelStorei(3333, 1);
            gL.glReadPixels(n5, n4, n3, n2, this.imageFormat, this.imageType, this.imageBuffer);
        }
        gL.glPixelStorei(3330, nArray[0]);
        gL.glPixelStorei(3331, nArray2[0]);
        gL.glPixelStorei(3332, nArray3[0]);
        gL.glPixelStorei(3333, nArray4[0]);
        ++this.currentTile;
        if (this.currentTile >= this.rows * this.columns) {
            gL.glViewport(this.viewportSave[0], this.viewportSave[1], this.viewportSave[2], this.viewportSave[3]);
            this.currentTile = -1;
            return false;
        }
        return true;
    }

    public void trRasterPos3f(float f2, float f3, float f4, GL gL, GLU gLU) {
        if (this.currentTile < 0) {
            gL.glRasterPos3f(f2, f3, f4);
            return;
        }
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        double[] dArray3 = new double[3];
        gL.glGetDoublev(2982, dArray, 0);
        gL.glGetDoublev(2983, dArray2, 0);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = this.currentTileWidth;
        nArray[3] = this.currentTileHeight;
        if (gLU.gluProject(f2, f3, f4, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0)) {
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            gL.glOrtho(0.0, this.currentTileWidth, 0.0, this.currentTileHeight, 0.0, 1.0);
            gL.glRasterPos3d(0.0, 0.0, -dArray3[2]);
            byte[] byArray = new byte[]{0};
            gL.glBitmap(1, 1, 0.0f, 0.0f, (float)dArray3[0], (float)dArray3[1], byArray, 0);
            gL.glPopMatrix();
            gL.glMatrixMode(5888);
            gL.glPopMatrix();
        }
    }
}

