/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.util.JOGLAppletLauncher$1;
import com.sun.opengl.util.JOGLAppletLauncher$2;
import com.sun.opengl.util.JOGLAppletLauncher$3;
import com.sun.opengl.util.JOGLAppletLauncher$4;
import com.sun.opengl.util.JOGLAppletLauncher$5;
import com.sun.opengl.util.JOGLAppletLauncher$6;
import com.sun.opengl.util.JOGLAppletLauncher$AppletStubProxy;
import com.sun.opengl.util.JOGLAppletLauncher$NativeLibInfo;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JOGLAppletLauncher
extends Applet {
    private static final JOGLAppletLauncher$NativeLibInfo[] allNativeLibInfo;
    private JOGLAppletLauncher$NativeLibInfo nativeLibInfo;
    private String[] nativeLibNames;
    private Applet subApplet;
    private String subAppletClassName;
    private String subAppletDisplayName;
    private String subAppletImageName;
    private String installDirectory;
    private JPanel loaderPanel = new JPanel(new BorderLayout());
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private boolean isInitOk = false;
    private boolean firstStart = true;
    private boolean joglStarted = false;
    private boolean haveJOAL = false;
    private static final String JRE_PREFIX = "deployment.javapi.jre.";
    private static final String NODDRAW_PROP = "-Dsun.java2d.noddraw=true";
    private static final String DONT_ASK = ".dont_ask";
    static Class class$javax$media$opengl$GLDrawableFactory;

    private static String md2Hash(String object) {
        Object object2;
        try {
            object2 = MessageDigest.getInstance("MD2");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
        byte[] byArray = ((MessageDigest)object2).digest(((String)object).getBytes());
        object = byArray;
        if (byArray == null || ((Object)object).length == 0) {
            return "";
        }
        object2 = new StringBuffer();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            ((StringBuffer)object2).append(Integer.toHexString(object[i2] & 0xFF));
        }
        return ((StringBuffer)object2).toString();
    }

    @Override
    public void init() {
        this.subAppletClassName = this.getParameter("subapplet.classname");
        if (this.subAppletClassName == null) {
            this.displayError("Init failed : Missing subapplet.classname argument");
            return;
        }
        this.subAppletDisplayName = this.getParameter("subapplet.displayname");
        if (this.subAppletDisplayName == null) {
            this.subAppletDisplayName = "Applet";
        }
        this.subAppletImageName = this.getParameter("subapplet.image");
        this.initLoaderLayout();
        this.validate();
        String string = this.getCodeBase().toExternalForm();
        String string2 = string.substring(string.indexOf(":") + 3);
        this.installDirectory = new StringBuffer().append(string2.replace(':', '_').replace('.', '_').replace('/', '_').replace('~', '_')).append(JOGLAppletLauncher.md2Hash(this.getParameter("archive"))).toString();
        string2 = System.getProperty("os.name");
        String string3 = System.getProperty("os.arch");
        if (this.checkOSAndArch(string2, string3)) {
            this.isInitOk = true;
            return;
        }
        this.displayError(new StringBuffer("Init failed : Unsupported os / arch ( ").append(string2).append(" / ").append(string3).append(" )").toString());
    }

    private void displayMessage(String string) {
        SwingUtilities.invokeLater(new JOGLAppletLauncher$1(this, string));
    }

    private void displayError(String string) {
        System.err.println(string);
        SwingUtilities.invokeLater(new JOGLAppletLauncher$2(this, string));
    }

    private void setProgress(int n2) {
        SwingUtilities.invokeLater(new JOGLAppletLauncher$3(this, n2));
    }

    private void initLoaderLayout() {
        this.setLayout(new BorderLayout());
        this.progressBar.setBorderPainted(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Loading...");
        boolean bl = false;
        ImageIcon imageIcon = null;
        if (this.subAppletImageName != null) {
            try {
                imageIcon = new ImageIcon(new URL(this.subAppletImageName));
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        if (bl) {
            this.add((Component)this.loaderPanel, "South");
            this.loaderPanel.add((Component)new JLabel(imageIcon), "Center");
            this.loaderPanel.add((Component)this.progressBar, "South");
            return;
        }
        this.add((Component)this.loaderPanel, "South");
        this.loaderPanel.add((Component)this.progressBar, "Center");
    }

    @Override
    public void start() {
        if (this.isInitOk) {
            if (this.firstStart) {
                this.firstStart = false;
                Object object = System.getProperty("user.home");
                try {
                    this.getClass().getClassLoader().loadClass("javax.media.opengl.GL");
                    Package package_ = Package.getPackage("javax.media.opengl");
                    object = new StringBuffer().append((String)object).append(File.separator).append(".jogl_ext").append(File.separator).append(this.installDirectory).append(File.separator).append(package_.getImplementationVersion().replace(':', '_')).toString();
                    object = new File((String)object);
                    object = new JOGLAppletLauncher$4(this, (File)object);
                    ((Thread)object).setPriority(4);
                    ((Thread)object).start();
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Unable to load javax.media.opengl package");
                    System.exit(0);
                    return;
                }
            }
            if (this.joglStarted) {
                this.checkNoDDrawAndUpdateDeploymentProperties();
                this.subApplet.start();
            }
        }
    }

    @Override
    public void stop() {
        if (this.subApplet != null) {
            this.subApplet.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.subApplet != null) {
            this.subApplet.destroy();
        }
    }

    public Applet getSubApplet() {
        return this.subApplet;
    }

    private boolean checkOSAndArch(String string, String string2) {
        for (int i2 = 0; i2 < allNativeLibInfo.length; ++i2) {
            JOGLAppletLauncher$NativeLibInfo jOGLAppletLauncher$NativeLibInfo = allNativeLibInfo[i2];
            if (!jOGLAppletLauncher$NativeLibInfo.matchesOSAndArch(string, string2)) continue;
            this.nativeLibInfo = jOGLAppletLauncher$NativeLibInfo;
            return true;
        }
        return false;
    }

    private boolean getBooleanParameter(String string) {
        if ((string = this.getParameter(string)) == null) {
            return false;
        }
        return !string.toLowerCase().equals("false");
    }

    private void checkNoDDrawAndUpdateDeploymentProperties() {
        if (this.getBooleanParameter("jogl.disable.noddraw.check")) {
            return;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && !"true".equalsIgnoreCase(System.getProperty("sun.java2d.noddraw"))) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new JOGLAppletLauncher$5(this));
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            this.updateDeploymentPropertiesImpl();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateDeploymentPropertiesImpl() {
        Object object = System.getProperty("user.home");
        if (((File)(object = new File(new StringBuffer().append((String)object).append(File.separator).append(".jogl_ext").append(File.separator).append(DONT_ASK).toString()))).exists()) {
            return;
        }
        int n2 = 0;
        if (!this.getBooleanParameter("jogl.silent.noddraw.check")) {
            n2 = JOptionPane.showOptionDialog(null, "For best robustness of JOGL applets on Windows,\nwe recommend disabling Java2D's use of DirectDraw.\nThis setting will affect all applets, but is unlikely\nto slow other applets down significantly. May we update\nyour deployment.properties to turn off DirectDraw for\napplets? You can change this back later if necessary\nusing the Java Control Panel, Java tab, under Java\nApplet Runtime Settings.", "Update deployment.properties?", 1, 3, null, new Object[]{"Yes", "No", "No, Don't Ask Again"}, "Yes");
        }
        if (n2 < 0 || n2 == 1) {
            return;
        }
        if (n2 == 2) {
            try {
                ((File)object).createNewFile();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        try {
            object = new File(new StringBuffer().append(System.getProperty("user.home")).append(File.separator).append("Application Data/Sun/Java/Deployment").toString());
            if (!((File)object).exists()) {
                return;
            }
            if (!((File)(object = new File((File)object, "deployment.properties"))).exists()) {
                return;
            }
            Properties properties = new Properties();
            Object object2 = new BufferedInputStream(new FileInputStream((File)object));
            properties.load((InputStream)object2);
            ((InputStream)object2).close();
            object2 = new HashSet();
            for (String string : properties.keySet()) {
                int n3;
                if (!string.startsWith(JRE_PREFIX) || (n3 = string.lastIndexOf(".")) < 0 || n3 <= 22) continue;
                String string2 = string.substring(22, n3);
                object2.add(string2);
            }
            object2.add(System.getProperty("java.version"));
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                void var5_14;
                String string = (String)object3.next();
                String string3 = new StringBuffer(JRE_PREFIX).append(string).append(".args").toString();
                String string4 = properties.getProperty(string3);
                if (string4 == null) {
                    String string5 = NODDRAW_PROP;
                } else if (string4.indexOf(NODDRAW_PROP) < 0) {
                    String string6 = new StringBuffer().append(string4).append(" -Dsun.java2d.noddraw=true").toString();
                }
                properties.setProperty(string3, (String)var5_14);
            }
            object3 = new BufferedOutputStream(new FileOutputStream((File)object));
            properties.store((OutputStream)object3, null);
            ((OutputStream)object3).close();
            if (!this.getBooleanParameter("jogl.silent.noddraw.check")) {
                JOptionPane.showMessageDialog(null, "For best robustness, we recommend you now exit and\nrestart your web browser. (Note: clicking \"OK\" will\nnot exit your browser.)", "Browser Restart Recommended", 1);
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private void refreshJOGL(File file) {
        try {
            Class.forName(this.subAppletClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.displayError(new StringBuffer("Start failed : class not found : ").append(this.subAppletClassName).toString());
            return;
        }
        if (!file.exists() && !file.mkdirs()) {
            this.displayError(new StringBuffer("Unable to create directories for target: ").append(file).toString());
            return;
        }
        try {
            Class.forName("net.java.games.joal.AL", false, this.getClass().getClassLoader());
            this.haveJOAL = true;
        }
        catch (Exception exception) {}
        String[] stringArray = new String[]{this.nativeLibInfo.formatNativeJarName("jogl-natives-{0}.jar"), this.nativeLibInfo.formatNativeJarName("gluegen-rt-natives-{0}.jar"), this.haveJOAL ? this.nativeLibInfo.formatNativeJarName("joal-natives-{0}.jar") : null};
        for (int i2 = 0; i2 < 3; ++i2) {
            URLConnection uRLConnection;
            String string = stringArray[i2];
            if (string == null) continue;
            Object object = new StringBuffer().append(this.getCodeBase().toExternalForm()).append(string).toString();
            try {
                uRLConnection = new URL((String)object).openConnection();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.displayError(new StringBuffer("Couldn't access the native lib URL : ").append((String)object).toString());
                return;
            }
            if (this.getTimestamp(file, string, uRLConnection.getLastModified()) == uRLConnection.getLastModified()) continue;
            this.displayMessage("Updating local version of the native libraries");
            object = new File(file, string);
            try {
                this.saveNativesJarLocally((File)object, uRLConnection);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.displayError("Unable to install the native file locally");
                return;
            }
            try {
                Object object2;
                int n2;
                JarFile jarFile = new JarFile((File)object);
                if (!this.findNativeEntries(jarFile)) {
                    this.displayError("native libraries not found in jar file");
                    return;
                }
                byte[] byArray = new byte[8192];
                for (n2 = 0; n2 < this.nativeLibNames.length; ++n2) {
                    object2 = jarFile.getJarEntry(this.nativeLibNames[n2]);
                    if (object2 == null) {
                        this.displayError(new StringBuffer("error looking up jar entry ").append(this.nativeLibNames[n2]).toString());
                        return;
                    }
                    if (this.checkNativeCertificates(jarFile, (JarEntry)object2, byArray)) continue;
                    this.displayError(new StringBuffer("Native library ").append(this.nativeLibNames[n2]).append(" isn't properly signed or has other errors").toString());
                    return;
                }
                this.setProgress(0);
                for (n2 = 0; n2 < this.nativeLibNames.length; ++n2) {
                    this.displayMessage(new StringBuffer("Installing native files from ").append(string).toString());
                    if (!this.installFile(file, jarFile, this.nativeLibNames[n2], byArray)) {
                        return;
                    }
                    int n3 = 100 * (n2 + 1) / this.nativeLibNames.length;
                    this.setProgress(n3);
                }
                jarFile.close();
                ((File)object).delete();
                try {
                    File file2 = new File(file, this.getTimestampFileName(string));
                    file2.delete();
                    object2 = new BufferedWriter(new FileWriter(file2));
                    ((Writer)object2).write(new StringBuffer().append(uRLConnection.getLastModified()).toString());
                    ((BufferedWriter)object2).flush();
                    ((BufferedWriter)object2).close();
                    continue;
                }
                catch (Exception exception) {
                    this.displayError("Error writing time stamp for native libraries");
                    return;
                }
            }
            catch (Exception exception) {
                this.displayError(new StringBuffer("Error opening jar file ").append(((File)object).getName()).append(" for reading").toString());
                return;
            }
        }
        this.loadNativesAndStart(file);
    }

    private String getTimestampFileName(String string) {
        return new StringBuffer("timestamp-").append(string.replace('.', '-')).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTimestamp(File object, String object2, long l2) {
        try {
            object2 = this.getTimestampFileName((String)object2);
            object = new BufferedReader(new FileReader(new File((File)object, (String)object2)));
            try {
                object2 = new StreamTokenizer((Reader)object);
                ((StreamTokenizer)object2).resetSyntax();
                ((StreamTokenizer)object2).wordChars(48, 57);
                ((StreamTokenizer)object2).wordChars(45, 45);
                ((StreamTokenizer)object2).nextToken();
                object2 = ((StreamTokenizer)object2).sval;
                if (object2 != null) {
                    long l3 = Long.parseLong((String)object2);
                    return l3;
                }
            }
            catch (Exception exception) {
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (Exception exception) {}
        if (l2 != 0L) return 0L;
        return 1L;
    }

    private void saveNativesJarLocally(File file, URLConnection object) {
        FilterOutputStream filterOutputStream = null;
        InputStream inputStream = null;
        this.displayMessage("Downloading native library");
        this.setProgress(0);
        try {
            int n2;
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n3 = ((URLConnection)object).getContentLength();
            inputStream = ((URLConnection)object).getInputStream();
            object = new byte[1024];
            int n4 = 0;
            while ((n2 = inputStream.read((byte[])object)) > 0) {
                ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n2);
                n4 += n2;
                n2 = n4 * 100 / n3;
                this.setProgress(n2);
            }
            filterOutputStream.close();
            inputStream.close();
        }
        catch (Throwable throwable) {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            filterOutputStream.close();
        }
        catch (IOException iOException) {}
        if (inputStream != null) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private boolean findNativeEntries(JarFile object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        object = ((JarFile)object).entries();
        while (object.hasMoreElements()) {
            JarEntry jarEntry = (JarEntry)object.nextElement();
            if (!this.nativeLibInfo.matchesNativeLib(jarEntry.getName())) continue;
            arrayList.add(jarEntry.getName());
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        this.nativeLibNames = arrayList.toArray(new String[0]);
        return true;
    }

    private boolean checkNativeCertificates(JarFile closeable, JarEntry certificateArray, byte[] byArray) {
        try {
            closeable = ((JarFile)closeable).getInputStream((ZipEntry)certificateArray);
            certificateArray.getSize();
            while (((InputStream)closeable).read(byArray) > 0) {
            }
            ((InputStream)closeable).close();
            closeable = certificateArray.getCertificates();
            certificateArray = (class$javax$media$opengl$GLDrawableFactory == null ? (class$javax$media$opengl$GLDrawableFactory = JOGLAppletLauncher.class$("javax.media.opengl.GLDrawableFactory")) : class$javax$media$opengl$GLDrawableFactory).getProtectionDomain().getCodeSource().getCertificates();
            if (closeable == null || ((Closeable)closeable).length == 0) {
                return false;
            }
            int n2 = 0;
            block3: for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                for (int i3 = 0; i3 < ((Closeable)closeable).length; ++i3) {
                    if (!((Certificate)((Object)closeable[i3])).equals(certificateArray[i2])) continue;
                    ++n2;
                    continue block3;
                }
            }
            return n2 == certificateArray.length;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean installFile(File object, JarFile closeable, String string, byte[] byArray) {
        try {
            Object object2 = ((JarFile)closeable).getJarEntry(string);
            if (object2 == null) {
                this.displayError(new StringBuffer("Error finding native library ").append(string).toString());
                return false;
            }
            closeable = ((JarFile)closeable).getInputStream((ZipEntry)object2);
            ((ZipEntry)object2).getSize();
            object2 = new File((File)object, string);
            boolean n2 = false;
            try {
                boolean bl = ((File)object2).exists();
                object = new BufferedOutputStream(new FileOutputStream((File)object2));
            }
            catch (Exception exception) {
                if (n2) {
                    return true;
                }
                this.displayError(new StringBuffer("Error opening file ").append(string).append(" for writing").toString());
                return false;
            }
            try {
                int n3;
                while ((n3 = ((InputStream)closeable).read(byArray)) > 0) {
                    ((BufferedOutputStream)object).write(byArray, 0, n3);
                }
            }
            catch (IOException iOException) {
                this.displayError(new StringBuffer("Error writing file ").append(string).append(" to disk").toString());
                iOException.printStackTrace();
                ((File)object2).delete();
                return false;
            }
            ((BufferedOutputStream)object).flush();
            ((FilterOutputStream)object).close();
            ((InputStream)closeable).close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayError(new StringBuffer("Error writing file ").append(string).append(" to disk").toString());
            return false;
        }
    }

    private void loadNativesAndStart(File file) {
        SwingUtilities.invokeLater(new JOGLAppletLauncher$6(this, file));
    }

    private void loadLibrary(File serializable, String string) {
        string = this.nativeLibInfo.getNativeLibName(string);
        try {
            System.load(new File((File)serializable, string).getPath());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            serializable = unsatisfiedLinkError;
            unsatisfiedLinkError.printStackTrace();
            throw serializable;
        }
    }

    private void startSubApplet() {
        try {
            this.subApplet = (Applet)Class.forName(this.subAppletClassName).newInstance();
            this.subApplet.setStub(new JOGLAppletLauncher$AppletStubProxy(this));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            this.displayError(new StringBuffer("Class not found (").append(this.subAppletClassName).append(")").toString());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayError(new StringBuffer("Unable to start ").append(this.subAppletDisplayName).toString());
            return;
        }
        this.add((Component)this.subApplet, "Center");
        try {
            this.subApplet.init();
            this.remove(this.loaderPanel);
            this.validate();
            this.checkNoDDrawAndUpdateDeploymentProperties();
            this.subApplet.start();
            this.joglStarted = true;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static JProgressBar access$000(JOGLAppletLauncher jOGLAppletLauncher) {
        return jOGLAppletLauncher.progressBar;
    }

    static void access$100(JOGLAppletLauncher jOGLAppletLauncher, File file) {
        jOGLAppletLauncher.refreshJOGL(file);
    }

    static void access$200(JOGLAppletLauncher jOGLAppletLauncher) {
        jOGLAppletLauncher.updateDeploymentPropertiesImpl();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static void access$300(JOGLAppletLauncher jOGLAppletLauncher, String string) {
        jOGLAppletLauncher.displayMessage(string);
    }

    static void access$400(JOGLAppletLauncher jOGLAppletLauncher, File file, String string) {
        jOGLAppletLauncher.loadLibrary(file, string);
    }

    static JOGLAppletLauncher$NativeLibInfo access$500(JOGLAppletLauncher jOGLAppletLauncher) {
        return jOGLAppletLauncher.nativeLibInfo;
    }

    static void access$600(JOGLAppletLauncher jOGLAppletLauncher, String string) {
        jOGLAppletLauncher.displayError(string);
    }

    static boolean access$700(JOGLAppletLauncher jOGLAppletLauncher) {
        return jOGLAppletLauncher.haveJOAL;
    }

    static String access$800(JOGLAppletLauncher jOGLAppletLauncher) {
        return jOGLAppletLauncher.subAppletDisplayName;
    }

    static void access$900(JOGLAppletLauncher jOGLAppletLauncher) {
        jOGLAppletLauncher.startSubApplet();
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
        allNativeLibInfo = new JOGLAppletLauncher$NativeLibInfo[]{new JOGLAppletLauncher$NativeLibInfo("win", "x86", "windows-i586", "", ".dll"), new JOGLAppletLauncher$NativeLibInfo("win", "amd64", "windows-amd64", "", ".dll"), new JOGLAppletLauncher$NativeLibInfo("win", "x86_64", "windows-amd64", "", ".dll"), new JOGLAppletLauncher$NativeLibInfo("mac", "ppc", "macosx-ppc", "lib", ".jnilib"), new JOGLAppletLauncher$NativeLibInfo("mac", "i386", "macosx-universal", "lib", ".jnilib"), new JOGLAppletLauncher$NativeLibInfo("linux", "i386", "linux-i586", "lib", ".so"), new JOGLAppletLauncher$NativeLibInfo("linux", "x86", "linux-i586", "lib", ".so"), new JOGLAppletLauncher$NativeLibInfo("linux", "amd64", "linux-amd64", "lib", ".so"), new JOGLAppletLauncher$NativeLibInfo("linux", "x86_64", "linux-amd64", "lib", ".so"), new JOGLAppletLauncher$NativeLibInfo("sunos", "sparc", "solaris-sparc", "lib", ".so"), new JOGLAppletLauncher$NativeLibInfo("sunos", "sparcv9", "solaris-sparcv9", "lib", ".so"), new JOGLAppletLauncher$NativeLibInfo("sunos", "x86", "solaris-i586", "lib", ".so"), new JOGLAppletLauncher$NativeLibInfo("sunos", "amd64", "solaris-amd64", "lib", ".so"), new JOGLAppletLauncher$NativeLibInfo("sunos", "x86_64", "solaris-amd64", "lib", ".so")};
    }
}

