/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferUtil {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    private BufferUtil() {
    }

    public static ByteBuffer newByteBuffer(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static DoubleBuffer newDoubleBuffer(int n2) {
        return BufferUtil.newByteBuffer(n2 << 3).asDoubleBuffer();
    }

    public static FloatBuffer newFloatBuffer(int n2) {
        return BufferUtil.newByteBuffer(n2 << 2).asFloatBuffer();
    }

    public static IntBuffer newIntBuffer(int n2) {
        return BufferUtil.newByteBuffer(n2 << 2).asIntBuffer();
    }

    public static LongBuffer newLongBuffer(int n2) {
        return BufferUtil.newByteBuffer(n2 << 3).asLongBuffer();
    }

    public static ShortBuffer newShortBuffer(int n2) {
        return BufferUtil.newByteBuffer(n2 << 1).asShortBuffer();
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = BufferUtil.newByteBuffer(byteBuffer.remaining());
        byteBuffer.mark();
        byteBuffer2.put(byteBuffer);
        byteBuffer.reset();
        byteBuffer2.rewind();
        return byteBuffer2;
    }

    public static DoubleBuffer copyDoubleBuffer(DoubleBuffer doubleBuffer) {
        return BufferUtil.copyDoubleBufferAsByteBuffer(doubleBuffer).asDoubleBuffer();
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return BufferUtil.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return BufferUtil.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static LongBuffer copyLongBuffer(LongBuffer longBuffer) {
        return BufferUtil.copyLongBufferAsByteBuffer(longBuffer).asLongBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return BufferUtil.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyDoubleBufferAsByteBuffer(DoubleBuffer doubleBuffer) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(doubleBuffer.remaining() << 3);
        doubleBuffer.mark();
        byteBuffer.asDoubleBuffer().put(doubleBuffer);
        doubleBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(floatBuffer.remaining() << 2);
        floatBuffer.mark();
        byteBuffer.asFloatBuffer().put(floatBuffer);
        floatBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(intBuffer.remaining() << 2);
        intBuffer.mark();
        byteBuffer.asIntBuffer().put(intBuffer);
        intBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyLongBufferAsByteBuffer(LongBuffer longBuffer) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(longBuffer.remaining() << 3);
        longBuffer.mark();
        byteBuffer.asLongBuffer().put(longBuffer);
        longBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(shortBuffer.remaining() << 1);
        shortBuffer.mark();
        byteBuffer.asShortBuffer().put(shortBuffer);
        shortBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }
}

