/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.GLXFBConfig;
import com.sun.opengl.impl.x11.X11GLDrawable;
import com.sun.opengl.impl.x11.X11GLDrawableFactory;
import com.sun.opengl.impl.x11.X11PbufferGLContext;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class X11PbufferGLDrawable
extends X11GLDrawable {
    private int initWidth;
    private int initHeight;
    private GLXFBConfig fbConfig;
    private int width;
    private int height;
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;

    public X11PbufferGLDrawable(GLCapabilities gLCapabilities, int n2, int n3) {
        super(gLCapabilities, null);
        this.initWidth = n2;
        this.initHeight = n3;
        if (this.initWidth <= 0 || this.initHeight <= 0) {
            throw new GLException("Initial width and height of pbuffer must be positive (were (" + this.initWidth + ", " + this.initHeight + "))");
        }
        if (DEBUG) {
            System.out.println("Pbuffer caps on init: " + gLCapabilities + (gLCapabilities.getPbufferRenderToTexture() ? " [rtt]" : "") + (gLCapabilities.getPbufferRenderToTextureRectangle() ? " [rect]" : "") + (gLCapabilities.getPbufferFloatingPointBuffers() ? " [float]" : ""));
        }
        this.createPbuffer(X11GLDrawableFactory.getDisplayConnection());
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new X11PbufferGLContext(this, gLContext);
    }

    @Override
    public void destroy() {
        this.lockToolkit();
        if (this.drawable != 0L) {
            GLX.glXDestroyPbuffer(this.display, this.drawable);
            this.drawable = 0L;
        }
        this.unlockToolkit();
        this.display = 0L;
    }

    @Override
    public void setSize(int n2, int n3) {
        throw new GLException("Not yet implemented");
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void createPbuffer(long l2) {
        this.lockToolkit();
        try {
            Object object;
            int[] nArray;
            if (l2 == 0L) {
                throw new GLException("Null display");
            }
            if (this.capabilities.getPbufferRenderToTexture()) {
                throw new GLException("Render-to-texture pbuffers not supported yet on X11");
            }
            if (this.capabilities.getPbufferRenderToTextureRectangle()) {
                throw new GLException("Render-to-texture-rectangle pbuffers not supported yet on X11");
            }
            int n2 = GLX.DefaultScreen(l2);
            GLXFBConfig[] gLXFBConfigArray = GLX.glXChooseFBConfig(l2, n2, nArray = X11GLDrawableFactory.glCapabilities2AttribList(this.capabilities, X11GLDrawableFactory.isMultisampleAvailable(), true, l2, n2), 0, object = new int[1], 0);
            if (gLXFBConfigArray == null || gLXFBConfigArray.length == 0 || gLXFBConfigArray[0] == null) {
                throw new GLException("pbuffer creation error: glXChooseFBConfig() failed");
            }
            if (object[0] <= 0) {
                throw new GLException("pbuffer creation error: couldn't find a suitable frame buffer configuration");
            }
            object = gLXFBConfigArray[0];
            if (DEBUG) {
                System.err.println("Found " + gLXFBConfigArray.length + " matching GLXFBConfigs");
                System.err.println("Parameters of default one:");
                System.err.println("render type: 0x" + Integer.toHexString(this.queryFBConfig(l2, (GLXFBConfig)object, 32785)));
                System.err.println("rgba: " + ((this.queryFBConfig(l2, (GLXFBConfig)object, 32785) & 1) != 0));
                System.err.println("r: " + this.queryFBConfig(l2, (GLXFBConfig)object, 8));
                System.err.println("g: " + this.queryFBConfig(l2, (GLXFBConfig)object, 9));
                System.err.println("b: " + this.queryFBConfig(l2, (GLXFBConfig)object, 10));
                System.err.println("a: " + this.queryFBConfig(l2, (GLXFBConfig)object, 11));
                System.err.println("depth: " + this.queryFBConfig(l2, (GLXFBConfig)object, 12));
                System.err.println("double buffered: " + this.queryFBConfig(l2, (GLXFBConfig)object, 5));
            }
            nArray[0] = 32833;
            nArray[1] = this.initWidth;
            nArray[2] = 32832;
            nArray[3] = this.initHeight;
            nArray[4] = 0;
            long l3 = GLX.glXCreatePbuffer(l2, (GLXFBConfig)object, nArray, 0);
            if (l3 == 0L) {
                throw new GLException("pbuffer creation error: glXCreatePbuffer() failed");
            }
            this.display = l2;
            this.drawable = l3;
            this.fbConfig = object;
            int n3 = X11GLDrawableFactory.isMultisampleAvailable() ? 100000 : 8;
            int n4 = X11GLDrawableFactory.isMultisampleAvailable() ? 100001 : 8;
            int n5 = this.capabilities.getPbufferFloatingPointBuffers() ? 8368 : 8;
            int[] nArray2 = new int[]{5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, n3, n4, n5};
            int[] nArray3 = new int[15];
            this.queryFBConfig(l2, (GLXFBConfig)object, nArray2, 15, nArray3);
            this.setChosenGLCapabilities(X11GLDrawableFactory.attribList2GLCapabilities(nArray2, 15, nArray3, true));
            nArray2 = new int[1];
            GLX.glXQueryDrawable(l2, this.drawable, 32797, nArray2, 0);
            this.width = nArray2[0];
            GLX.glXQueryDrawable(l2, this.drawable, 32798, nArray2, 0);
            this.height = nArray2[0];
            if (DEBUG) {
                System.err.println("Created pbuffer " + this.width + " x " + this.height);
            }
            return;
        }
        finally {
            this.unlockToolkit();
        }
    }

    public int getFloatingPointMode() {
        return 3;
    }

    public GLXFBConfig getFBConfig() {
        return this.fbConfig;
    }

    private int queryFBConfig(long l2, GLXFBConfig gLXFBConfig, int n2) {
        int[] nArray = new int[1];
        if (GLX.glXGetFBConfigAttrib(l2, gLXFBConfig, n2, nArray, 0) != 0) {
            throw new GLException("glXGetFBConfigAttrib failed");
        }
        return nArray[0];
    }

    private void queryFBConfig(long l2, GLXFBConfig gLXFBConfig, int[] nArray, int n2, int[] nArray2) {
        int[] nArray3 = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (GLX.glXGetFBConfigAttrib(l2, gLXFBConfig, nArray[i2], nArray3, 0) != 0) {
                throw new GLException("glXGetFBConfigAttrib failed");
            }
            nArray2[i2] = nArray3[0];
        }
    }
}

