/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.X11GLContext;
import com.sun.opengl.impl.x11.X11PbufferGLDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class X11PbufferGLContext
extends X11GLContext {
    private X11PbufferGLDrawable drawable;

    public X11PbufferGLContext(X11PbufferGLDrawable x11PbufferGLDrawable, GLContext gLContext) {
        super(x11PbufferGLDrawable, gLContext);
        this.drawable = x11PbufferGLDrawable;
    }

    @Override
    public void bindPbufferToTexture() {
        throw new GLException("Not yet implemented");
    }

    @Override
    public void releasePbufferFromTexture() {
        throw new GLException("Not yet implemented");
    }

    @Override
    protected int makeCurrentImpl() {
        if (this.drawable.getDrawable() == 0L) {
            if (DEBUG) {
                System.err.println("pbuffer not instantiated");
            }
            return 0;
        }
        this.lockToolkit();
        try {
            boolean bl = false;
            if (this.context == 0L) {
                this.create();
                if (DEBUG) {
                    System.err.println(new StringBuffer().append(X11PbufferGLContext.getThreadName()).append(": !!! Created GL context for ").append(this.getClass().getName()).toString());
                }
                bl = true;
            }
            if (!GLX.glXMakeContextCurrent(this.drawable.getDisplay(), this.drawable.getDrawable(), this.drawable.getDrawable(), this.context)) {
                throw new GLException("Error making context current");
            }
            this.mostRecentDisplay = this.drawable.getDisplay();
            if (DEBUG && (VERBOSE || bl)) {
                System.err.println(new StringBuffer().append(X11PbufferGLContext.getThreadName()).append(": glXMakeCurrent(display ").append(X11PbufferGLContext.toHexString(this.drawable.getDisplay())).append(", drawable ").append(X11PbufferGLContext.toHexString(this.drawable.getDrawable())).append(", context ").append(X11PbufferGLContext.toHexString(this.context)).append(") succeeded").toString());
            }
            if (bl) {
                this.resetGLFunctionAvailability();
                return 2;
            }
            return 1;
        }
        finally {
            this.unlockToolkit();
        }
    }

    @Override
    protected void releaseImpl() {
        this.lockToolkit();
        try {
            if (this.drawable.getDisplay() == 0L) {
                throw new GLException("Pbuffer destroyed out from under application-created context");
            }
            if (!GLX.glXMakeContextCurrent(this.drawable.getDisplay(), 0L, 0L, 0L)) {
                throw new GLException("Error freeing OpenGL context");
            }
            return;
        }
        finally {
            this.unlockToolkit();
        }
    }

    @Override
    public int getFloatingPointMode() {
        return this.drawable.getFloatingPointMode();
    }

    @Override
    protected void create() {
        if (DEBUG) {
            System.err.println(new StringBuffer("Creating context for pbuffer ").append(this.drawable.getWidth()).append(" x ").append(this.drawable.getHeight()).toString());
        }
        X11GLContext x11GLContext = (X11GLContext)GLContextShareSet.getShareContext(this);
        long l2 = 0L;
        if (x11GLContext != null && (l2 = x11GLContext.getContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        this.context = GLX.glXCreateNewContext(this.drawable.getDisplay(), this.drawable.getFBConfig(), 32788, l2, true);
        if (this.context == 0L) {
            throw new GLException("pbuffer creation error: glXCreateNewContext() failed");
        }
        GLContextShareSet.contextCreated(this);
        if (DEBUG) {
            System.err.println(new StringBuffer("Created context for pbuffer ").append(this.drawable.getWidth()).append(" x ").append(this.drawable.getHeight()).toString());
        }
    }
}

