/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.windows.BITMAPINFO;
import com.sun.opengl.impl.windows.BITMAPINFOHEADER;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WindowsGLDrawable;
import com.sun.opengl.impl.windows.WindowsOffscreenGLContext;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsOffscreenGLDrawable
extends WindowsGLDrawable {
    private long origbitmap;
    private long hbitmap;
    private int width;
    private int height;

    public WindowsOffscreenGLDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(gLCapabilities, gLCapabilitiesChooser);
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsOffscreenGLContext(this, gLContext);
    }

    @Override
    public void setSize(int n2, int n3) {
        this.width = n2;
        this.height = n3;
        if (this.hdc != 0L) {
            this.destroy();
        }
        this.create();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private void create() {
        BITMAPINFO bITMAPINFO = BITMAPINFO.create();
        BITMAPINFOHEADER bITMAPINFOHEADER = bITMAPINFO.bmiHeader();
        int n2 = this.capabilities.getRedBits() + this.capabilities.getGreenBits() + this.capabilities.getBlueBits();
        bITMAPINFOHEADER.biSize(BITMAPINFOHEADER.size());
        bITMAPINFOHEADER.biWidth(this.width);
        bITMAPINFOHEADER.biHeight(-1 * this.height);
        bITMAPINFOHEADER.biPlanes((short)1);
        bITMAPINFOHEADER.biBitCount((short)n2);
        bITMAPINFOHEADER.biXPelsPerMeter(0L);
        bITMAPINFOHEADER.biYPelsPerMeter(0L);
        bITMAPINFOHEADER.biClrUsed(0);
        bITMAPINFOHEADER.biClrImportant(0);
        bITMAPINFOHEADER.biCompression(0);
        bITMAPINFOHEADER.biSizeImage(this.width * this.height * n2 / 8);
        this.hdc = WGL.CreateCompatibleDC(0L);
        if (this.hdc == 0L) {
            System.out.println(new StringBuffer("LastError: ").append(WGL.GetLastError()).toString());
            throw new GLException("Error creating device context for offscreen OpenGL context");
        }
        this.hbitmap = WGL.CreateDIBSection(this.hdc, bITMAPINFO, 0, 0L, 0L, 0);
        if (this.hbitmap == 0L) {
            WGL.DeleteDC(this.hdc);
            this.hdc = 0L;
            throw new GLException(new StringBuffer("Error creating offscreen bitmap of width ").append(this.width).append(", height ").append(this.height).toString());
        }
        this.origbitmap = WGL.SelectObject(this.hdc, this.hbitmap);
        if (this.origbitmap == 0L) {
            WGL.DeleteObject(this.hbitmap);
            this.hbitmap = 0L;
            WGL.DeleteDC(this.hdc);
            this.hdc = 0L;
            throw new GLException("Error selecting bitmap into new device context");
        }
        this.choosePixelFormat(false);
    }

    @Override
    public void destroy() {
        if (this.hdc != 0L) {
            WGL.SelectObject(this.hdc, this.origbitmap);
            WGL.DeleteObject(this.hbitmap);
            WGL.DeleteDC(this.hdc);
            this.origbitmap = 0L;
            this.hbitmap = 0L;
            this.hdc = 0L;
            this.setChosenGLCapabilities(null);
        }
    }
}

