/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.windows.PIXELFORMATDESCRIPTOR;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WGLExt;
import com.sun.opengl.impl.windows.WindowsDummyGLDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLException;

public abstract class WindowsGLDrawable
extends GLDrawableImpl {
    protected static final boolean DEBUG;
    protected long hdc;
    protected GLCapabilities capabilities;
    protected GLCapabilitiesChooser chooser;
    protected boolean pixelFormatChosen;
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;
    static final boolean $assertionsDisabled;
    static Class class$com$sun$opengl$impl$windows$WindowsGLDrawable;

    public WindowsGLDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        this.capabilities = (GLCapabilities)gLCapabilities.clone();
        this.chooser = gLCapabilitiesChooser;
    }

    @Override
    public void setRealized(boolean bl) {
        throw new GLException("Should not call this (should only be called for onscreen GLDrawables)");
    }

    @Override
    public void destroy() {
        throw new GLException("Should not call this (should only be called for offscreen GLDrawables)");
    }

    @Override
    public void swapBuffers() {
    }

    public long getHDC() {
        return this.hdc;
    }

    protected void choosePixelFormat(boolean bl) {
        int n2;
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR;
        GLContextImpl gLContextImpl = null;
        if (bl) {
            int n3 = WGL.GetPixelFormat(this.hdc);
            if (n3 != 0) {
                if (DEBUG) {
                    System.err.println(new StringBuffer("NOTE: pixel format already chosen (by Java2D/OpenGL pipeline?) for window: ").append(WGL.GetPixelFormat(this.hdc)).toString());
                }
                PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR2 = WindowsGLDrawable.newPixelFormatDescriptor();
                if (WGL.DescribePixelFormat(this.hdc, n3, PIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR2) == 0) {
                    throw new GLException(new StringBuffer("Unable to describe pixel format ").append(n3).append(" of window set by Java2D/OpenGL pipeline").toString());
                }
                this.setChosenGLCapabilities(WindowsGLDrawable.pfd2GLCapabilities(pIXELFORMATDESCRIPTOR2));
                this.pixelFormatChosen = true;
                return;
            }
            GLCapabilities[] gLCapabilitiesArray = null;
            int n4 = 0;
            pIXELFORMATDESCRIPTOR = WindowsGLDrawable.newPixelFormatDescriptor();
            WindowsDummyGLDrawable windowsDummyGLDrawable = null;
            gLContextImpl = null;
            WGLExt wGLExt = null;
            if (this.capabilities.getSampleBuffers() && (gLContextImpl = (GLContextImpl)(windowsDummyGLDrawable = new WindowsDummyGLDrawable()).createContext(null)) != null) {
                gLContextImpl.makeCurrent();
                wGLExt = (WGLExt)gLContextImpl.getPlatformGLExtensions();
            }
            int n5 = -1;
            boolean bl2 = false;
            if (wGLExt != null) {
                try {
                    if (wGLExt.isExtensionAvailable("WGL_ARB_pixel_format")) {
                        int n6 = wGLExt.isExtensionAvailable("WGL_ARB_multisample");
                        int[] nArray = new int[512];
                        int[] nArray2 = new int[512];
                        float[] fArray = new float[1];
                        if (WindowsGLDrawable.glCapabilities2iattributes(this.capabilities, nArray, wGLExt, false, null)) {
                            int[] nArray3 = new int[256];
                            int[] nArray4 = new int[1];
                            if (wGLExt.wglChoosePixelFormatARB(this.hdc, nArray, 0, fArray, 0, 256, nArray3, 0, nArray4, 0)) {
                                n4 = nArray4[0];
                                if (n4 > 0) {
                                    n5 = nArray3[0] - 1;
                                    if (DEBUG) {
                                        System.err.println(new StringBuffer().append(WindowsGLDrawable.getThreadName()).append(": Used wglChoosePixelFormatARB to recommend pixel format ").append(n5).toString());
                                    }
                                }
                            } else if (DEBUG) {
                                System.err.println(new StringBuffer().append(WindowsGLDrawable.getThreadName()).append(": wglChoosePixelFormatARB failed: ").append(WGL.GetLastError()).toString());
                                Thread.dumpStack();
                            }
                            if (DEBUG && n5 < 0) {
                                System.err.print(new StringBuffer().append(WindowsGLDrawable.getThreadName()).append(": wglChoosePixelFormatARB didn't recommend a pixel format").toString());
                                if (this.capabilities.getSampleBuffers()) {
                                    System.err.print(" for multisampled GLCapabilities");
                                }
                                System.err.println();
                            }
                            int n7 = 0;
                            nArray[0] = 8192;
                            if (wGLExt.wglGetPixelFormatAttribivARB(this.hdc, 0, 0, 1, nArray, 0, nArray2, 0)) {
                                n4 = nArray2[0];
                                if (DEBUG) {
                                    System.err.println(new StringBuffer("wglGetPixelFormatAttribivARB reported WGL_NUMBER_PIXEL_FORMATS_ARB = ").append(n4).toString());
                                }
                                ++n7;
                                nArray[0] = 8193;
                                ++n7;
                                nArray[1] = 8195;
                                ++n7;
                                nArray[2] = 8208;
                                ++n7;
                                nArray[3] = 8226;
                                ++n7;
                                nArray[4] = 8227;
                                ++n7;
                                nArray[5] = 8209;
                                ++n7;
                                nArray[6] = 8210;
                                ++n7;
                                nArray[7] = 8211;
                                ++n7;
                                nArray[8] = 8213;
                                ++n7;
                                nArray[9] = 8215;
                                ++n7;
                                nArray[10] = 8217;
                                ++n7;
                                nArray[11] = 8219;
                                ++n7;
                                nArray[12] = 8222;
                                ++n7;
                                nArray[13] = 8223;
                                ++n7;
                                nArray[14] = 8224;
                                ++n7;
                                nArray[15] = 8225;
                                if (n6 != 0) {
                                    ++n7;
                                    nArray[16] = 8257;
                                    ++n7;
                                    nArray[17] = 8258;
                                }
                                gLCapabilitiesArray = new GLCapabilities[n4];
                                for (n6 = 0; n6 < n4; ++n6) {
                                    if (!wGLExt.wglGetPixelFormatAttribivARB(this.hdc, n6 + 1, 0, n7, nArray, 0, nArray2, 0)) {
                                        throw new GLException(new StringBuffer("Error getting pixel format attributes for pixel format ").append(n6 + 1).append(" of device context").toString());
                                    }
                                    gLCapabilitiesArray[n6] = WindowsGLDrawable.iattributes2GLCapabilities(nArray, n7, nArray2, true);
                                }
                                bl2 = true;
                            } else if ((long)WGL.GetLastError() != 0L) {
                                throw new GLException(new StringBuffer("Unable to enumerate pixel formats of window using wglGetPixelFormatAttribivARB: error code ").append(WGL.GetLastError()).toString());
                            }
                        }
                    }
                }
                finally {
                    gLContextImpl.release();
                    gLContextImpl.destroy();
                    ((WindowsGLDrawable)windowsDummyGLDrawable).destroy();
                }
            }
            if (!bl2) {
                if (DEBUG) {
                    if (!this.capabilities.getSampleBuffers()) {
                        System.err.println(new StringBuffer().append(WindowsGLDrawable.getThreadName()).append(": Using ChoosePixelFormat because multisampling not requested").toString());
                    } else {
                        System.err.println(new StringBuffer().append(WindowsGLDrawable.getThreadName()).append(": Using ChoosePixelFormat because no wglChoosePixelFormatARB").toString());
                    }
                }
                pIXELFORMATDESCRIPTOR = WindowsGLDrawable.glCapabilities2PFD(this.capabilities, bl);
                n5 = WGL.ChoosePixelFormat(this.hdc, pIXELFORMATDESCRIPTOR) - 1;
                n4 = WGL.DescribePixelFormat(this.hdc, 1, 0, null);
                if (n4 == 0) {
                    throw new GLException("Unable to enumerate pixel formats of window for GLCapabilitiesChooser");
                }
                gLCapabilitiesArray = new GLCapabilities[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (WGL.DescribePixelFormat(this.hdc, i2 + 1, PIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
                        throw new GLException(new StringBuffer("Error describing pixel format ").append(i2 + 1).append(" of device context").toString());
                    }
                    gLCapabilitiesArray[i2] = WindowsGLDrawable.pfd2GLCapabilities(pIXELFORMATDESCRIPTOR);
                }
            }
            if ((n2 = this.chooser.chooseCapabilities(this.capabilities, gLCapabilitiesArray, n5)) < 0 || n2 >= n4) {
                throw new GLException(new StringBuffer("Invalid result ").append(n2).append(" from GLCapabilitiesChooser (should be between 0 and ").append(n4 - 1).append(")").toString());
            }
            if (DEBUG) {
                System.err.println(new StringBuffer().append(WindowsGLDrawable.getThreadName()).append(": Chosen pixel format (").append(n2).append("):").toString());
                System.err.println(gLCapabilitiesArray[n2]);
            }
            gLContextImpl = gLCapabilitiesArray[n2];
            if (WGL.DescribePixelFormat(this.hdc, ++n2, PIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
                throw new GLException(new StringBuffer("Error re-describing the chosen pixel format: ").append(WGL.GetLastError()).toString());
            }
        } else {
            pIXELFORMATDESCRIPTOR = WindowsGLDrawable.glCapabilities2PFD(this.capabilities, bl);
            n2 = WGL.ChoosePixelFormat(this.hdc, pIXELFORMATDESCRIPTOR);
        }
        if (!WGL.SetPixelFormat(this.hdc, n2, pIXELFORMATDESCRIPTOR)) {
            long l2 = WGL.GetLastError();
            if (DEBUG) {
                System.err.println(new StringBuffer().append(WindowsGLDrawable.getThreadName()).append(": SetPixelFormat failed: current context = ").append(WGL.wglGetCurrentContext()).append(", current DC = ").append(WGL.wglGetCurrentDC()).toString());
                System.err.println(new StringBuffer().append(WindowsGLDrawable.getThreadName()).append(": GetPixelFormat(hdc ").append(WindowsGLDrawable.toHexString(this.hdc)).append(") returns ").append(WGL.GetPixelFormat(this.hdc)).toString());
            }
            throw new GLException(new StringBuffer("Unable to set pixel format ").append(n2).append(" for device context ").append(WindowsGLDrawable.toHexString(this.hdc)).append(": error code ").append(l2).toString());
        }
        if (gLContextImpl != null) {
            this.setChosenGLCapabilities((GLCapabilities)((Object)gLContextImpl));
        } else {
            this.setChosenGLCapabilities(WindowsGLDrawable.pfd2GLCapabilities(pIXELFORMATDESCRIPTOR));
        }
        this.pixelFormatChosen = true;
    }

    protected static PIXELFORMATDESCRIPTOR glCapabilities2PFD(GLCapabilities gLCapabilities, boolean bl) {
        int n2 = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        if (n2 < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsGLDrawable.newPixelFormatDescriptor();
        int n3 = 4128;
        if (gLCapabilities.getDoubleBuffered()) {
            n3 = 4129;
        }
        n3 = bl ? (n3 |= 4) : (n3 |= 8);
        if (gLCapabilities.getStereo()) {
            n3 |= 2;
        }
        pIXELFORMATDESCRIPTOR.dwFlags(n3);
        pIXELFORMATDESCRIPTOR.iPixelType((byte)0);
        pIXELFORMATDESCRIPTOR.cColorBits((byte)n2);
        pIXELFORMATDESCRIPTOR.cRedBits((byte)gLCapabilities.getRedBits());
        pIXELFORMATDESCRIPTOR.cGreenBits((byte)gLCapabilities.getGreenBits());
        pIXELFORMATDESCRIPTOR.cBlueBits((byte)gLCapabilities.getBlueBits());
        pIXELFORMATDESCRIPTOR.cAlphaBits((byte)gLCapabilities.getAlphaBits());
        int n4 = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits();
        pIXELFORMATDESCRIPTOR.cAccumBits((byte)n4);
        pIXELFORMATDESCRIPTOR.cAccumRedBits((byte)gLCapabilities.getAccumRedBits());
        pIXELFORMATDESCRIPTOR.cAccumGreenBits((byte)gLCapabilities.getAccumGreenBits());
        pIXELFORMATDESCRIPTOR.cAccumBlueBits((byte)gLCapabilities.getAccumBlueBits());
        pIXELFORMATDESCRIPTOR.cAccumAlphaBits((byte)gLCapabilities.getAccumAlphaBits());
        pIXELFORMATDESCRIPTOR.cDepthBits((byte)gLCapabilities.getDepthBits());
        pIXELFORMATDESCRIPTOR.cStencilBits((byte)gLCapabilities.getStencilBits());
        pIXELFORMATDESCRIPTOR.iLayerType((byte)0);
        return pIXELFORMATDESCRIPTOR;
    }

    protected static PIXELFORMATDESCRIPTOR newPixelFormatDescriptor() {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.create();
        pIXELFORMATDESCRIPTOR.nSize((short)PIXELFORMATDESCRIPTOR.size());
        pIXELFORMATDESCRIPTOR.nVersion((short)1);
        return pIXELFORMATDESCRIPTOR;
    }

    protected static GLCapabilities pfd2GLCapabilities(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        if ((pIXELFORMATDESCRIPTOR.dwFlags() & 0x20) == 0) {
            return null;
        }
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(pIXELFORMATDESCRIPTOR.cRedBits());
        gLCapabilities.setGreenBits(pIXELFORMATDESCRIPTOR.cGreenBits());
        gLCapabilities.setBlueBits(pIXELFORMATDESCRIPTOR.cBlueBits());
        gLCapabilities.setAlphaBits(pIXELFORMATDESCRIPTOR.cAlphaBits());
        gLCapabilities.setAccumRedBits(pIXELFORMATDESCRIPTOR.cAccumRedBits());
        gLCapabilities.setAccumGreenBits(pIXELFORMATDESCRIPTOR.cAccumGreenBits());
        gLCapabilities.setAccumBlueBits(pIXELFORMATDESCRIPTOR.cAccumBlueBits());
        gLCapabilities.setAccumAlphaBits(pIXELFORMATDESCRIPTOR.cAccumAlphaBits());
        gLCapabilities.setDepthBits(pIXELFORMATDESCRIPTOR.cDepthBits());
        gLCapabilities.setStencilBits(pIXELFORMATDESCRIPTOR.cStencilBits());
        gLCapabilities.setDoubleBuffered((pIXELFORMATDESCRIPTOR.dwFlags() & 1) != 0);
        gLCapabilities.setStereo((pIXELFORMATDESCRIPTOR.dwFlags() & 2) != 0);
        gLCapabilities.setHardwareAccelerated((pIXELFORMATDESCRIPTOR.dwFlags() & 0x40) == 0 || (pIXELFORMATDESCRIPTOR.dwFlags() & 0x1000) != 0);
        return gLCapabilities;
    }

    protected static boolean glCapabilities2iattributes(GLCapabilities gLCapabilities, int[] nArray, WGLExt wGLExt, boolean bl, int[] nArray2) {
        if (!wGLExt.isExtensionAvailable("WGL_ARB_pixel_format")) {
            return false;
        }
        int n2 = 0;
        ++n2;
        nArray[0] = 8208;
        ++n2;
        nArray[1] = 1;
        if (bl) {
            ++n2;
            nArray[2] = 8237;
            ++n2;
            nArray[3] = 1;
        } else {
            ++n2;
            nArray[2] = 8193;
            ++n2;
            nArray[3] = 1;
        }
        ++n2;
        nArray[4] = 8209;
        if (gLCapabilities.getDoubleBuffered()) {
            ++n2;
            nArray[5] = 1;
        } else {
            ++n2;
            nArray[5] = 0;
        }
        ++n2;
        nArray[6] = 8210;
        if (gLCapabilities.getStereo()) {
            ++n2;
            nArray[7] = 1;
        } else {
            ++n2;
            nArray[7] = 0;
        }
        ++n2;
        nArray[8] = 8226;
        ++n2;
        nArray[9] = gLCapabilities.getDepthBits();
        ++n2;
        nArray[10] = 8213;
        ++n2;
        nArray[11] = gLCapabilities.getRedBits();
        ++n2;
        nArray[12] = 8215;
        ++n2;
        nArray[13] = gLCapabilities.getGreenBits();
        ++n2;
        nArray[14] = 8217;
        ++n2;
        nArray[15] = gLCapabilities.getBlueBits();
        ++n2;
        nArray[16] = 8219;
        ++n2;
        nArray[17] = gLCapabilities.getAlphaBits();
        ++n2;
        nArray[18] = 8227;
        ++n2;
        nArray[19] = gLCapabilities.getStencilBits();
        if (gLCapabilities.getAccumRedBits() > 0 || gLCapabilities.getAccumGreenBits() > 0 || gLCapabilities.getAccumBlueBits() > 0 || gLCapabilities.getAccumAlphaBits() > 0) {
            ++n2;
            nArray[20] = 8221;
            ++n2;
            nArray[21] = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits() + gLCapabilities.getAccumAlphaBits();
            ++n2;
            nArray[22] = 8222;
            ++n2;
            nArray[23] = gLCapabilities.getAccumRedBits();
            ++n2;
            nArray[24] = 8223;
            ++n2;
            nArray[25] = gLCapabilities.getAccumGreenBits();
            ++n2;
            nArray[26] = 8224;
            ++n2;
            nArray[27] = gLCapabilities.getAccumBlueBits();
            ++n2;
            nArray[28] = 8225;
            ++n2;
            nArray[29] = gLCapabilities.getAccumAlphaBits();
        }
        if (wGLExt.isExtensionAvailable("WGL_ARB_multisample") && gLCapabilities.getSampleBuffers()) {
            nArray[n2++] = 8257;
            nArray[n2++] = 1;
            nArray[n2++] = 8258;
            nArray[n2++] = gLCapabilities.getNumSamples();
        }
        boolean bl2 = gLCapabilities.getPbufferRenderToTexture();
        boolean bl3 = gLCapabilities.getPbufferRenderToTextureRectangle();
        boolean bl4 = gLCapabilities.getPbufferFloatingPointBuffers();
        boolean bl5 = false;
        if (bl) {
            if (bl3 && !bl2) {
                throw new GLException("Render-to-texture-rectangle requires render-to-texture to be specified");
            }
            if (bl3 && !wGLExt.isExtensionAvailable("GL_NV_texture_rectangle")) {
                throw new GLException("Render-to-texture-rectangle requires GL_NV_texture_rectangle extension");
            }
            if (bl4) {
                if (!wGLExt.isExtensionAvailable("WGL_ATI_pixel_format_float") && !wGLExt.isExtensionAvailable("WGL_NV_float_buffer")) {
                    throw new GLException("Floating-point pbuffers not supported by this hardware");
                }
                if (wGLExt.isExtensionAvailable("WGL_NV_float_buffer")) {
                    bl5 = false;
                    nArray2[0] = 3;
                } else {
                    bl5 = true;
                    nArray2[0] = 2;
                }
                if (DEBUG) {
                    System.err.println(new StringBuffer("Using ").append(bl5 ? "ATI" : "NVidia").append(" floating-point extension").toString());
                }
            }
            if (bl4 && bl5) {
                if (bl2) {
                    throw new GLException("Render-to-floating-point-texture not supported on ATI hardware");
                }
                nArray[n2++] = 8211;
                nArray[n2++] = 8608;
            } else if (!bl2) {
                nArray[n2++] = 8211;
                nArray[n2++] = 8235;
            }
            if (bl4 && !bl5) {
                nArray[n2++] = 8368;
                nArray[n2++] = 1;
            }
            if (bl2) {
                if (bl4) {
                    if (!$assertionsDisabled && bl5) {
                        throw new AssertionError();
                    }
                    if (!bl3) {
                        throw new GLException("Render-to-floating-point-texture only supported on NVidia hardware with render-to-texture-rectangle");
                    }
                    nArray[n2++] = 8371;
                    nArray[n2] = 1;
                } else {
                    nArray[n2++] = bl3 ? 8352 : 8304;
                    nArray[n2] = 1;
                }
            }
        } else {
            nArray[n2++] = 8211;
            nArray[n2] = 8235;
        }
        return true;
    }

    protected static GLCapabilities iattributes2GLCapabilities(int[] nArray, int n2, int[] nArray2, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        block22: for (int i2 = 0; i2 < n2; ++i2) {
            switch (nArray[i2]) {
                case 8193: {
                    if (!bl || nArray2[i2] == 1) continue block22;
                    return null;
                }
                case 8237: {
                    continue block22;
                }
                case 8195: {
                    gLCapabilities.setHardwareAccelerated(nArray2[i2] == 8231);
                    continue block22;
                }
                case 8208: {
                    if (nArray2[i2] == 1) continue block22;
                    return null;
                }
                case 8226: {
                    gLCapabilities.setDepthBits(nArray2[i2]);
                    continue block22;
                }
                case 8227: {
                    gLCapabilities.setStencilBits(nArray2[i2]);
                    continue block22;
                }
                case 8209: {
                    gLCapabilities.setDoubleBuffered(nArray2[i2] == 1);
                    continue block22;
                }
                case 8210: {
                    gLCapabilities.setStereo(nArray2[i2] == 1);
                    continue block22;
                }
                case 8211: {
                    if (nArray2[i2] != 8235 && nArray2[i2] != 8608) continue block22;
                    gLCapabilities.setPbufferFloatingPointBuffers(true);
                    continue block22;
                }
                case 8368: {
                    if (nArray2[i2] == 0) continue block22;
                    gLCapabilities.setPbufferFloatingPointBuffers(true);
                    continue block22;
                }
                case 8213: {
                    gLCapabilities.setRedBits(nArray2[i2]);
                    continue block22;
                }
                case 8215: {
                    gLCapabilities.setGreenBits(nArray2[i2]);
                    continue block22;
                }
                case 8217: {
                    gLCapabilities.setBlueBits(nArray2[i2]);
                    continue block22;
                }
                case 8219: {
                    gLCapabilities.setAlphaBits(nArray2[i2]);
                    continue block22;
                }
                case 8222: {
                    gLCapabilities.setAccumRedBits(nArray2[i2]);
                    continue block22;
                }
                case 8223: {
                    gLCapabilities.setAccumGreenBits(nArray2[i2]);
                    continue block22;
                }
                case 8224: {
                    gLCapabilities.setAccumBlueBits(nArray2[i2]);
                    continue block22;
                }
                case 8225: {
                    gLCapabilities.setAccumAlphaBits(nArray2[i2]);
                    continue block22;
                }
                case 8257: {
                    gLCapabilities.setSampleBuffers(nArray2[i2] != 0);
                    continue block22;
                }
                case 8258: {
                    gLCapabilities.setNumSamples(nArray2[i2]);
                    continue block22;
                }
                default: {
                    throw new GLException(new StringBuffer("Unknown pixel format attribute ").append(nArray[i2]).toString());
                }
            }
        }
        return gLCapabilities;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$opengl$impl$windows$WindowsGLDrawable == null ? (class$com$sun$opengl$impl$windows$WindowsGLDrawable = WindowsGLDrawable.class$("com.sun.opengl.impl.windows.WindowsGLDrawable")) : class$com$sun$opengl$impl$windows$WindowsGLDrawable).desiredAssertionStatus();
        DEBUG = Debug.debug("WindowsGLDrawable");
    }
}

