/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;

public class GLBufferStateTracker {
    private static final boolean DEBUG = Debug.debug("GLBufferStateTracker");
    private static final Integer arrayBufferEnum = new Integer(34962);
    private static final Integer elementArrayBufferEnum = new Integer(34963);
    private static final Integer pixelPackBufferEnum = new Integer(35051);
    private static final Integer pixelUnpackBufferEnum = new Integer(35052);
    private static final Integer zero = new Integer(0);
    private Map bindingMap = new HashMap();
    private int[] bufTmp = new int[1];

    public GLBufferStateTracker() {
        this.bindingMap.put(arrayBufferEnum, zero);
        this.bindingMap.put(elementArrayBufferEnum, zero);
        this.bindingMap.put(pixelPackBufferEnum, zero);
        this.bindingMap.put(pixelUnpackBufferEnum, zero);
    }

    public void setBoundBufferObject(int n2, int n3) {
        Integer n4 = GLBufferStateTracker.box(n2);
        this.bindingMap.put(n4, GLBufferStateTracker.box(n3));
    }

    public int getBoundBufferObject(int n2, GL gL) {
        Integer n3 = GLBufferStateTracker.box(n2);
        if ((n3 = (Integer)this.bindingMap.get(n3)) == null) {
            boolean bl = true;
            int n4 = 0;
            switch (n2) {
                case 34962: {
                    n4 = 34964;
                    break;
                }
                case 34963: {
                    n4 = 34965;
                    break;
                }
                case 35051: {
                    n4 = 35053;
                    break;
                }
                case 35052: {
                    n4 = 35055;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                gL.glGetIntegerv(n4, this.bufTmp, 0);
                if (DEBUG) {
                    System.err.println("GLBufferStateTracker.getBoundBufferObject(): queried bound buffer " + this.bufTmp[0] + " for query target 0x" + Integer.toHexString(n4));
                }
                this.setBoundBufferObject(n2, this.bufTmp[0]);
                return this.getBoundBufferObject(n2, gL);
            }
            return 0;
        }
        return n3;
    }

    public boolean isBoundBufferObjectKnown(int n2) {
        return this.bindingMap.get(GLBufferStateTracker.box(n2)) != null;
    }

    public void clearBufferObjectState() {
        this.bindingMap.clear();
    }

    private static Integer box(int n2) {
        switch (n2) {
            case 0: {
                return zero;
            }
            case 34962: {
                return arrayBufferEnum;
            }
            case 34963: {
                return elementArrayBufferEnum;
            }
            case 35051: {
                return pixelPackBufferEnum;
            }
            case 35052: {
                return pixelUnpackBufferEnum;
            }
        }
        return new Integer(n2);
    }
}

