/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLBufferStateTracker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public class GLBufferSizeTracker {
    private Map bufferSizeMap = Collections.synchronizedMap(new HashMap());
    private static final boolean DEBUG = Debug.debug("GLBufferSizeTracker");

    public void setBufferSize(GLBufferStateTracker gLBufferStateTracker, int n2, GL gL, int n3) {
        int n4 = gLBufferStateTracker.getBoundBufferObject(n2, gL);
        if (gLBufferStateTracker.isBoundBufferObjectKnown(n2)) {
            if (n4 == 0) {
                throw new GLException("Error: no OpenGL buffer object appears to be bound to target 0x" + Integer.toHexString(n2));
            }
            this.bufferSizeMap.put(new Integer(n4), new Integer(n3));
        }
    }

    public int getBufferSize(GLBufferStateTracker object, int n2, GL gL) {
        int n3 = ((GLBufferStateTracker)object).getBoundBufferObject(n2, gL);
        if (((GLBufferStateTracker)object).isBoundBufferObjectKnown(n2)) {
            if (n3 == 0) {
                throw new GLException("Error: no OpenGL buffer object appears to be bound to target 0x" + Integer.toHexString(n2));
            }
            object = new Integer(n3);
            Integer n4 = (Integer)this.bufferSizeMap.get(object);
            if (n4 == null) {
                int[] nArray = new int[1];
                gL.glGetBufferParameterivARB(n2, 34660, nArray, 0);
                if (nArray[0] == 0) {
                    throw new GLException("Error: buffer size returned by glGetBufferParameterivARB was zero; probably application error");
                }
                n4 = new Integer(nArray[0]);
                this.bufferSizeMap.put(object, n4);
                if (DEBUG) {
                    System.err.println("GLBufferSizeTracker.getBufferSize(): made slow query to cache size " + nArray[0] + " for buffer " + n3);
                }
            }
            return n4;
        }
        object = new int[1];
        gL.glGetBufferParameterivARB(n2, 34660, (int[])object, 0);
        if (DEBUG) {
            System.err.println("GLBufferSizeTracker.getBufferSize(): no cached buffer information");
        }
        return (int)object[0];
    }

    public void clearCachedBufferSizes() {
        this.bufferSizeMap.clear();
    }
}

