/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferFactory {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    public static ByteBuffer newDirectByteBuffer(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static boolean isDirect(Buffer buffer) {
        if (buffer == null) {
            return true;
        }
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).isDirect();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).isDirect();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).isDirect();
        }
        if (buffer instanceof CharBuffer) {
            return ((CharBuffer)buffer).isDirect();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).isDirect();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).isDirect();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).isDirect();
        }
        throw new RuntimeException(new StringBuffer("Unexpected buffer type ").append(buffer.getClass().getName()).toString());
    }

    public static int getDirectBufferByteOffset(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        if (buffer instanceof ByteBuffer) {
            return buffer.position();
        }
        if (buffer instanceof FloatBuffer) {
            return buffer.position() << 2;
        }
        if (buffer instanceof IntBuffer) {
            return buffer.position() << 2;
        }
        if (buffer instanceof ShortBuffer) {
            return buffer.position() << 1;
        }
        if (buffer instanceof DoubleBuffer) {
            return buffer.position() << 3;
        }
        if (buffer instanceof LongBuffer) {
            return buffer.position() << 3;
        }
        if (buffer instanceof CharBuffer) {
            return buffer.position() << 1;
        }
        throw new RuntimeException(new StringBuffer("Disallowed array backing store type in buffer ").append(buffer.getClass().getName()).toString());
    }

    public static Object getArray(Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).array();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).array();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).array();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).array();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).array();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).array();
        }
        if (buffer instanceof CharBuffer) {
            return ((CharBuffer)buffer).array();
        }
        throw new RuntimeException(new StringBuffer("Disallowed array backing store type in buffer ").append(buffer.getClass().getName()).toString());
    }

    public static int getIndirectBufferByteOffset(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        int n2 = buffer.position();
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).arrayOffset() + n2;
        }
        if (buffer instanceof FloatBuffer) {
            return 4 * (((FloatBuffer)buffer).arrayOffset() + n2);
        }
        if (buffer instanceof IntBuffer) {
            return 4 * (((IntBuffer)buffer).arrayOffset() + n2);
        }
        if (buffer instanceof ShortBuffer) {
            return 2 * (((ShortBuffer)buffer).arrayOffset() + n2);
        }
        if (buffer instanceof DoubleBuffer) {
            return 8 * (((DoubleBuffer)buffer).arrayOffset() + n2);
        }
        if (buffer instanceof LongBuffer) {
            return 8 * (((LongBuffer)buffer).arrayOffset() + n2);
        }
        if (buffer instanceof CharBuffer) {
            return 2 * (((CharBuffer)buffer).arrayOffset() + n2);
        }
        throw new RuntimeException(new StringBuffer("Unknown buffer type ").append(buffer.getClass().getName()).toString());
    }

    public static void rangeCheck(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        if (byArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer("Required ").append(n3).append(" elements in array, only had ").append(byArray.length - n2).toString());
        }
    }

    public static void rangeCheck(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return;
        }
        if (cArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer("Required ").append(n3).append(" elements in array, only had ").append(cArray.length - n2).toString());
        }
    }

    public static void rangeCheck(short[] sArray, int n2, int n3) {
        if (sArray == null) {
            return;
        }
        if (sArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer("Required ").append(n3).append(" elements in array, only had ").append(sArray.length - n2).toString());
        }
    }

    public static void rangeCheck(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return;
        }
        if (nArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer("Required ").append(n3).append(" elements in array, only had ").append(nArray.length - n2).toString());
        }
    }

    public static void rangeCheck(long[] lArray, int n2, int n3) {
        if (lArray == null) {
            return;
        }
        if (lArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer("Required ").append(n3).append(" elements in array, only had ").append(lArray.length - n2).toString());
        }
    }

    public static void rangeCheck(float[] fArray, int n2, int n3) {
        if (fArray == null) {
            return;
        }
        if (fArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer("Required ").append(n3).append(" elements in array, only had ").append(fArray.length - n2).toString());
        }
    }

    public static void rangeCheck(double[] dArray, int n2, int n3) {
        if (dArray == null) {
            return;
        }
        if (dArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer("Required ").append(n3).append(" elements in array, only had ").append(dArray.length - n2).toString());
        }
    }

    public static void rangeCheck(Buffer buffer, int n2) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n2) {
            throw new IndexOutOfBoundsException(new StringBuffer("Required ").append(n2).append(" remaining elements in buffer, only had ").append(buffer.remaining()).toString());
        }
    }

    public static void rangeCheckBytes(Buffer buffer, int n2) {
        if (buffer == null) {
            return;
        }
        int n3 = buffer.remaining();
        int n4 = 0;
        if (buffer instanceof ByteBuffer) {
            n4 = n3;
        } else if (buffer instanceof FloatBuffer) {
            n4 = n3 << 2;
        } else if (buffer instanceof IntBuffer) {
            n4 = n3 << 2;
        } else if (buffer instanceof ShortBuffer) {
            n4 = n3 << 1;
        } else if (buffer instanceof DoubleBuffer) {
            n4 = n3 << 3;
        } else if (buffer instanceof LongBuffer) {
            n4 = n3 << 3;
        } else if (buffer instanceof CharBuffer) {
            n4 = n3 << 1;
        }
        if (n4 < n2) {
            throw new IndexOutOfBoundsException(new StringBuffer("Required ").append(n2).append(" remaining bytes in buffer, only had ").append(n4).toString());
        }
    }
}

