/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile$SeekableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VorbisFile {
    static final int CHUNKSIZE = 8500;
    static final int SEEK_SET = 0;
    static final int SEEK_CUR = 1;
    static final int SEEK_END = 2;
    static final int OV_FALSE = -1;
    static final int OV_EOF = -2;
    static final int OV_HOLE = -3;
    static final int OV_EREAD = -128;
    static final int OV_EFAULT = -129;
    static final int OV_EIMPL = -130;
    static final int OV_EINVAL = -131;
    static final int OV_ENOTVORBIS = -132;
    static final int OV_EBADHEADER = -133;
    static final int OV_EVERSION = -134;
    static final int OV_ENOTAUDIO = -135;
    static final int OV_EBADPACKET = -136;
    static final int OV_EBADLINK = -137;
    static final int OV_ENOSEEK = -138;
    InputStream datasource;
    boolean seekable = false;
    long offset;
    long end;
    SyncState oy = new SyncState();
    int links;
    long[] offsets;
    long[] dataoffsets;
    int[] serialnos;
    long[] pcmlengths;
    Info[] vi;
    Comment[] vc;
    long pcm_offset;
    boolean decode_ready = false;
    int current_serialno;
    int current_link;
    float bittrack;
    float samptrack;
    StreamState os = new StreamState();
    DspState vd = new DspState();
    Block vb = new Block(this.vd);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VorbisFile(String string) {
        VorbisFile$SeekableInputStream vorbisFile$SeekableInputStream = null;
        try {
            vorbisFile$SeekableInputStream = new VorbisFile$SeekableInputStream(this, string);
            if (this.open(vorbisFile$SeekableInputStream, null, 0) == -1) {
                throw new JOrbisException("VorbisFile: open return -1");
            }
        }
        catch (Exception exception) {
            try {
                throw new JOrbisException("VorbisFile: " + exception.toString());
            }
            catch (Throwable throwable) {
                if (vorbisFile$SeekableInputStream == null) throw throwable;
                try {
                    ((InputStream)vorbisFile$SeekableInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            ((InputStream)vorbisFile$SeekableInputStream).close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public VorbisFile(InputStream inputStream, byte[] byArray, int n2) {
        this.open(inputStream, byArray, n2);
    }

    private int get_data() {
        int n2 = this.oy.buffer(8500);
        byte[] byArray = this.oy.data;
        try {
            n2 = this.datasource.read(byArray, n2, 8500);
        }
        catch (Exception exception) {
            return -128;
        }
        this.oy.wrote(n2);
        if (n2 == -1) {
            n2 = 0;
        }
        return n2;
    }

    private void seek_helper(long l2) {
        VorbisFile.fseek(this.datasource, l2, 0);
        this.offset = l2;
        this.oy.reset();
    }

    private int get_next_page(Page page, long l2) {
        int n2;
        int n3;
        block6: {
            if (l2 > 0L) {
                l2 += this.offset;
            }
            while (true) {
                if (l2 > 0L && this.offset >= l2) {
                    return -1;
                }
                n3 = this.oy.pageseek(page);
                if (n3 < 0) {
                    this.offset -= (long)n3;
                    continue;
                }
                if (n3 != 0) break block6;
                if (l2 == 0L) {
                    return -1;
                }
                n2 = this.get_data();
                if (n2 == 0) {
                    return -2;
                }
                if (n2 < 0) break;
            }
            return -128;
        }
        n2 = (int)this.offset;
        this.offset += (long)n3;
        return n2;
    }

    private int get_prev_page(Page page) {
        long l2 = this.offset;
        int n2 = -1;
        block0: while (n2 == -1) {
            if ((l2 -= 8500L) < 0L) {
                l2 = 0L;
            }
            this.seek_helper(l2);
            while (this.offset < l2 + 8500L) {
                int n3 = this.get_next_page(page, l2 + 8500L - this.offset);
                if (n3 == -128) {
                    return -128;
                }
                if (n3 < 0) {
                    if (n2 != -1) continue block0;
                    throw new JOrbisException();
                }
                n2 = n3;
            }
        }
        this.seek_helper(n2);
        if (this.get_next_page(page, 8500L) < 0) {
            return -129;
        }
        return n2;
    }

    int bisect_forward_serialno(long l2, long l3, long l4, int n2, int n3) {
        int n4;
        long l5 = l4;
        long l6 = l4;
        Page page = new Page();
        while (l3 < l5) {
            long l7 = l5 - l3 < 8500L ? l3 : (l3 + l5) / 2L;
            this.seek_helper(l7);
            n4 = this.get_next_page(page, -1L);
            if (n4 == -128) {
                return -128;
            }
            if (n4 < 0 || page.serialno() != n2) {
                l5 = l7;
                if (n4 < 0) continue;
                l6 = n4;
                continue;
            }
            l3 = n4 + page.header_len + page.body_len;
        }
        this.seek_helper(l6);
        n4 = this.get_next_page(page, -1L);
        if (n4 == -128) {
            return -128;
        }
        if (l3 >= l4 || n4 == -1) {
            this.links = n3 + 1;
            this.offsets = new long[n3 + 2];
            this.offsets[n3 + 1] = l3;
        } else if (this.bisect_forward_serialno(l6, this.offset, l4, page.serialno(), n3 + 1) == -128) {
            return -128;
        }
        this.offsets[n3] = l2;
        return 0;
    }

    int fetch_headers(Info info, Comment comment, int[] nArray, Page page) {
        Page page2 = new Page();
        Packet packet = new Packet();
        if (page == null) {
            int n2 = this.get_next_page(page2, 8500L);
            if (n2 == -128) {
                return -128;
            }
            if (n2 < 0) {
                return -132;
            }
            page = page2;
        }
        if (nArray != null) {
            nArray[0] = page.serialno();
        }
        this.os.init(page.serialno());
        info.init();
        comment.init();
        int n3 = 0;
        while (n3 < 3) {
            int n4;
            this.os.pagein(page);
            while (n3 < 3 && (n4 = this.os.packetout(packet)) != 0) {
                if (n4 == -1) {
                    info.clear();
                    comment.clear();
                    this.os.clear();
                    return -1;
                }
                if (info.synthesis_headerin(comment, packet) != 0) {
                    info.clear();
                    comment.clear();
                    this.os.clear();
                    return -1;
                }
                ++n3;
            }
            if (n3 >= 3 || this.get_next_page(page, 1L) >= 0) continue;
            info.clear();
            comment.clear();
            this.os.clear();
            return -1;
        }
        return 0;
    }

    void prefetch_all_headers(Info info, Comment comment, int n2) {
        Page page = new Page();
        this.vi = new Info[this.links];
        this.vc = new Comment[this.links];
        this.dataoffsets = new long[this.links];
        this.pcmlengths = new long[this.links];
        this.serialnos = new int[this.links];
        block0: for (int i2 = 0; i2 < this.links; ++i2) {
            if (info != null && comment != null && i2 == 0) {
                this.vi[i2] = info;
                this.vc[i2] = comment;
                this.dataoffsets[i2] = n2;
            } else {
                this.seek_helper(this.offsets[i2]);
                this.vi[i2] = new Info();
                this.vc[i2] = new Comment();
                if (this.fetch_headers(this.vi[i2], this.vc[i2], null, null) == -1) {
                    this.dataoffsets[i2] = -1L;
                } else {
                    this.dataoffsets[i2] = this.offset;
                    this.os.clear();
                }
            }
            long l2 = this.offsets[i2 + 1];
            this.seek_helper(l2);
            do {
                if (this.get_prev_page(page) != -1) continue;
                this.vi[i2].clear();
                this.vc[i2].clear();
                continue block0;
            } while (page.granulepos() == -1L);
            this.serialnos[i2] = page.serialno();
            this.pcmlengths[i2] = page.granulepos();
        }
    }

    int make_decode_ready() {
        if (this.decode_ready) {
            System.exit(1);
        }
        this.vd.synthesis_init(this.vi[0]);
        this.vb.init(this.vd);
        this.decode_ready = true;
        return 0;
    }

    int open_seekable() {
        Info info = new Info();
        Comment comment = new Comment();
        Page page = new Page();
        int[] nArray = new int[1];
        int n2 = this.fetch_headers(info, comment, nArray, null);
        int n3 = nArray[0];
        int n4 = (int)this.offset;
        this.os.clear();
        if (n2 == -1) {
            return -1;
        }
        this.seekable = true;
        VorbisFile.fseek(this.datasource, 0L, 2);
        this.offset = VorbisFile.ftell(this.datasource);
        long l2 = this.get_prev_page(page);
        if (page.serialno() != n3) {
            if (this.bisect_forward_serialno(0L, 0L, l2 + 1L, n3, 0) < 0) {
                this.clear();
                return -128;
            }
        } else if (this.bisect_forward_serialno(0L, l2, l2 + 1L, n3, 0) < 0) {
            this.clear();
            return -128;
        }
        this.prefetch_all_headers(info, comment, n4);
        return this.raw_seek(0);
    }

    int open_nonseekable() {
        this.links = 1;
        this.vi = new Info[this.links];
        this.vi[0] = new Info();
        this.vc = new Comment[this.links];
        this.vc[0] = new Comment();
        int[] nArray = new int[1];
        if (this.fetch_headers(this.vi[0], this.vc[0], nArray, null) == -1) {
            return -1;
        }
        this.current_serialno = nArray[0];
        this.make_decode_ready();
        return 0;
    }

    void decode_clear() {
        this.os.clear();
        this.vd.clear();
        this.vb.clear();
        this.decode_ready = false;
        this.bittrack = 0.0f;
        this.samptrack = 0.0f;
    }

    int process_packet(int n2) {
        Page page = new Page();
        while (true) {
            Object object;
            if (this.decode_ready && this.os.packetout((Packet)(object = new Packet())) > 0) {
                long l2 = ((Packet)object).granulepos;
                if (this.vb.synthesis((Packet)object) == 0) {
                    n2 = this.vd.synthesis_pcmout(null, null);
                    this.vd.synthesis_blockin(this.vb);
                    this.samptrack += (float)(this.vd.synthesis_pcmout(null, null) - n2);
                    this.bittrack += (float)(((Packet)object).bytes << 3);
                    if (l2 != -1L && ((Packet)object).e_o_s == 0) {
                        n2 = this.seekable ? this.current_link : 0;
                        int n3 = this.vd.synthesis_pcmout(null, null);
                        l2 -= (long)n3;
                        for (n3 = 0; n3 < n2; ++n3) {
                            l2 += this.pcmlengths[n3];
                        }
                        this.pcm_offset = l2;
                    }
                    return 1;
                }
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.get_next_page(page, -1L) < 0) {
                return 0;
            }
            this.bittrack += (float)(page.header_len << 3);
            if (this.decode_ready && this.current_serialno != page.serialno()) {
                this.decode_clear();
            }
            if (!this.decode_ready) {
                if (this.seekable) {
                    int n4;
                    this.current_serialno = page.serialno();
                    for (n4 = 0; n4 < this.links && this.serialnos[n4] != this.current_serialno; ++n4) {
                    }
                    if (n4 == this.links) {
                        return -1;
                    }
                    this.current_link = n4;
                    this.os.init(this.current_serialno);
                    this.os.reset();
                } else {
                    object = new int[1];
                    int n5 = this.fetch_headers(this.vi[0], this.vc[0], (int[])object, page);
                    this.current_serialno = (int)object[0];
                    if (n5 != 0) {
                        return n5;
                    }
                    ++this.current_link;
                }
                this.make_decode_ready();
            }
            this.os.pagein(page);
        }
    }

    int clear() {
        this.vb.clear();
        this.vd.clear();
        this.os.clear();
        if (this.vi != null && this.links != 0) {
            for (int i2 = 0; i2 < this.links; ++i2) {
                this.vi[i2].clear();
                this.vc[i2].clear();
            }
            this.vi = null;
            this.vc = null;
        }
        if (this.dataoffsets != null) {
            this.dataoffsets = null;
        }
        if (this.pcmlengths != null) {
            this.pcmlengths = null;
        }
        if (this.serialnos != null) {
            this.serialnos = null;
        }
        if (this.offsets != null) {
            this.offsets = null;
        }
        this.oy.clear();
        return 0;
    }

    static int fseek(InputStream inputStream, long l2, int n2) {
        if (inputStream instanceof VorbisFile$SeekableInputStream) {
            inputStream = (VorbisFile$SeekableInputStream)inputStream;
            try {
                if (n2 == 0) {
                    ((VorbisFile$SeekableInputStream)inputStream).seek(l2);
                } else if (n2 == 2) {
                    ((VorbisFile$SeekableInputStream)inputStream).seek(((VorbisFile$SeekableInputStream)inputStream).getLength() - l2);
                }
            }
            catch (Exception exception) {}
            return 0;
        }
        try {
            if (n2 == 0) {
                inputStream.reset();
            }
            inputStream.skip(l2);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    static long ftell(InputStream inputStream) {
        try {
            if (inputStream instanceof VorbisFile$SeekableInputStream) {
                return ((VorbisFile$SeekableInputStream)inputStream).tell();
            }
        }
        catch (Exception exception) {}
        return 0L;
    }

    int open(InputStream inputStream, byte[] byArray, int n2) {
        return this.open_callbacks(inputStream, byArray, n2);
    }

    int open_callbacks(InputStream inputStream, byte[] byArray, int n2) {
        int n3;
        this.datasource = inputStream;
        this.oy.init();
        if (byArray != null) {
            int n4 = this.oy.buffer(n2);
            System.arraycopy(byArray, 0, this.oy.data, n4, n2);
            this.oy.wrote(n2);
        }
        if ((n3 = inputStream instanceof VorbisFile$SeekableInputStream ? this.open_seekable() : this.open_nonseekable()) != 0) {
            this.datasource = null;
            this.clear();
        }
        return n3;
    }

    public int streams() {
        return this.links;
    }

    public boolean seekable() {
        return this.seekable;
    }

    public int bitrate(int n2) {
        if (n2 >= this.links) {
            return -1;
        }
        if (!this.seekable && n2 != 0) {
            return this.bitrate(0);
        }
        if (n2 < 0) {
            long l2 = 0L;
            for (n2 = 0; n2 < this.links; ++n2) {
                l2 += this.offsets[n2 + 1] - this.dataoffsets[n2] << 3;
            }
            return (int)Math.rint((float)l2 / this.time_total(-1));
        }
        if (this.seekable) {
            return (int)Math.rint((float)(this.offsets[n2 + 1] - this.dataoffsets[n2] << 3) / this.time_total(n2));
        }
        if (this.vi[n2].bitrate_nominal > 0) {
            return this.vi[n2].bitrate_nominal;
        }
        if (this.vi[n2].bitrate_upper > 0) {
            if (this.vi[n2].bitrate_lower > 0) {
                return (this.vi[n2].bitrate_upper + this.vi[n2].bitrate_lower) / 2;
            }
            return this.vi[n2].bitrate_upper;
        }
        return -1;
    }

    public int bitrate_instant() {
        int n2;
        int n3 = n2 = this.seekable ? this.current_link : 0;
        if (this.samptrack == 0.0f) {
            return -1;
        }
        n2 = (int)((double)(this.bittrack / this.samptrack * (float)this.vi[n2].rate) + 0.5);
        this.bittrack = 0.0f;
        this.samptrack = 0.0f;
        return n2;
    }

    public int serialnumber(int n2) {
        if (n2 >= this.links) {
            return -1;
        }
        if (!this.seekable && n2 >= 0) {
            return this.serialnumber(-1);
        }
        if (n2 < 0) {
            return this.current_serialno;
        }
        return this.serialnos[n2];
    }

    public long raw_total(int n2) {
        if (!this.seekable || n2 >= this.links) {
            return -1L;
        }
        if (n2 < 0) {
            long l2 = 0L;
            for (n2 = 0; n2 < this.links; ++n2) {
                l2 += this.raw_total(n2);
            }
            return l2;
        }
        return this.offsets[n2 + 1] - this.offsets[n2];
    }

    public long pcm_total(int n2) {
        if (!this.seekable || n2 >= this.links) {
            return -1L;
        }
        if (n2 < 0) {
            long l2 = 0L;
            for (n2 = 0; n2 < this.links; ++n2) {
                l2 += this.pcm_total(n2);
            }
            return l2;
        }
        return this.pcmlengths[n2];
    }

    public float time_total(int n2) {
        if (!this.seekable || n2 >= this.links) {
            return -1.0f;
        }
        if (n2 < 0) {
            float f2 = 0.0f;
            for (int i2 = 0; i2 < this.links; ++i2) {
                f2 += this.time_total(i2);
            }
            return f2;
        }
        return (float)this.pcmlengths[n2] / (float)this.vi[n2].rate;
    }

    public int raw_seek(int n2) {
        if (!this.seekable) {
            return -1;
        }
        if (n2 < 0 || (long)n2 > this.offsets[this.links]) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        this.pcm_offset = -1L;
        this.decode_clear();
        this.seek_helper(n2);
        switch (this.process_packet(1)) {
            case 0: {
                this.pcm_offset = this.pcm_total(-1);
                return 0;
            }
            case -1: {
                this.pcm_offset = -1L;
                this.decode_clear();
                return -1;
            }
        }
        while (true) {
            switch (this.process_packet(0)) {
                case 0: {
                    return 0;
                }
                case -1: {
                    this.pcm_offset = -1L;
                    this.decode_clear();
                    return -1;
                }
            }
        }
    }

    public int pcm_seek(long l2) {
        int n2;
        long l3 = this.pcm_total(-1);
        if (!this.seekable) {
            return -1;
        }
        if (l2 < 0L || l2 > l3) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        for (n2 = this.links - 1; n2 >= 0 && l2 < (l3 -= this.pcmlengths[n2]); --n2) {
        }
        long l4 = l2 - l3;
        long l5 = this.offsets[n2 + 1];
        long l6 = this.offsets[n2];
        n2 = (int)l6;
        Page page = new Page();
        while (l6 < l5) {
            long l7 = l5 - l6 < 8500L ? l6 : (l5 + l6) / 2L;
            this.seek_helper(l7);
            int n3 = this.get_next_page(page, l5 - l7);
            if (n3 != -1 && page.granulepos() < l4) {
                n2 = n3;
                l6 = this.offset;
                continue;
            }
            l5 = l7;
        }
        if (this.raw_seek(n2) != 0) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        if (this.pcm_offset >= l2) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        if (l2 > this.pcm_total(-1)) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        while (this.pcm_offset < l2) {
            int n4 = (int)(l2 - this.pcm_offset);
            float[][][] fArrayArray = new float[1][][];
            int[] nArray = new int[this.getInfo((int)-1).channels];
            int n5 = this.vd.synthesis_pcmout(fArrayArray, nArray);
            if (n5 > n4) {
                n5 = n4;
            }
            this.vd.synthesis_read(n5);
            this.pcm_offset += (long)n5;
            if (n5 >= n4 || this.process_packet(1) != 0) continue;
            this.pcm_offset = this.pcm_total(-1);
        }
        return 0;
    }

    int time_seek(float f2) {
        int n2;
        long l2 = this.pcm_total(-1);
        float f3 = this.time_total(-1);
        if (!this.seekable) {
            return -1;
        }
        if (f2 < 0.0f || f2 > f3) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        for (n2 = this.links - 1; n2 >= 0; --n2) {
            l2 -= this.pcmlengths[n2];
            if (f2 >= (f3 -= this.time_total(n2))) break;
        }
        long l3 = (long)((float)l2 + (f2 - f3) * (float)this.vi[n2].rate);
        return this.pcm_seek(l3);
    }

    public long raw_tell() {
        return this.offset;
    }

    public long pcm_tell() {
        return this.pcm_offset;
    }

    public float time_tell() {
        int n2 = -1;
        long l2 = 0L;
        float f2 = 0.0f;
        if (this.seekable) {
            l2 = this.pcm_total(-1);
            f2 = this.time_total(-1);
            for (n2 = this.links - 1; n2 >= 0; --n2) {
                f2 -= this.time_total(n2);
                if (this.pcm_offset >= (l2 -= this.pcmlengths[n2])) break;
            }
        }
        return f2 + (float)(this.pcm_offset - l2) / (float)this.vi[n2].rate;
    }

    public Info getInfo(int n2) {
        if (this.seekable) {
            if (n2 < 0) {
                if (this.decode_ready) {
                    return this.vi[this.current_link];
                }
                return null;
            }
            if (n2 >= this.links) {
                return null;
            }
            return this.vi[n2];
        }
        if (this.decode_ready) {
            return this.vi[0];
        }
        return null;
    }

    public Comment getComment(int n2) {
        if (this.seekable) {
            if (n2 < 0) {
                if (this.decode_ready) {
                    return this.vc[this.current_link];
                }
                return null;
            }
            if (n2 >= this.links) {
                return null;
            }
            return this.vc[n2];
        }
        if (this.decode_ready) {
            return this.vc[0];
        }
        return null;
    }

    int host_is_big_endian() {
        return 1;
    }

    int read(byte[] byArray, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6 = this.host_is_big_endian();
        int n7 = 0;
        while (true) {
            if (this.decode_ready) {
                Object object = new float[1][][];
                int[] nArray2 = new int[this.getInfo((int)-1).channels];
                int n8 = this.vd.synthesis_pcmout((float[][][])object, nArray2);
                object = object[0];
                if (n8 != 0) {
                    int n9 = this.getInfo((int)-1).channels;
                    int n10 = n4 * n9;
                    if (n8 > n2 / n10) {
                        n8 = n2 / n10;
                    }
                    if (n4 == 1) {
                        n4 = n5 != 0 ? 0 : 128;
                        for (n3 = 0; n3 < n8; ++n3) {
                            for (n5 = 0; n5 < n9; ++n5) {
                                n2 = (int)((double)object[n5][nArray2[n5] + n3] * 128.0 + 0.5);
                                if (n2 > 127) {
                                    n2 = 127;
                                } else if (n2 < -128) {
                                    n2 = -128;
                                }
                                byArray[n7++] = (byte)(n2 + n4);
                            }
                        }
                    } else {
                        int n11 = n4 = n5 != 0 ? 0 : 32768;
                        if (n6 == n3) {
                            if (n5 != 0) {
                                for (n3 = 0; n3 < n9; ++n3) {
                                    n5 = nArray2[n3];
                                    n6 = n3;
                                    for (n7 = 0; n7 < n8; ++n7) {
                                        n2 = (int)((double)object[n3][n5 + n7] * 32768.0 + 0.5);
                                        if (n2 > Short.MAX_VALUE) {
                                            n2 = Short.MAX_VALUE;
                                        } else if (n2 < Short.MIN_VALUE) {
                                            n2 = Short.MIN_VALUE;
                                        }
                                        byArray[n6] = (byte)(n2 >>> 8);
                                        byArray[n6 + 1] = (byte)n2;
                                        n6 += n9 << 1;
                                    }
                                }
                            } else {
                                for (n3 = 0; n3 < n9; ++n3) {
                                    float[][] fArray = object[n3];
                                    n6 = n3;
                                    for (n7 = 0; n7 < n8; ++n7) {
                                        n2 = (int)((double)fArray[n7] * 32768.0 + 0.5);
                                        if (n2 > Short.MAX_VALUE) {
                                            n2 = Short.MAX_VALUE;
                                        } else if (n2 < Short.MIN_VALUE) {
                                            n2 = Short.MIN_VALUE;
                                        }
                                        byArray[n6] = (byte)(n2 + n4 >>> 8);
                                        byArray[n6 + 1] = (byte)(n2 + n4);
                                        n6 += n9 << 1;
                                    }
                                }
                            }
                        } else if (n3 != 0) {
                            for (n3 = 0; n3 < n8; ++n3) {
                                for (n5 = 0; n5 < n9; ++n5) {
                                    n2 = (int)((double)object[n5][n3] * 32768.0 + 0.5);
                                    if (n2 > Short.MAX_VALUE) {
                                        n2 = Short.MAX_VALUE;
                                    } else if (n2 < Short.MIN_VALUE) {
                                        n2 = Short.MIN_VALUE;
                                    }
                                    byArray[n7++] = (byte)((n2 += n4) >>> 8);
                                    byArray[n7++] = (byte)n2;
                                }
                            }
                        } else {
                            for (n3 = 0; n3 < n8; ++n3) {
                                for (n5 = 0; n5 < n9; ++n5) {
                                    n2 = (int)((double)object[n5][n3] * 32768.0 + 0.5);
                                    if (n2 > Short.MAX_VALUE) {
                                        n2 = Short.MAX_VALUE;
                                    } else if (n2 < Short.MIN_VALUE) {
                                        n2 = Short.MIN_VALUE;
                                    }
                                    byArray[n7++] = (byte)(n2 += n4);
                                    byArray[n7++] = (byte)(n2 >>> 8);
                                }
                            }
                        }
                    }
                    this.vd.synthesis_read(n8);
                    this.pcm_offset += (long)n8;
                    if (nArray != null) {
                        nArray[0] = this.current_link;
                    }
                    return n8 * n10;
                }
            }
            switch (this.process_packet(1)) {
                case 0: {
                    return 0;
                }
                case -1: {
                    return -1;
                }
            }
        }
    }

    public Info[] getInfo() {
        return this.vi;
    }

    public Comment[] getComment() {
        return this.vc;
    }

    public void close() {
        this.datasource.close();
    }
}

