/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.EchstateFloor0;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoFloor0;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.LookFloor0;
import com.jcraft.jorbis.Lsp;

class Floor0
extends FuncFloor {
    float[] lsp = null;

    Floor0() {
    }

    @Override
    void pack(Object object, Buffer buffer) {
        object = (InfoFloor0)object;
        buffer.write(((InfoFloor0)object).order, 8);
        buffer.write(((InfoFloor0)object).rate, 16);
        buffer.write(((InfoFloor0)object).barkmap, 16);
        buffer.write(((InfoFloor0)object).ampbits, 6);
        buffer.write(((InfoFloor0)object).ampdB, 8);
        buffer.write(((InfoFloor0)object).numbooks - 1, 4);
        for (int i2 = 0; i2 < ((InfoFloor0)object).numbooks; ++i2) {
            buffer.write(((InfoFloor0)object).books[i2], 8);
        }
    }

    @Override
    Object unpack(Info info, Buffer buffer) {
        InfoFloor0 infoFloor0 = new InfoFloor0();
        new InfoFloor0().order = buffer.read(8);
        infoFloor0.rate = buffer.read(16);
        infoFloor0.barkmap = buffer.read(16);
        infoFloor0.ampbits = buffer.read(6);
        infoFloor0.ampdB = buffer.read(8);
        infoFloor0.numbooks = buffer.read(4) + 1;
        if (infoFloor0.order <= 0 || infoFloor0.rate <= 0 || infoFloor0.barkmap <= 0 || infoFloor0.numbooks <= 0) {
            return null;
        }
        for (int i2 = 0; i2 < infoFloor0.numbooks; ++i2) {
            infoFloor0.books[i2] = buffer.read(8);
            if (infoFloor0.books[i2] >= 0 && infoFloor0.books[i2] < info.books) continue;
            return null;
        }
        return infoFloor0;
    }

    @Override
    Object look(DspState object, InfoMode infoMode, Object object2) {
        object = ((DspState)object).vi;
        object2 = (InfoFloor0)object2;
        LookFloor0 lookFloor0 = new LookFloor0();
        new LookFloor0().m = ((InfoFloor0)object2).order;
        lookFloor0.n = ((Info)object).blocksizes[infoMode.blockflag] / 2;
        lookFloor0.ln = ((InfoFloor0)object2).barkmap;
        lookFloor0.vi = object2;
        lookFloor0.lpclook.init(lookFloor0.ln, lookFloor0.m);
        float f2 = (float)lookFloor0.ln / Floor0.toBARK((float)((double)((InfoFloor0)object2).rate / 2.0));
        lookFloor0.linearmap = new int[lookFloor0.n];
        for (int i2 = 0; i2 < lookFloor0.n; ++i2) {
            int n2 = (int)Math.floor(Floor0.toBARK((float)((double)((InfoFloor0)object2).rate / 2.0 / (double)lookFloor0.n * (double)i2)) * f2);
            if (n2 >= lookFloor0.ln) {
                n2 = lookFloor0.ln;
            }
            lookFloor0.linearmap[i2] = n2;
        }
        return lookFloor0;
    }

    static float toBARK(float f2) {
        return (float)(13.1 * Math.atan(7.4E-4 * (double)f2) + 2.24 * Math.atan((double)(f2 * f2) * 1.85E-8) + 1.0E-4 * (double)f2);
    }

    Object state(Object object) {
        EchstateFloor0 echstateFloor0 = new EchstateFloor0();
        object = (InfoFloor0)object;
        echstateFloor0.codewords = new int[((InfoFloor0)object).order];
        echstateFloor0.curve = new float[((InfoFloor0)object).barkmap];
        echstateFloor0.frameno = -1L;
        return echstateFloor0;
    }

    @Override
    void free_info(Object object) {
    }

    @Override
    void free_look(Object object) {
    }

    @Override
    void free_state(Object object) {
    }

    @Override
    int forward(Block block, Object object, float[] fArray, float[] fArray2, Object object2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int inverse(Block block, Object object, float[] fArray) {
        object = (LookFloor0)object;
        InfoFloor0 infoFloor0 = ((LookFloor0)object).vi;
        int n2 = block.opb.read(infoFloor0.ampbits);
        if (n2 > 0) {
            int n3 = (1 << infoFloor0.ampbits) - 1;
            float f2 = (float)n2 / (float)n3 * (float)infoFloor0.ampdB;
            n3 = block.opb.read(Floor0.ilog(infoFloor0.numbooks));
            if (n3 != -1 && n3 < infoFloor0.numbooks) {
                Floor0 floor0 = this;
                synchronized (floor0) {
                    int n4;
                    if (this.lsp == null || this.lsp.length < ((LookFloor0)object).m) {
                        this.lsp = new float[((LookFloor0)object).m];
                    } else {
                        for (int i2 = 0; i2 < ((LookFloor0)object).m; ++i2) {
                            this.lsp[i2] = 0.0f;
                        }
                    }
                    CodeBook codeBook = block.vd.fullbooks[infoFloor0.books[n3]];
                    float f3 = 0.0f;
                    for (n4 = 0; n4 < ((LookFloor0)object).m; ++n4) {
                        fArray[n4] = 0.0f;
                    }
                    for (n4 = 0; n4 < ((LookFloor0)object).m; n4 += codeBook.dim) {
                        if (codeBook.decodevs(this.lsp, n4, block.opb, 1, -1) != -1) continue;
                        for (int i3 = 0; i3 < ((LookFloor0)object).n; ++i3) {
                            fArray[i3] = 0.0f;
                        }
                        return 0;
                    }
                    n4 = 0;
                    while (n4 < ((LookFloor0)object).m) {
                        for (int i4 = 0; i4 < codeBook.dim; ++i4) {
                            int n5 = n4++;
                            this.lsp[n5] = this.lsp[n5] + f3;
                        }
                        f3 = this.lsp[n4 - 1];
                    }
                    Lsp.lsp_to_curve(fArray, ((LookFloor0)object).linearmap, ((LookFloor0)object).n, ((LookFloor0)object).ln, this.lsp, ((LookFloor0)object).m, f2, infoFloor0.ampdB);
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    Object inverse1(Block block, Object object, Object object2) {
        int n2;
        object = (LookFloor0)object;
        Object object3 = ((LookFloor0)object).vi;
        float[] fArray = null;
        if (object2 instanceof float[]) {
            fArray = (float[])object2;
        }
        if ((n2 = block.opb.read(((InfoFloor0)object3).ampbits)) > 0) {
            int n3 = (1 << ((InfoFloor0)object3).ampbits) - 1;
            float f2 = (float)n2 / (float)n3 * (float)((InfoFloor0)object3).ampdB;
            n3 = block.opb.read(Floor0.ilog(((InfoFloor0)object3).numbooks));
            if (n3 != -1 && n3 < ((InfoFloor0)object3).numbooks) {
                int n4;
                object3 = block.vd.fullbooks[((InfoFloor0)object3).books[n3]];
                float f3 = 0.0f;
                if (fArray == null || fArray.length < ((LookFloor0)object).m + 1) {
                    fArray = new float[((LookFloor0)object).m + 1];
                } else {
                    for (n4 = 0; n4 < fArray.length; ++n4) {
                        fArray[n4] = 0.0f;
                    }
                }
                for (n4 = 0; n4 < ((LookFloor0)object).m; n4 += ((CodeBook)object3).dim) {
                    if (((CodeBook)object3).decodev_set(fArray, n4, block.opb, ((CodeBook)object3).dim) != -1) continue;
                    return null;
                }
                n4 = 0;
                while (n4 < ((LookFloor0)object).m) {
                    for (int i2 = 0; i2 < ((CodeBook)object3).dim; ++i2) {
                        int n5 = n4++;
                        fArray[n5] = fArray[n5] + f3;
                    }
                    f3 = fArray[n4 - 1];
                }
                fArray[((LookFloor0)object).m] = f2;
                return fArray;
            }
        }
        return null;
    }

    @Override
    int inverse2(Block object, Object object2, Object object3, float[] fArray) {
        object = (LookFloor0)object2;
        object2 = ((LookFloor0)object).vi;
        if (object3 != null) {
            float[] fArray2 = (float[])object3;
            object3 = fArray2;
            float f2 = fArray2[((LookFloor0)object).m];
            Lsp.lsp_to_curve(fArray, ((LookFloor0)object).linearmap, ((LookFloor0)object).n, ((LookFloor0)object).ln, (float[])object3, ((LookFloor0)object).m, f2, ((InfoFloor0)object2).ampdB);
            return 1;
        }
        for (int i2 = 0; i2 < ((LookFloor0)object).n; ++i2) {
            fArray[i2] = 0.0f;
        }
        return 0;
    }

    static float fromdB(float f2) {
        return (float)Math.exp((double)f2 * 0.11512925);
    }

    private static int ilog(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }

    static void lsp_to_lpc(float[] fArray, float[] fArray2, int n2) {
        int n3;
        int n4;
        int n5 = n2 / 2;
        float[] fArray3 = new float[n5];
        float[] fArray4 = new float[n5];
        float[] fArray5 = new float[n5 + 1];
        float[] fArray6 = new float[n5 + 1];
        float[] fArray7 = new float[n5];
        float[] fArray8 = new float[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            fArray3[n4] = (float)(-2.0 * Math.cos(fArray[n4 << 1]));
            fArray4[n4] = (float)(-2.0 * Math.cos(fArray[(n4 << 1) + 1]));
        }
        for (n3 = 0; n3 < n5; ++n3) {
            fArray5[n3] = 0.0f;
            fArray6[n3] = 1.0f;
            fArray7[n3] = 0.0f;
            fArray8[n3] = 1.0f;
        }
        fArray6[n3] = 1.0f;
        fArray5[n3] = 1.0f;
        for (n4 = 1; n4 < n2 + 1; ++n4) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (n3 = 0; n3 < n5; ++n3) {
                float f4 = fArray3[n3] * fArray6[n3] + fArray5[n3];
                fArray5[n3] = fArray6[n3];
                fArray6[n3] = f3;
                f3 += f4;
                f4 = fArray4[n3] * fArray8[n3] + fArray7[n3];
                fArray7[n3] = fArray8[n3];
                fArray8[n3] = f2;
                f2 += f4;
            }
            fArray2[n4 - 1] = (f3 + fArray6[n3] + f2 - fArray5[n3]) / 2.0f;
            fArray6[n3] = f3;
            fArray5[n3] = f2;
        }
    }

    static void lpc_to_curve(float[] fArray, float[] fArray2, float f2, LookFloor0 lookFloor0, String object, int n2) {
        object = new float[Math.max(lookFloor0.ln << 1, (lookFloor0.m << 1) + 2)];
        if (f2 == 0.0f) {
            for (int i2 = 0; i2 < lookFloor0.n; ++i2) {
                fArray[i2] = 0.0f;
            }
            return;
        }
        lookFloor0.lpclook.lpc_to_curve((float[])object, fArray2, f2);
        for (int i3 = 0; i3 < lookFloor0.n; ++i3) {
            fArray[i3] = (float)object[lookFloor0.linearmap[i3]];
        }
    }
}

