/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.DecodeAux;
import com.jcraft.jorbis.EncodeAuxNearestMatch;
import com.jcraft.jorbis.EncodeAuxThreshMatch;
import com.jcraft.jorbis.StaticCodeBook;

class CodeBook {
    int dim;
    int entries;
    StaticCodeBook c = new StaticCodeBook();
    float[] valuelist;
    int[] codelist;
    DecodeAux decode_tree;
    private int[] t = new int[15];

    CodeBook() {
    }

    int encode(int n2, Buffer buffer) {
        buffer.write(this.codelist[n2], this.c.lengthlist[n2]);
        return this.c.lengthlist[n2];
    }

    int errorv(float[] fArray) {
        int n2 = this.best(fArray, 1);
        for (int i2 = 0; i2 < this.dim; ++i2) {
            fArray[i2] = this.valuelist[n2 * this.dim + i2];
        }
        return n2;
    }

    int encodev(int n2, float[] fArray, Buffer buffer) {
        for (int i2 = 0; i2 < this.dim; ++i2) {
            fArray[i2] = this.valuelist[n2 * this.dim + i2];
        }
        return this.encode(n2, buffer);
    }

    int encodevs(float[] fArray, Buffer buffer, int n2, int n3) {
        int n4 = this.besterror(fArray, n2, n3);
        return this.encode(n4, buffer);
    }

    synchronized int decodevs_add(float[] fArray, int n2, Buffer buffer, int n3) {
        int n4;
        int n5;
        if (this.t.length < (n3 /= this.dim)) {
            this.t = new int[n3];
        }
        for (n5 = 0; n5 < n3; ++n5) {
            n4 = this.decode(buffer);
            if (n4 == -1) {
                return -1;
            }
            this.t[n5] = n4 * this.dim;
        }
        n5 = 0;
        n4 = 0;
        while (n5 < this.dim) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n6 = n2 + n4 + i2;
                fArray[n6] = fArray[n6] + this.valuelist[this.t[i2] + n5];
            }
            ++n5;
            n4 += n3;
        }
        return 0;
    }

    int decodev_add(float[] fArray, int n2, Buffer buffer, int n3) {
        if (this.dim > 8) {
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.decode(buffer);
                if (n5 == -1) {
                    return -1;
                }
                int n6 = n5 * this.dim;
                n5 = 0;
                while (n5 < this.dim) {
                    int n7 = n2 + n4++;
                    fArray[n7] = fArray[n7] + this.valuelist[n6 + n5++];
                }
            }
        } else {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = this.decode(buffer);
                if (n9 == -1) {
                    return -1;
                }
                int n10 = n9 * this.dim;
                n9 = 0;
                switch (this.dim) {
                    case 8: {
                        int n11 = n2 + n8++;
                        fArray[n11] = fArray[n11] + this.valuelist[n10 + 0];
                    }
                    case 7: {
                        int n12 = n2 + n8++;
                        int n13 = ++n9;
                        fArray[n12] = fArray[n12] + this.valuelist[n10 + n13];
                    }
                    case 6: {
                        int n14 = n2 + n8++;
                        int n15 = ++n9;
                        fArray[n14] = fArray[n14] + this.valuelist[n10 + n15];
                    }
                    case 5: {
                        int n16 = n2 + n8++;
                        int n17 = ++n9;
                        fArray[n16] = fArray[n16] + this.valuelist[n10 + n17];
                    }
                    case 4: {
                        int n18 = n2 + n8++;
                        int n19 = ++n9;
                        fArray[n18] = fArray[n18] + this.valuelist[n10 + n19];
                    }
                    case 3: {
                        int n20 = n2 + n8++;
                        int n21 = ++n9;
                        fArray[n20] = fArray[n20] + this.valuelist[n10 + n21];
                    }
                    case 2: {
                        int n22 = n2 + n8++;
                        int n23 = ++n9;
                        ++n9;
                        fArray[n22] = fArray[n22] + this.valuelist[n10 + n23];
                    }
                    case 1: {
                        int n24 = n2 + n8++;
                        fArray[n24] = fArray[n24] + this.valuelist[n10 + n9];
                    }
                }
            }
        }
        return 0;
    }

    int decodev_set(float[] fArray, int n2, Buffer buffer, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.decode(buffer);
            if (n5 == -1) {
                return -1;
            }
            int n6 = n5 * this.dim;
            n5 = 0;
            while (n5 < this.dim) {
                fArray[n2 + n4++] = this.valuelist[n6 + n5++];
            }
        }
        return 0;
    }

    int decodevv_add(float[][] fArray, int n2, int n3, Buffer buffer, int n4) {
        int n5 = 0;
        int n6 = n2 / n3;
        while (n6 < (n2 + n4) / n3) {
            int n7 = this.decode(buffer);
            if (n7 == -1) {
                return -1;
            }
            int n8 = n7 * this.dim;
            for (n7 = 0; n7 < this.dim; ++n7) {
                float[] fArray2 = fArray[n5++];
                int n9 = n6++;
                fArray2[n9] = fArray2[n9] + this.valuelist[n8 + n7];
                if (n5 != n3) continue;
                n5 = 0;
            }
        }
        return 0;
    }

    int decode(Buffer buffer) {
        int n2 = 0;
        DecodeAux decodeAux = this.decode_tree;
        int n3 = buffer.look(decodeAux.tabn);
        if (n3 >= 0) {
            n2 = decodeAux.tab[n3];
            buffer.adv(decodeAux.tabl[n3]);
            if (n2 <= 0) {
                return -n2;
            }
        }
        do {
            switch (buffer.read1()) {
                case 0: {
                    n2 = decodeAux.ptr0[n2];
                    break;
                }
                case 1: {
                    n2 = decodeAux.ptr1[n2];
                    break;
                }
                default: {
                    return -1;
                }
            }
        } while (n2 > 0);
        return -n2;
    }

    int decodevs(float[] fArray, int n2, Buffer buffer, int n3, int n4) {
        int n5 = this.decode(buffer);
        if (n5 == -1) {
            return -1;
        }
        switch (n4) {
            case -1: {
                n4 = 0;
                int n6 = 0;
                while (n4 < this.dim) {
                    fArray[n2 + n6] = this.valuelist[n5 * this.dim + n4];
                    ++n4;
                    n6 += n3;
                }
                break;
            }
            case 0: {
                n4 = 0;
                int n7 = 0;
                while (n4 < this.dim) {
                    int n8 = n2 + n7;
                    fArray[n8] = fArray[n8] + this.valuelist[n5 * this.dim + n4];
                    ++n4;
                    n7 += n3;
                }
                break;
            }
            case 1: {
                n4 = 0;
                int n9 = 0;
                while (n4 < this.dim) {
                    int n10 = n2 + n9;
                    fArray[n10] = fArray[n10] * this.valuelist[n5 * this.dim + n4];
                    ++n4;
                    n9 += n3;
                }
                break;
            }
        }
        return n5;
    }

    int best(float[] fArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        EncodeAuxNearestMatch encodeAuxNearestMatch = this.c.nearest_tree;
        EncodeAuxThreshMatch encodeAuxThreshMatch = this.c.thresh_tree;
        int n7 = 0;
        if (encodeAuxThreshMatch != null) {
            n6 = 0;
            n5 = 0;
            n4 = n2 * (this.dim - 1);
            while (n5 < this.dim) {
                for (n3 = 0; n3 < encodeAuxThreshMatch.threshvals - 1 && !(fArray[n4] < encodeAuxThreshMatch.quantthresh[n3]); ++n3) {
                }
                n6 = n6 * encodeAuxThreshMatch.quantvals + encodeAuxThreshMatch.quantmap[n3];
                ++n5;
                n4 -= n2;
            }
            if (this.c.lengthlist[n6] > 0) {
                return n6;
            }
        }
        if (encodeAuxNearestMatch != null) {
            float f2;
            do {
                f2 = 0.0f;
                n5 = encodeAuxNearestMatch.p[n7];
                n4 = encodeAuxNearestMatch.q[n7];
                n3 = 0;
                int n8 = 0;
                while (n3 < this.dim) {
                    f2 = (float)((double)f2 + (double)(this.valuelist[n5 + n3] - this.valuelist[n4 + n3]) * ((double)fArray[n8] - (double)(this.valuelist[n5 + n3] + this.valuelist[n4 + n3]) * 0.5));
                    ++n3;
                    n8 += n2;
                }
            } while ((n7 = (double)f2 > 0.0 ? -encodeAuxNearestMatch.ptr0[n7] : -encodeAuxNearestMatch.ptr1[n7]) > 0);
            return -n7;
        }
        n6 = -1;
        float f3 = 0.0f;
        n4 = 0;
        for (n3 = 0; n3 < this.entries; ++n3) {
            if (this.c.lengthlist[n3] > 0) {
                float f4 = CodeBook.dist(this.dim, this.valuelist, n4, fArray, n2);
                if (n6 == -1 || f4 < f3) {
                    f3 = f4;
                    n6 = n3;
                }
            }
            n4 += this.dim;
        }
        return n6;
    }

    int besterror(float[] fArray, int n2, int n3) {
        int n4 = this.best(fArray, n2);
        switch (n3) {
            case 0: {
                n3 = 0;
                int n5 = 0;
                while (n3 < this.dim) {
                    int n6 = n5;
                    fArray[n6] = fArray[n6] - this.valuelist[n4 * this.dim + n3];
                    ++n3;
                    n5 += n2;
                }
                break;
            }
            case 1: {
                n3 = 0;
                int n7 = 0;
                while (n3 < this.dim) {
                    float f2 = this.valuelist[n4 * this.dim + n3];
                    if (f2 == 0.0f) {
                        fArray[n7] = 0.0f;
                    } else {
                        int n8 = n7;
                        fArray[n8] = fArray[n8] / f2;
                    }
                    ++n3;
                    n7 += n2;
                }
                break;
            }
        }
        return n4;
    }

    void clear() {
    }

    private static float dist(int n2, float[] fArray, int n3, float[] fArray2, int n4) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f3 = fArray[n3 + i2] - fArray2[i2 * n4];
            f2 += f3 * f3;
        }
        return f2;
    }

    int init_decode(StaticCodeBook staticCodeBook) {
        this.c = staticCodeBook;
        this.entries = staticCodeBook.entries;
        this.dim = staticCodeBook.dim;
        this.valuelist = staticCodeBook.unquantize();
        this.decode_tree = this.make_decode_tree();
        if (this.decode_tree == null) {
            this.clear();
            return -1;
        }
        return 0;
    }

    static int[] make_words(int[] nArray, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray2 = new int[33];
        int[] nArray3 = new int[n2];
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = nArray[n5];
            if (n4 <= 0) continue;
            n3 = nArray2[n4];
            if (n4 < 32 && n3 >>> n4 != 0) {
                return null;
            }
            nArray3[n5] = n3;
            int n6 = n4;
            while (n6 > 0) {
                if ((nArray2[n6] & 1) != 0) {
                    if (n6 == 1) {
                        nArray2[1] = nArray2[1] + 1;
                        break;
                    }
                    nArray2[n6] = nArray2[n6 - 1] << 1;
                    break;
                }
                int n7 = n6--;
                nArray2[n7] = nArray2[n7] + 1;
            }
            for (n6 = n4 + 1; n6 < 33 && nArray2[n6] >>> 1 == n3; ++n6) {
                n3 = nArray2[n6];
                nArray2[n6] = nArray2[n6 - 1] << 1;
            }
        }
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < nArray[n5]; ++n3) {
                n4 = n4 << 1 | nArray3[n5] >>> n3 & 1;
            }
            nArray3[n5] = n4;
        }
        return nArray3;
    }

    DecodeAux make_decode_tree() {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        DecodeAux decodeAux = new DecodeAux();
        new DecodeAux().ptr0 = new int[this.entries << 1];
        int[] nArray = new DecodeAux().ptr0;
        decodeAux.ptr1 = new int[this.entries << 1];
        int[] nArray2 = decodeAux.ptr1;
        int[] nArray3 = CodeBook.make_words(this.c.lengthlist, this.c.entries);
        if (nArray3 == null) {
            return null;
        }
        decodeAux.aux = this.entries << 1;
        for (n4 = 0; n4 < this.entries; ++n4) {
            if (this.c.lengthlist[n4] <= 0) continue;
            n3 = 0;
            for (n2 = 0; n2 < this.c.lengthlist[n4] - 1; ++n2) {
                if ((nArray3[n4] >>> n2 & 1) == 0) {
                    if (nArray[n3] == 0) {
                        nArray[n3] = ++n5;
                    }
                    n3 = nArray[n3];
                    continue;
                }
                if (nArray2[n3] == 0) {
                    nArray2[n3] = ++n5;
                }
                n3 = nArray2[n3];
            }
            if ((nArray3[n4] >>> n2 & 1) == 0) {
                nArray[n3] = -n4;
                continue;
            }
            nArray2[n3] = -n4;
        }
        decodeAux.tabn = CodeBook.ilog(this.entries) - 4;
        if (decodeAux.tabn < 5) {
            decodeAux.tabn = 5;
        }
        n4 = 1 << decodeAux.tabn;
        decodeAux.tab = new int[n4];
        decodeAux.tabl = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 0;
            for (n5 = 0; n5 < decodeAux.tabn && (n2 > 0 || n5 == 0); ++n5) {
                n2 = (n3 & 1 << n5) != 0 ? nArray2[n2] : nArray[n2];
            }
            decodeAux.tab[n3] = n2;
            decodeAux.tabl[n3] = n5;
        }
        return decodeAux;
    }

    private static int ilog(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }
}

