/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, 2008-2009-2010

*/

varying vec2 coord;

uniform sampler2D spotCircleRandom2DTexture;

uniform float spotCircleTimer;
uniform float spotCircleTransparency;
uniform bool spotCircleOldLCDStyleTransparency;

uniform float spotCircleCenterX;
uniform float spotCircleCenterY;
uniform float spotCircleRadius;
uniform float spotCirclePreCalcAlphaValues;
uniform bool spotCircleWithNoiseEffect;

const vec4 OUTER_SPOT_CIRCLE_COLOR = vec4(0.0);

void applyOldStyleTransparency();

#if USE_SPOT_CIRCLE_RANDOM_2D_TEXTURE_CONDITION
#else
    float rand(vec2 vector);

    float rand(vec2 vector)
    {
        return fract( 43758.5453 * sin( dot(vector, vec2(12.9898, 78.233) ) ) );
    }
#endif

void main()
{
    if (spotCircleOldLCDStyleTransparency)
        applyOldStyleTransparency();

    float spotCircleDistance = distance(vec2(spotCircleCenterX, spotCircleCenterY), coord.xy);

    // using integer number checks for the anti-alias effect!
    int spotCircleDistanceInteger = int(spotCircleDistance);
    int spotCircleRadiusInteger = int(spotCircleRadius);
    if (spotCircleDistanceInteger < spotCircleRadiusInteger)
    {
        if (spotCircleWithNoiseEffect)
        {
            #if USE_SPOT_CIRCLE_RANDOM_2D_TEXTURE_CONDITION
                vec4 allRandomColors = texture2D( spotCircleRandom2DTexture, vec2( fract( gl_TexCoord[0].st + fract(spotCircleTimer) ) ) );
            #else                                  
                vec4 allRandomColors = vec4( vec2( rand( vec2( fract( gl_TexCoord[0].st + fract(spotCircleTimer * 0.13 ) ) ) ) ),
                                             vec2( rand( vec2( fract( gl_TexCoord[0].st + fract(spotCircleTimer * 0.83 ) ) ) ) ) );
            #endif
            vec3 randomColor = vec3( (allRandomColors.r + allRandomColors.g + allRandomColors.b + allRandomColors.a) / 4.0 );
            gl_FragColor = vec4(randomColor, spotCircleTransparency * spotCirclePreCalcAlphaValues);
        }
        else
            gl_FragColor = OUTER_SPOT_CIRCLE_COLOR;
    }
    else if (spotCircleDistanceInteger > spotCircleRadiusInteger)
        gl_FragColor = vec4(OUTER_SPOT_CIRCLE_COLOR.xyz, spotCircleTransparency);
    else // if (distanceInteger == spotCircleRadiusInteger) // for the anti-alias effect!
        gl_FragColor = vec4( OUTER_SPOT_CIRCLE_COLOR.xyz, spotCircleTransparency * fract(spotCircleDistance) );
}
