/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.mixer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.mixer.TLine;

public abstract class TMixer
extends TLine
implements Mixer {
    private static Line.Info[] EMPTY_LINE_INFO_ARRAY = new Line.Info[0];
    private static Line[] EMPTY_LINE_ARRAY = new Line[0];
    private Mixer.Info m_mixerInfo;
    private Collection m_supportedSourceFormats;
    private Collection m_supportedTargetFormats;
    private Collection m_supportedSourceLineInfos;
    private Collection m_supportedTargetLineInfos;
    private Set m_openSourceDataLines;
    private Set m_openTargetDataLines;

    protected TMixer(Mixer.Info info, Line.Info info2) {
        this(info, info2, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    }

    protected TMixer(Mixer.Info info, Line.Info info2, Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        super(null, info2);
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.<init>(): begin");
        }
        this.m_mixerInfo = info;
        this.setSupportInformation(collection, collection2, collection3, collection4);
        this.m_openSourceDataLines = new ArraySet();
        this.m_openTargetDataLines = new ArraySet();
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.<init>(): end");
        }
    }

    protected void setSupportInformation(Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.setSupportInformation(): begin");
        }
        this.m_supportedSourceFormats = collection;
        this.m_supportedTargetFormats = collection2;
        this.m_supportedSourceLineInfos = collection3;
        this.m_supportedTargetLineInfos = collection4;
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.setSupportInformation(): end");
        }
    }

    @Override
    public Mixer.Info getMixerInfo() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getMixerInfo(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getMixerInfo(): end");
        }
        return this.m_mixerInfo;
    }

    @Override
    public Line.Info[] getSourceLineInfo() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceLineInfo(): begin");
        }
        Line.Info[] infoArray = this.m_supportedSourceLineInfos.toArray(EMPTY_LINE_INFO_ARRAY);
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceLineInfo(): end");
        }
        return infoArray;
    }

    @Override
    public Line.Info[] getTargetLineInfo() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetLineInfo(): begin");
        }
        Line.Info[] infoArray = this.m_supportedTargetLineInfos.toArray(EMPTY_LINE_INFO_ARRAY);
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetLineInfo(): end");
        }
        return infoArray;
    }

    @Override
    public Line.Info[] getSourceLineInfo(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceLineInfo(Line.Info): info to test: " + info);
        }
        return EMPTY_LINE_INFO_ARRAY;
    }

    @Override
    public Line.Info[] getTargetLineInfo(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetLineInfo(Line.Info): info to test: " + info);
        }
        return EMPTY_LINE_INFO_ARRAY;
    }

    @Override
    public boolean isLineSupported(Line.Info info) {
        Class<?> clazz;
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.isLineSupported(): info to test: " + info);
        }
        if ((clazz = info.getLineClass()).equals(SourceDataLine.class)) {
            return TMixer.isLineSupportedImpl(info, this.m_supportedSourceLineInfos);
        }
        if (clazz.equals(TargetDataLine.class)) {
            return TMixer.isLineSupportedImpl(info, this.m_supportedTargetLineInfos);
        }
        if (clazz.equals(Port.class)) {
            return TMixer.isLineSupportedImpl(info, this.m_supportedSourceLineInfos) || TMixer.isLineSupportedImpl(info, this.m_supportedTargetLineInfos);
        }
        return false;
    }

    private static boolean isLineSupportedImpl(Line.Info info, Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!((Line.Info)object.next()).matches(info)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Line getLine(Line.Info object) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getLine(): begin");
        }
        Class<?> clazz = ((Line.Info)object).getLineClass();
        DataLine.Info info = null;
        Port.Info info2 = null;
        AudioFormat[] audioFormatArray = null;
        if (object instanceof DataLine.Info) {
            info = (DataLine.Info)object;
            audioFormatArray = info.getFormats();
        } else if (object instanceof Port.Info) {
            info2 = (Port.Info)object;
        }
        if (clazz == SourceDataLine.class) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): type: SourceDataLine");
            }
            if (info == null) {
                throw new IllegalArgumentException("need DataLine.Info for SourceDataLine");
            }
            object = this.getSupportedSourceFormat(audioFormatArray);
            object = this.getSourceDataLine((AudioFormat)object, info.getMaxBufferSize());
        } else if (clazz == Clip.class) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): type: Clip");
            }
            if (info == null) {
                throw new IllegalArgumentException("need DataLine.Info for Clip");
            }
            object = this.getSupportedSourceFormat(audioFormatArray);
            object = this.getClip((AudioFormat)object);
        } else if (clazz == TargetDataLine.class) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): type: TargetDataLine");
            }
            if (info == null) {
                throw new IllegalArgumentException("need DataLine.Info for TargetDataLine");
            }
            object = this.getSupportedTargetFormat(audioFormatArray);
            object = this.getTargetDataLine((AudioFormat)object, info.getMaxBufferSize());
        } else if (clazz == Port.class) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): type: TargetDataLine");
            }
            if (info2 == null) {
                throw new IllegalArgumentException("need Port.Info for Port");
            }
            object = this.getPort(info2);
        } else {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getLine(): unknown line type, will throw exception");
            }
            throw new LineUnavailableException("unknown line class: " + clazz);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getLine(): end");
        }
        return object;
    }

    protected SourceDataLine getSourceDataLine(AudioFormat audioFormat, int n2) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceDataLine(): begin");
        }
        throw new IllegalArgumentException("this mixer does not support SourceDataLines");
    }

    protected Clip getClip(AudioFormat audioFormat) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getClip(): begin");
        }
        throw new IllegalArgumentException("this mixer does not support Clips");
    }

    protected TargetDataLine getTargetDataLine(AudioFormat audioFormat, int n2) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetDataLine(): begin");
        }
        throw new IllegalArgumentException("this mixer does not support TargetDataLines");
    }

    protected Port getPort(Port.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetDataLine(): begin");
        }
        throw new IllegalArgumentException("this mixer does not support Ports");
    }

    private AudioFormat getSupportedSourceFormat(AudioFormat[] audioFormatArray) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSupportedSourceFormat(): begin");
        }
        AudioFormat audioFormat = null;
        for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getSupportedSourceFormat(): checking " + audioFormatArray[i2] + "...");
            }
            if (this.isSourceFormatSupported(audioFormatArray[i2])) {
                if (TDebug.TraceMixer) {
                    TDebug.out("TMixer.getSupportedSourceFormat(): ...supported");
                }
                audioFormat = audioFormatArray[i2];
                break;
            }
            if (!TDebug.TraceMixer) continue;
            TDebug.out("TMixer.getSupportedSourceFormat(): ...no luck");
        }
        if (audioFormat == null) {
            throw new IllegalArgumentException("no line matchine one of the passed formats");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSupportedSourceFormat(): end");
        }
        return audioFormat;
    }

    private AudioFormat getSupportedTargetFormat(AudioFormat[] audioFormatArray) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSupportedTargetFormat(): begin");
        }
        AudioFormat audioFormat = null;
        for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
            if (TDebug.TraceMixer) {
                TDebug.out("TMixer.getSupportedTargetFormat(): checking " + audioFormatArray[i2] + " ...");
            }
            if (this.isTargetFormatSupported(audioFormatArray[i2])) {
                if (TDebug.TraceMixer) {
                    TDebug.out("TMixer.getSupportedTargetFormat(): ...supported");
                }
                audioFormat = audioFormatArray[i2];
                break;
            }
            if (!TDebug.TraceMixer) continue;
            TDebug.out("TMixer.getSupportedTargetFormat(): ...no luck");
        }
        if (audioFormat == null) {
            throw new IllegalArgumentException("no line matchine one of the passed formats");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSupportedTargetFormat(): end");
        }
        return audioFormat;
    }

    @Override
    public Line[] getSourceLines() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getSourceLines(): called");
        }
        return this.m_openSourceDataLines.toArray(EMPTY_LINE_ARRAY);
    }

    @Override
    public Line[] getTargetLines() {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.getTargetLines(): called");
        }
        return this.m_openTargetDataLines.toArray(EMPTY_LINE_ARRAY);
    }

    @Override
    public void synchronize(Line[] lineArray, boolean bl) {
        throw new IllegalArgumentException("synchronization not supported");
    }

    @Override
    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("synchronization not supported");
    }

    @Override
    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl) {
        return false;
    }

    protected boolean isSourceFormatSupported(AudioFormat audioFormat) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.isSourceFormatSupported(): format to test: " + audioFormat);
        }
        Iterator iterator = this.m_supportedSourceFormats.iterator();
        while (iterator.hasNext()) {
            if (!AudioFormats.matches((AudioFormat)iterator.next(), audioFormat)) continue;
            return true;
        }
        return false;
    }

    protected boolean isTargetFormatSupported(AudioFormat audioFormat) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.isTargetFormatSupported(): format to test: " + audioFormat);
        }
        Iterator iterator = this.m_supportedTargetFormats.iterator();
        while (iterator.hasNext()) {
            if (!AudioFormats.matches((AudioFormat)iterator.next(), audioFormat)) continue;
            return true;
        }
        return false;
    }

    void registerOpenLine(Line line) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.registerOpenLine(): line to register: " + line);
        }
        if (line instanceof SourceDataLine) {
            Set set = this.m_openSourceDataLines;
            synchronized (set) {
                this.m_openSourceDataLines.add((SourceDataLine)line);
                return;
            }
        }
        if (line instanceof TargetDataLine) {
            Set set = this.m_openSourceDataLines;
            synchronized (set) {
                this.m_openTargetDataLines.add((TargetDataLine)line);
                return;
            }
        }
    }

    void unregisterOpenLine(Line line) {
        if (TDebug.TraceMixer) {
            TDebug.out("TMixer.unregisterOpenLine(): line to unregister: " + line);
        }
        if (line instanceof SourceDataLine) {
            Set set = this.m_openSourceDataLines;
            synchronized (set) {
                this.m_openSourceDataLines.remove((SourceDataLine)line);
                return;
            }
        }
        if (line instanceof TargetDataLine) {
            Set set = this.m_openTargetDataLines;
            synchronized (set) {
                this.m_openTargetDataLines.remove((TargetDataLine)line);
                return;
            }
        }
    }
}

