/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;

public abstract class TFormatConversionProvider
extends FormatConversionProvider {
    protected static final AudioFormat.Encoding[] EMPTY_ENCODING_ARRAY = new AudioFormat.Encoding[0];
    protected static final AudioFormat[] EMPTY_FORMAT_ARRAY = new AudioFormat[0];

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding object, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        object = new AudioFormat((AudioFormat.Encoding)object, -1.0f, -1, -1, -1, -1.0f, audioFormat.isBigEndian());
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TFormatConversionProvider.getAudioInputStream(AudioFormat.Encoding, AudioInputStream):");
            TDebug.out("trying to convert to " + object);
        }
        return this.getAudioInputStream((AudioFormat)object, audioInputStream);
    }

    @Override
    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormatArray) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">TFormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("class: " + this.getClass().getName());
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + audioFormatArray);
            TDebug.out("to: " + audioFormat);
        }
        audioFormatArray = this.getTargetFormats(audioFormat.getEncoding(), (AudioFormat)audioFormatArray);
        for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("checking against possible target format: " + audioFormatArray[i2]);
            }
            if (audioFormatArray[i2] == null || !AudioFormats.matches(audioFormatArray[i2], audioFormat)) continue;
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<result=true");
            }
            return true;
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<result=false");
        }
        return false;
    }

    public AudioFormat getMatchingFormat(AudioFormat audioFormat, AudioFormat audioFormatArray) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">TFormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("class: " + this.getClass().getName());
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + audioFormatArray);
            TDebug.out("to: " + audioFormat);
        }
        audioFormatArray = this.getTargetFormats(audioFormat.getEncoding(), (AudioFormat)audioFormatArray);
        for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("checking against possible target format: " + audioFormatArray[i2]);
            }
            if (audioFormatArray[i2] == null || !AudioFormats.matches(audioFormatArray[i2], audioFormat)) continue;
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<result=true");
            }
            return audioFormatArray[i2];
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<result=false");
        }
        return null;
    }
}

