/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tritonus.share.TDebug;

public class MidiUtils {
    public static int getUnsignedInteger(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    public static int get14bitValue(int n2, int n3) {
        return n2 & 0x7F | (n3 & 0x7F) << 7;
    }

    public static int get14bitMSB(int n2) {
        return n2 >> 7 & 0x7F;
    }

    public static int get14bitLSB(int n2) {
        return n2 & 0x7F;
    }

    public static byte[] getVariableLengthQuantity(long l2) {
        ByteArrayOutputStream byteArrayOutputStream;
        block2: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                MidiUtils.writeVariableLengthQuantity(l2, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int writeVariableLengthQuantity(long l2, OutputStream outputStream) {
        int n2 = 0;
        boolean bl = false;
        int n3 = (int)(l2 >> 21 & 0x7FL);
        if (n3 != 0) {
            if (outputStream != null) {
                outputStream.write(n3 | 0x80);
            }
            ++n2;
            bl = true;
        }
        if ((n3 = (int)(l2 >> 14 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n3 | 0x80);
            }
            ++n2;
            bl = true;
        }
        if ((n3 = (int)(l2 >> 7 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n3 | 0x80);
            }
            ++n2;
        }
        n3 = (int)(l2 & 0x7FL);
        if (outputStream != null) {
            outputStream.write(n3);
        }
        return ++n2;
    }
}

