/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class JorbisAudioFileReader
extends TAudioFileReader {
    private static final int INITAL_READ_LENGTH = 4096;
    private static final int MARK_LIMIT = 4097;

    public JorbisAudioFileReader() {
        super(4097, true);
    }

    @Override
    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long l2) {
        SyncState syncState = new SyncState();
        Object object = new StreamState();
        Object object2 = new Page();
        Packet packet = new Packet();
        syncState.init();
        int n2 = syncState.buffer(4096);
        int n3 = inputStream.read(syncState.data, n2, 4096);
        syncState.wrote(n3);
        if (syncState.pageout((Page)object2) != 1) {
            if (n3 < 4096) {
                throw new UnsupportedAudioFileException("not a Vorbis stream: ended prematurely");
            }
            throw new UnsupportedAudioFileException("not a Vorbis stream: not in Ogg bitstream format");
        }
        ((StreamState)object).init(((Page)object2).serialno());
        if (((StreamState)object).pagein((Page)object2) < 0) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: can't read first page of Ogg bitstream data");
        }
        if (((StreamState)object).packetout(packet) != 1) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: can't read initial header packet");
        }
        Buffer buffer = new Buffer();
        buffer.readinit(packet.packet_base, packet.packet, packet.bytes);
        int n4 = buffer.read(8);
        object = new byte[6];
        buffer.read((byte[])object, 6);
        if (object[0] != 118 || object[1] != 111 || object[2] != 114 || object[3] != 98 || object[4] != 105 || object[5] != 115) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: not a vorbis header packet");
        }
        if (n4 != 1) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: first packet is not the identification header");
        }
        if (packet.b_o_s == 0) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: initial packet not marked as beginning of stream");
        }
        if (buffer.read(32) != 0) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: wrong vorbis version");
        }
        n4 = buffer.read(8);
        float f2 = buffer.read(32);
        buffer.read(32);
        buffer.read(32);
        buffer.read(32);
        int[] nArray = new int[2];
        object2 = nArray;
        nArray[0] = 1 << buffer.read(4);
        object2[1] = 1 << buffer.read(4);
        if (f2 < 1.0f || n4 <= 0 || object2[0] < 8 || object2[1] < object2[0] || buffer.read(1) != 1) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: illegal values in initial header");
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("JorbisAudioFileReader.getAudioFileFormat(): channels: " + n4);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("JorbisAudioFileReader.getAudioFileFormat(): rate: " + f2);
        }
        int n5 = -1;
        if (l2 != -1L && l2 <= Integer.MAX_VALUE) {
            n5 = (int)l2;
        }
        AudioFormat audioFormat = new AudioFormat(new AudioFormat.Encoding("VORBIS"), f2, -1, n4, -1, -1.0f, true);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("JorbisAudioFileReader.getAudioFileFormat(): AudioFormat: " + audioFormat);
        }
        AudioFileFormat.Type type = new AudioFileFormat.Type("Ogg", "ogg");
        TAudioFileFormat tAudioFileFormat = new TAudioFileFormat(type, audioFormat, -1, n5);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("JorbisAudioFileReader.getAudioFileFormat(): AudioFileFormat: " + tAudioFileFormat);
        }
        return tAudioFileFormat;
    }
}

