/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.jorbis;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;

public class JorbisFormatConversionProvider$DecodedJorbisAudioInputStream
extends TAsynchronousFilteredAudioInputStream {
    private static final int BUFFER_MULTIPLE = 4;
    private static final int BUFFER_SIZE = 2048;
    private static final int CONVSIZE = 4096;
    private InputStream m_oggBitStream = null;
    private SyncState m_oggSyncState = null;
    private StreamState m_oggStreamState = null;
    private Page m_oggPage = null;
    private Packet m_oggPacket = null;
    private Info m_vorbisInfo = null;
    private Comment m_vorbisComment = null;
    private DspState m_vorbisDspState = null;
    private Block m_vorbisBlock = null;
    private List m_songComments = new ArrayList();
    private int convsize = -1;
    private byte[] convbuffer = new byte[4096];
    private float[][][] _pcmf = null;
    private int[] _index = null;
    private boolean m_bHeadersExpected;

    public JorbisFormatConversionProvider$DecodedJorbisAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        super(audioFormat, -1L);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("DecodedJorbisAudioInputStream.<init>(): begin");
        }
        this.m_oggBitStream = audioInputStream;
        this.m_bHeadersExpected = true;
        this.init_jorbis();
        if (TDebug.TraceAudioConverter) {
            TDebug.out("DecodedJorbisAudioInputStream.<init>(): end");
        }
    }

    private void init_jorbis() {
        this.m_oggSyncState = new SyncState();
        this.m_oggStreamState = new StreamState();
        this.m_oggPage = new Page();
        this.m_oggPacket = new Packet();
        this.m_vorbisInfo = new Info();
        this.m_vorbisComment = new Comment();
        this.m_vorbisDspState = new DspState();
        this.m_vorbisBlock = new Block(this.m_vorbisDspState);
        this.m_oggSyncState.init();
    }

    @Override
    public void execute() {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">DecodedJorbisAudioInputStream.execute(): begin");
        }
        if (this.m_bHeadersExpected) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("reading headers...");
            }
            try {
                this.readHeaders();
            }
            catch (IOException iOException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(iOException);
                }
                this.closePhysicalStream();
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("<DecodedJorbisAudioInputStream.execute(): end");
                }
                return;
            }
            this.m_bHeadersExpected = false;
            this.setupVorbisStructures();
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("decoding...");
        }
        while (this.writeMore()) {
            try {
                this.readOggPacket();
            }
            catch (IOException iOException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(iOException);
                }
                this.closePhysicalStream();
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("<DecodedJorbisAudioInputStream.execute(): end");
                }
                return;
            }
            this.decodeDataPacket();
        }
        if (this.m_oggPacket.e_o_s != 0) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("end of vorbis stream reached");
            }
            this.shutDownLogicalStream();
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<DecodedJorbisAudioInputStream.execute(): end");
        }
    }

    private void shutDownLogicalStream() {
        this.m_oggStreamState.clear();
        this.m_vorbisBlock.clear();
        this.m_vorbisDspState.clear();
        this.m_vorbisInfo.clear();
        this.m_bHeadersExpected = true;
    }

    private void closePhysicalStream() {
        block5: {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedJorbisAudioInputStream.closePhysicalStream(): begin");
            }
            this.m_oggSyncState.clear();
            try {
                if (this.m_oggBitStream != null) {
                    this.m_oggBitStream.close();
                }
                this.getCircularBuffer().close();
            }
            catch (Exception exception) {
                if (!TDebug.TraceAllExceptions) break block5;
                TDebug.out(exception);
            }
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("DecodedJorbisAudioInputStream.closePhysicalStream(): end");
        }
    }

    private void readHeaders() {
        this.readIdentificationHeader();
        this.readCommentAndCodebookHeaders();
        this.processComments();
    }

    private void readIdentificationHeader() {
        this.readOggPage();
        this.m_oggStreamState.init(this.m_oggPage.serialno());
        this.m_vorbisInfo.init();
        this.m_vorbisComment.init();
        if (this.m_oggStreamState.pagein(this.m_oggPage) < 0) {
            throw new IOException("can't read first page of Ogg bitstream data, perhaps stream version mismatch");
        }
        if (this.m_oggStreamState.packetout(this.m_oggPacket) != 1) {
            throw new IOException("can't read initial header packet");
        }
        if (this.m_vorbisInfo.synthesis_headerin(this.m_vorbisComment, this.m_oggPacket) < 0) {
            throw new IOException("packet is not a vorbis header");
        }
    }

    private void readCommentAndCodebookHeaders() {
        for (int i2 = 0; i2 < 2; ++i2) {
            this.readOggPacket();
            if (this.m_vorbisInfo.synthesis_headerin(this.m_vorbisComment, this.m_oggPacket) >= 0) continue;
            throw new IOException("packet is not a vorbis header");
        }
    }

    private void processComments() {
        String string;
        byte[][] byArray = this.m_vorbisComment.user_comments;
        this.m_songComments.clear();
        for (int i2 = 0; i2 < byArray.length && byArray[i2] != null; ++i2) {
            string = new String(byArray[i2], 0, byArray[i2].length - 1).trim();
            this.m_songComments.add(string);
            if (!TDebug.TraceAudioConverter) continue;
            TDebug.out("Comment: " + string);
        }
        string = "Bitstream: " + this.m_vorbisInfo.channels + " channel," + this.m_vorbisInfo.rate + "Hz";
        this.m_songComments.add(string);
        if (TDebug.TraceAudioConverter) {
            TDebug.out(string);
        }
        if (TDebug.TraceAudioConverter) {
            string = "Encoded by: " + new String(this.m_vorbisComment.vendor, 0, this.m_vorbisComment.vendor.length - 1);
        }
        this.m_songComments.add(string);
        if (TDebug.TraceAudioConverter) {
            TDebug.out(string);
        }
    }

    private void setupVorbisStructures() {
        this.convsize = 2048 / this.m_vorbisInfo.channels;
        this.m_vorbisDspState.synthesis_init(this.m_vorbisInfo);
        this.m_vorbisBlock.init(this.m_vorbisDspState);
        this._pcmf = new float[1][][];
        this._index = new int[this.m_vorbisInfo.channels];
    }

    private void decodeDataPacket() {
        int n2;
        if (this.m_vorbisBlock.synthesis(this.m_oggPacket) == 0) {
            this.m_vorbisDspState.synthesis_blockin(this.m_vorbisBlock);
        }
        while ((n2 = this.m_vorbisDspState.synthesis_pcmout(this._pcmf, this._index)) > 0) {
            float[][] fArray = this._pcmf[0];
            n2 = n2 < this.convsize ? n2 : this.convsize;
            for (int i2 = 0; i2 < this.m_vorbisInfo.channels; ++i2) {
                int n3 = i2 * this.getSampleSizeInBytes();
                int n4 = this._index[i2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    float f2 = fArray[i2][n4 + i3];
                    this.clipAndWriteSample(f2, n3);
                    n3 += this.getFrameSize();
                }
            }
            this.m_vorbisDspState.synthesis_read(n2);
            this.getCircularBuffer().write(this.convbuffer, 0, this.getFrameSize() * n2);
        }
    }

    private void clipAndWriteSample(float f2, int n2) {
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f2 < -1.0f) {
            f2 = -1.0f;
        }
        switch (this.getFormat().getSampleSizeInBits()) {
            case 16: {
                int n3 = (int)(f2 * 32767.0f);
                if (this.isBigEndian()) {
                    this.convbuffer[n2++] = (byte)(n3 >> 8);
                    this.convbuffer[n2] = (byte)n3;
                    return;
                }
                this.convbuffer[n2++] = (byte)n3;
                this.convbuffer[n2] = (byte)(n3 >> 8);
                return;
            }
            case 24: {
                int n4 = (int)(f2 * 8388607.0f);
                if (this.isBigEndian()) {
                    this.convbuffer[n2++] = (byte)(n4 >> 16);
                    this.convbuffer[n2++] = (byte)(n4 >>> 8);
                    this.convbuffer[n2] = (byte)n4;
                    return;
                }
                this.convbuffer[n2++] = (byte)n4;
                this.convbuffer[n2++] = (byte)(n4 >>> 8);
                this.convbuffer[n2] = (byte)(n4 >> 16);
                return;
            }
            case 32: {
                int n5 = (int)(f2 * 2.1474836E9f);
                if (this.isBigEndian()) {
                    this.convbuffer[n2++] = n5 >> 24;
                    this.convbuffer[n2++] = (byte)(n5 >>> 16);
                    this.convbuffer[n2++] = (byte)(n5 >>> 8);
                    this.convbuffer[n2] = (byte)n5;
                    return;
                }
                this.convbuffer[n2++] = (byte)n5;
                this.convbuffer[n2++] = (byte)(n5 >>> 8);
                this.convbuffer[n2++] = (byte)(n5 >>> 16);
                this.convbuffer[n2] = n5 >> 24;
            }
        }
    }

    private void readOggPacket() {
        do {
            int n2;
            if ((n2 = this.m_oggStreamState.packetout(this.m_oggPacket)) == 1) {
                return;
            }
            if (n2 == -1) {
                throw new IOException("can't read packet");
            }
            this.readOggPage();
        } while (this.m_oggStreamState.pagein(this.m_oggPage) >= 0);
        throw new IOException("can't read page of Ogg bitstream data");
    }

    private void readOggPage() {
        while (this.m_oggSyncState.pageout(this.m_oggPage) != 1) {
            int n2 = this.m_oggSyncState.buffer(2048);
            if ((n2 = this.readFromStream(this.m_oggSyncState.data, n2, 2048)) == -1) {
                throw new EOFException();
            }
            this.m_oggSyncState.wrote(n2);
        }
        return;
    }

    private int readFromStream(byte[] byArray, int n2, int n3) {
        return this.m_oggBitStream.read(byArray, n2, n3);
    }

    private int getSampleSizeInBytes() {
        return this.getFormat().getFrameSize() / this.getFormat().getChannels();
    }

    private int getFrameSize() {
        return this.getFormat().getFrameSize();
    }

    private boolean isBigEndian() {
        return this.getFormat().isBigEndian();
    }

    @Override
    public void close() {
        super.close();
        this.m_oggBitStream.close();
    }
}

