/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableHelper;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.Java2D;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.Beans;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLJPanel$1;
import javax.media.opengl.GLJPanel$2;
import javax.media.opengl.GLJPanel$3;
import javax.media.opengl.GLJPanel$DisplayAction;
import javax.media.opengl.GLJPanel$InitAction;
import javax.media.opengl.GLJPanel$PaintImmediatelyAction;
import javax.media.opengl.GLJPanel$SwapBuffersAction;
import javax.media.opengl.GLJPanel$Updater;
import javax.media.opengl.GLPbuffer;
import javax.swing.JPanel;

public class GLJPanel
extends JPanel
implements GLAutoDrawable {
    private static final boolean DEBUG = Debug.debug("GLJPanel");
    private static final boolean VERBOSE = Debug.verbose();
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private volatile boolean isInitialized;
    private volatile boolean shouldInitialize = false;
    private GLCapabilities offscreenCaps;
    private GLCapabilitiesChooser chooser;
    private GLContext shareWith;
    private BufferedImage offscreenImage;
    private ByteBuffer readBackBytes;
    private IntBuffer readBackInts;
    private int readBackWidthInPixels;
    private int readBackHeightInPixels;
    private int panelWidth = 0;
    private int panelHeight = 0;
    private GLJPanel$Updater updater;
    private int awtFormat;
    private int glFormat;
    private int glType;
    private boolean handleReshape = false;
    private boolean sendReshape = true;
    private static boolean hardwareAccelerationDisabled = Debug.isPropertyDefined("jogl.gljpanel.nohw");
    private static boolean softwareRenderingDisabled = Debug.isPropertyDefined("jogl.gljpanel.nosw");
    private GLPbuffer pbuffer;
    private int pbufferWidth = 256;
    private int pbufferHeight = 256;
    private GLDrawableImpl offscreenDrawable;
    private GLContextImpl offscreenContext;
    private int reshapeX;
    private int reshapeY;
    private int reshapeWidth;
    private int reshapeHeight;
    private int[] swapbytes = new int[1];
    private int[] rowlength = new int[1];
    private int[] skiprows = new int[1];
    private int[] skippixels = new int[1];
    private int[] alignment = new int[1];
    private boolean oglPipelineEnabled = Java2D.isOGLPipelineActive() && !Debug.isPropertyDefined("jogl.gljpanel.noogl");
    private Object j2dSurface;
    private Graphics cached2DGraphics;
    private GLContext j2dContext;
    private GLDrawable joglDrawable;
    private GLContext joglContext;
    private int[] drawBuffer = new int[1];
    private int[] readBuffer = new int[1];
    private int[] frameBuffer = new int[1];
    private boolean checkedForFBObjectWorkarounds;
    private boolean fbObjectWorkarounds;
    private int[] frameBufferDepthBuffer;
    private int[] frameBufferTexture;
    private boolean createNewDepthBuffer;
    private boolean checkedGLVendor;
    private boolean vendorIsATI;
    private GraphicsConfiguration workaroundConfig;
    private int viewportX;
    private int viewportY;
    private GLJPanel$InitAction initAction = new GLJPanel$InitAction(this);
    private GLJPanel$DisplayAction displayAction = new GLJPanel$DisplayAction(this);
    private GLJPanel$SwapBuffersAction swapBuffersAction = new GLJPanel$SwapBuffersAction(this);
    private GLJPanel$PaintImmediatelyAction paintImmediatelyAction = new GLJPanel$PaintImmediatelyAction(this);

    public GLJPanel() {
        this((GLCapabilities)null);
    }

    public GLJPanel(GLCapabilities gLCapabilities) {
        this(gLCapabilities, null, null);
    }

    public GLJPanel(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        this.offscreenCaps = gLCapabilities != null ? (GLCapabilities)gLCapabilities.clone() : new GLCapabilities();
        this.offscreenCaps.setDoubleBuffered(false);
        this.chooser = gLCapabilitiesChooser != null ? gLCapabilitiesChooser : new DefaultGLCapabilitiesChooser();
        this.shareWith = gLContext;
    }

    @Override
    public void display() {
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        try {
            EventQueue.invokeAndWait(this.paintImmediatelyAction);
            return;
        }
        catch (Exception exception) {
            throw new GLException(exception);
        }
    }

    private void captureJ2DState(GL gL, Graphics object) {
        gL.glGetIntegerv(3073, this.drawBuffer, 0);
        gL.glGetIntegerv(3074, this.readBuffer, 0);
        if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType((Graphics)object) == Java2D.FBOBJECT) {
            if (DEBUG && VERBOSE) {
                System.err.println("GLJPanel: Fetching GL_FRAMEBUFFER_BINDING_EXT");
            }
            gL.glGetIntegerv(36006, this.frameBuffer, 0);
            if (this.fbObjectWorkarounds || !this.checkedForFBObjectWorkarounds) {
                if (this.frameBufferTexture == null) {
                    this.frameBufferTexture = new int[1];
                }
                gL.glGetFramebufferAttachmentParameterivEXT(36160, 36064, 36049, this.frameBufferTexture, 0);
                if (DEBUG && VERBOSE) {
                    System.err.println("GLJPanel: FBO COLOR_ATTACHMENT0: " + this.frameBufferTexture[0]);
                }
            }
            if (!this.checkedGLVendor) {
                this.checkedGLVendor = true;
                object = gL.glGetString(7936);
                if (object != null && ((String)object).startsWith("ATI")) {
                    this.vendorIsATI = true;
                }
            }
            if (this.vendorIsATI) {
                gL.glBindFramebufferEXT(36160, 0);
            }
        }
    }

    private boolean preGL(Graphics graphics) {
        GL gL = this.joglContext.getGL();
        gL.glEnable(3089);
        Object object = Java2D.getOGLScissorBox(graphics);
        if (object == null) {
            if (DEBUG && VERBOSE) {
                System.err.println("Java2D.getOGLScissorBox() returned null");
            }
            return false;
        }
        if (DEBUG && VERBOSE) {
            System.err.println("GLJPanel: gl.glScissor(" + ((Rectangle)object).x + ", " + ((Rectangle)object).y + ", " + ((Rectangle)object).width + ", " + ((Rectangle)object).height + ")");
        }
        gL.glScissor(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        object = Java2D.getOGLViewport(graphics, this.panelWidth, this.panelHeight);
        if (this.viewportX != ((Rectangle)object).x || this.viewportY != ((Rectangle)object).y) {
            this.sendReshape = true;
            if (DEBUG) {
                System.err.println("Sending reshape because viewport changed");
                System.err.println("  viewportX (" + this.viewportX + ") ?= oglViewport.x (" + ((Rectangle)object).x + ")");
                System.err.println("  viewportY (" + this.viewportY + ") ?= oglViewport.y (" + ((Rectangle)object).y + ")");
            }
        }
        this.viewportX = ((Rectangle)object).x;
        this.viewportY = ((Rectangle)object).y;
        if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
            int n2;
            if (DEBUG && VERBOSE) {
                System.err.println("GLJPanel: Binding to framebuffer object " + this.frameBuffer[0]);
            }
            int n3 = Java2D.getOGLTextureType(graphics);
            if (!this.checkedForFBObjectWorkarounds) {
                this.checkedForFBObjectWorkarounds = true;
                gL.glBindTexture(n3, 0);
                gL.glBindFramebufferEXT(36160, this.frameBuffer[0]);
                if (gL.glCheckFramebufferStatusEXT(36160) != 36053) {
                    this.fbObjectWorkarounds = true;
                    this.createNewDepthBuffer = true;
                    if (DEBUG) {
                        System.err.println("-- GLJPanel: discovered frame_buffer_object workarounds to be necessary");
                    }
                } else {
                    this.frameBufferTexture = null;
                }
            }
            if (this.fbObjectWorkarounds && this.createNewDepthBuffer) {
                if (this.frameBufferDepthBuffer == null) {
                    this.frameBufferDepthBuffer = new int[1];
                }
                if (this.frameBufferDepthBuffer[0] != 0) {
                    gL.glDeleteRenderbuffersEXT(1, this.frameBufferDepthBuffer, 0);
                    this.frameBufferDepthBuffer[0] = 0;
                }
                gL.glBindTexture(n3, this.frameBufferTexture[0]);
                object = new int[1];
                int[] nArray = new int[1];
                gL.glGetTexLevelParameteriv(n3, 0, 4096, (int[])object, 0);
                gL.glGetTexLevelParameteriv(n3, 0, 4097, nArray, 0);
                gL.glGenRenderbuffersEXT(1, this.frameBufferDepthBuffer, 0);
                if (DEBUG) {
                    System.err.println("GLJPanel: Generated frameBufferDepthBuffer " + this.frameBufferDepthBuffer[0] + " with width " + (int)object[0] + ", height " + nArray[0]);
                }
                gL.glBindRenderbufferEXT(36161, this.frameBufferDepthBuffer[0]);
                gL.glRenderbufferStorageEXT(36161, 33190, (int)object[0], nArray[0]);
                gL.glBindRenderbufferEXT(36161, 0);
                this.createNewDepthBuffer = false;
            }
            gL.glBindTexture(n3, 0);
            gL.glBindFramebufferEXT(36160, this.frameBuffer[0]);
            if (this.fbObjectWorkarounds) {
                gL.glFramebufferTexture2DEXT(36160, 36064, n3, this.frameBufferTexture[0], 0);
                if (DEBUG && VERBOSE) {
                    System.err.println("GLJPanel: frameBufferDepthBuffer: " + this.frameBufferDepthBuffer[0]);
                }
                gL.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.frameBufferDepthBuffer[0]);
            }
            if (DEBUG && (n2 = gL.glCheckFramebufferStatusEXT(36160)) != 36053) {
                throw new GLException("Error: framebuffer was incomplete: status = 0x" + Integer.toHexString(n2));
            }
        } else {
            if (DEBUG && VERBOSE) {
                System.err.println("GLJPanel: Setting up drawBuffer " + this.drawBuffer[0] + " and readBuffer " + this.readBuffer[0]);
            }
            gL.glDrawBuffer(this.drawBuffer[0]);
            gL.glReadBuffer(this.readBuffer[0]);
        }
        return true;
    }

    private void postGL(Graphics graphics) {
        if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
            this.joglContext.getGL().glBindFramebufferEXT(36160, 0);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n2;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n2 = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n2 + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        if (this.shouldInitialize) {
            this.initialize();
        }
        if (!this.isInitialized) {
            return;
        }
        if (this.handleReshape) {
            this.handleReshape();
        }
        this.updater.setGraphics(graphics);
        if (this.oglPipelineEnabled) {
            if (Java2D.isFBOEnabled()) {
                if (this.workaroundConfig == null) {
                    this.workaroundConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                }
                Java2D.invokeWithOGLSharedContextCurrent(this.workaroundConfig, new GLJPanel$1(this));
            }
            Java2D.invokeWithOGLContextCurrent(graphics, new GLJPanel$2(this, graphics));
            return;
        }
        if (!hardwareAccelerationDisabled) {
            this.pbuffer.display();
        } else {
            this.drawableHelper.invokeGL(this.offscreenDrawable, this.offscreenContext, this.displayAction, this.initAction);
        }
        if (this.offscreenImage != null) {
            graphics.drawImage(this.offscreenImage, 0, 0, this.offscreenImage.getWidth(), this.offscreenImage.getHeight(), this);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.shouldInitialize = true;
        if (DEBUG) {
            System.err.println("GLJPanel.addNotify()");
        }
    }

    @Override
    public void removeNotify() {
        if (DEBUG) {
            System.err.println("GLJPanel.removeNotify()");
        }
        if (this.oglPipelineEnabled) {
            Java2D.invokeWithOGLContextCurrent(null, new GLJPanel$3(this));
        } else if (!hardwareAccelerationDisabled) {
            if (this.pbuffer != null) {
                this.pbuffer.destroy();
                this.pbuffer = null;
            }
        } else {
            if (this.offscreenContext != null) {
                this.offscreenContext.destroy();
                this.offscreenContext = null;
            }
            if (this.offscreenDrawable != null) {
                this.offscreenDrawable.destroy();
                this.offscreenDrawable = null;
            }
        }
        this.isInitialized = false;
        super.removeNotify();
    }

    @Override
    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, n5);
        this.reshapeX = n2;
        this.reshapeY = n3;
        this.reshapeWidth = n4;
        this.reshapeHeight = n5;
        this.handleReshape = true;
    }

    @Override
    public void setOpaque(boolean bl) {
        if (bl != this.isOpaque() && this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
        super.setOpaque(bl);
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        if (!hardwareAccelerationDisabled) {
            return this.pbuffer.createContext(gLContext);
        }
        return this.offscreenDrawable.createContext(gLContext);
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public GLContext getContext() {
        if (this.oglPipelineEnabled) {
            return this.joglContext;
        }
        if (!hardwareAccelerationDisabled) {
            if (this.pbuffer == null && Beans.isDesignTime()) {
                return null;
            }
            return this.pbuffer.getContext();
        }
        return this.offscreenContext;
    }

    @Override
    public GL getGL() {
        GLContext gLContext = this.getContext();
        if (gLContext == null) {
            return null;
        }
        return gLContext.getGL();
    }

    @Override
    public void setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
        }
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return true;
    }

    @Override
    public void swapBuffers() {
    }

    public boolean shouldPreserveColorBufferIfTranslucent() {
        return this.oglPipelineEnabled;
    }

    @Override
    public GLCapabilities getChosenGLCapabilities() {
        if (this.oglPipelineEnabled) {
            return new GLCapabilities();
        }
        if (hardwareAccelerationDisabled) {
            if (this.offscreenDrawable != null) {
                return this.offscreenDrawable.getChosenGLCapabilities();
            }
        } else if (this.pbuffer != null) {
            return this.pbuffer.getChosenGLCapabilities();
        }
        return null;
    }

    private void initialize() {
        if (this.panelWidth == 0 || this.panelHeight == 0) {
            if (this.reshapeWidth == 0 || this.reshapeHeight == 0) {
                return;
            }
            this.panelWidth = this.reshapeWidth;
            this.panelHeight = this.reshapeHeight;
        }
        if (!this.oglPipelineEnabled) {
            if (!hardwareAccelerationDisabled) {
                if (GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
                    if (this.pbuffer != null) {
                        throw new InternalError("Creating pbuffer twice without destroying it (memory leak / correctness bug)");
                    }
                    try {
                        this.pbuffer = GLDrawableFactory.getFactory().createGLPbuffer(this.offscreenCaps, null, this.pbufferWidth, this.pbufferHeight, this.shareWith);
                        this.updater = new GLJPanel$Updater(this);
                        this.pbuffer.addGLEventListener(this.updater);
                        this.shouldInitialize = false;
                        this.isInitialized = true;
                        return;
                    }
                    catch (GLException gLException) {
                        if (DEBUG) {
                            gLException.printStackTrace();
                            System.err.println("GLJPanel: Falling back on software rendering because of problems creating pbuffer");
                        }
                        hardwareAccelerationDisabled = true;
                    }
                } else {
                    if (DEBUG) {
                        System.err.println("GLJPanel: Falling back on software rendering because no pbuffer support");
                    }
                    hardwareAccelerationDisabled = true;
                }
            }
            if (softwareRenderingDisabled) {
                throw new GLException("Fallback to software rendering disabled by user");
            }
            this.offscreenDrawable = GLDrawableFactoryImpl.getFactoryImpl().createOffscreenDrawable(this.offscreenCaps, this.chooser);
            this.offscreenDrawable.setSize(Math.max(1, this.panelWidth), Math.max(1, this.panelHeight));
            this.offscreenContext = (GLContextImpl)this.offscreenDrawable.createContext(this.shareWith);
            this.offscreenContext.setSynchronized(true);
        }
        this.updater = new GLJPanel$Updater(this);
        this.shouldInitialize = false;
        this.isInitialized = true;
    }

    private void handleReshape() {
        this.readBackWidthInPixels = 0;
        this.readBackHeightInPixels = 0;
        this.panelWidth = this.reshapeWidth;
        this.panelHeight = this.reshapeHeight;
        if (DEBUG) {
            System.err.println("GLJPanel.handleReshape: (w,h) = (" + this.panelWidth + "," + this.panelHeight + ")");
        }
        this.sendReshape = true;
        if (!this.oglPipelineEnabled) {
            if (!hardwareAccelerationDisabled) {
                if (this.panelWidth > this.pbufferWidth || this.panelHeight > this.pbufferHeight || (float)this.panelWidth < (float)this.pbufferWidth / 2.5f || (float)this.panelHeight < (float)this.pbufferHeight / 2.5f) {
                    block13: {
                        if (DEBUG) {
                            System.err.println("Resizing pbuffer from (" + this.pbufferWidth + ", " + this.pbufferHeight + ")  to fit (" + this.panelWidth + ", " + this.panelHeight + ")");
                        }
                        if (this.pbuffer != null) {
                            try {
                                this.pbuffer.destroy();
                            }
                            catch (GLException gLException) {
                                hardwareAccelerationDisabled = true;
                                if (!DEBUG) break block13;
                                System.err.println("WARNING: falling back to software rendering due to bugs in OpenGL drivers");
                                gLException.printStackTrace();
                            }
                        }
                    }
                    this.pbuffer = null;
                    this.isInitialized = false;
                    this.pbufferWidth = this.getNextPowerOf2(this.panelWidth);
                    this.pbufferHeight = this.getNextPowerOf2(this.panelHeight);
                    if (DEBUG && !hardwareAccelerationDisabled) {
                        System.err.println("New pbuffer size is (" + this.pbufferWidth + ", " + this.pbufferHeight + ")");
                    }
                    this.initialize();
                }
                if (!hardwareAccelerationDisabled) {
                    this.readBackWidthInPixels = this.pbufferWidth;
                    this.readBackHeightInPixels = this.panelHeight;
                } else {
                    this.readBackWidthInPixels = Math.max(1, this.panelWidth);
                    this.readBackHeightInPixels = Math.max(1, this.panelHeight);
                }
            } else {
                this.offscreenContext.destroy();
                this.offscreenDrawable.setSize(Math.max(1, this.panelWidth), Math.max(1, this.panelHeight));
                this.readBackWidthInPixels = Math.max(1, this.panelWidth);
                this.readBackHeightInPixels = Math.max(1, this.panelHeight);
            }
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
        }
        this.handleReshape = false;
    }

    private int getNextPowerOf2(int n2) {
        if (n2 == 0) {
            return 2;
        }
        if ((n2 - 1 & n2) == 0) {
            return n2;
        }
        int n3 = 0;
        while (n2 > 0) {
            n2 >>= 1;
            ++n3;
        }
        return 1 << n3;
    }

    private int getGLInteger(GL gL, int n2) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(n2, nArray, 0);
        return nArray[0];
    }

    static /* synthetic */ boolean access$000() {
        return DEBUG;
    }

    static /* synthetic */ boolean access$100() {
        return VERBOSE;
    }

    static /* synthetic */ GLContext access$200(GLJPanel gLJPanel) {
        return gLJPanel.j2dContext;
    }

    static /* synthetic */ GLContext access$202(GLJPanel gLJPanel, GLContext gLContext) {
        gLJPanel.j2dContext = gLContext;
        return gLJPanel.j2dContext;
    }

    static /* synthetic */ int access$300(GLJPanel gLJPanel, GL gL, int n2) {
        return gLJPanel.getGLInteger(gL, n2);
    }

    static /* synthetic */ GLCapabilities access$400(GLJPanel gLJPanel) {
        return gLJPanel.offscreenCaps;
    }

    static /* synthetic */ boolean access$502(GLJPanel gLJPanel, boolean bl) {
        gLJPanel.isInitialized = bl;
        return gLJPanel.isInitialized;
    }

    static /* synthetic */ boolean access$602(GLJPanel gLJPanel, boolean bl) {
        gLJPanel.shouldInitialize = bl;
        return gLJPanel.shouldInitialize;
    }

    static /* synthetic */ boolean access$702(GLJPanel gLJPanel, boolean bl) {
        gLJPanel.oglPipelineEnabled = bl;
        return gLJPanel.oglPipelineEnabled;
    }

    static /* synthetic */ boolean access$802(GLJPanel gLJPanel, boolean bl) {
        gLJPanel.handleReshape = bl;
        return gLJPanel.handleReshape;
    }

    static /* synthetic */ void access$900(GLJPanel gLJPanel, GL gL, Graphics graphics) {
        gLJPanel.captureJ2DState(gL, graphics);
    }

    static /* synthetic */ Object access$1000(GLJPanel gLJPanel) {
        return gLJPanel.j2dSurface;
    }

    static /* synthetic */ GLContext access$1100(GLJPanel gLJPanel) {
        return gLJPanel.joglContext;
    }

    static /* synthetic */ GLContext access$1102(GLJPanel gLJPanel, GLContext gLContext) {
        gLJPanel.joglContext = gLContext;
        return gLJPanel.joglContext;
    }

    static /* synthetic */ GLDrawable access$1202(GLJPanel gLJPanel, GLDrawable gLDrawable) {
        gLJPanel.joglDrawable = gLDrawable;
        return gLJPanel.joglDrawable;
    }

    static /* synthetic */ boolean access$1302(GLJPanel gLJPanel, boolean bl) {
        gLJPanel.sendReshape = bl;
        return gLJPanel.sendReshape;
    }

    static /* synthetic */ Object access$1002(GLJPanel gLJPanel, Object object) {
        gLJPanel.j2dSurface = object;
        return gLJPanel.j2dSurface;
    }

    static /* synthetic */ GLContext access$1400(GLJPanel gLJPanel) {
        return gLJPanel.shareWith;
    }

    static /* synthetic */ GLDrawable access$1200(GLJPanel gLJPanel) {
        return gLJPanel.joglDrawable;
    }

    static /* synthetic */ boolean access$1500(GLJPanel gLJPanel) {
        return gLJPanel.fbObjectWorkarounds;
    }

    static /* synthetic */ boolean access$1602(GLJPanel gLJPanel, boolean bl) {
        gLJPanel.createNewDepthBuffer = bl;
        return gLJPanel.createNewDepthBuffer;
    }

    static /* synthetic */ GLJPanel$DisplayAction access$1700(GLJPanel gLJPanel) {
        return gLJPanel.displayAction;
    }

    static /* synthetic */ GLJPanel$InitAction access$1800(GLJPanel gLJPanel) {
        return gLJPanel.initAction;
    }

    static /* synthetic */ GLDrawableHelper access$1900(GLJPanel gLJPanel) {
        return gLJPanel.drawableHelper;
    }

    static /* synthetic */ boolean access$700(GLJPanel gLJPanel) {
        return gLJPanel.oglPipelineEnabled;
    }

    static /* synthetic */ boolean access$2000(GLJPanel gLJPanel, Graphics graphics) {
        return gLJPanel.preGL(graphics);
    }

    static /* synthetic */ void access$2100(GLJPanel gLJPanel, Graphics graphics) {
        gLJPanel.postGL(graphics);
    }

    static /* synthetic */ boolean access$1300(GLJPanel gLJPanel) {
        return gLJPanel.sendReshape;
    }

    static /* synthetic */ int access$2200(GLJPanel gLJPanel) {
        return gLJPanel.viewportX;
    }

    static /* synthetic */ int access$2300(GLJPanel gLJPanel) {
        return gLJPanel.viewportY;
    }

    static /* synthetic */ int access$2400(GLJPanel gLJPanel) {
        return gLJPanel.panelWidth;
    }

    static /* synthetic */ int access$2500(GLJPanel gLJPanel) {
        return gLJPanel.panelHeight;
    }

    static /* synthetic */ BufferedImage access$2600(GLJPanel gLJPanel) {
        return gLJPanel.offscreenImage;
    }

    static /* synthetic */ boolean access$2700() {
        return hardwareAccelerationDisabled;
    }

    static /* synthetic */ BufferedImage access$2602(GLJPanel gLJPanel, BufferedImage bufferedImage) {
        gLJPanel.offscreenImage = bufferedImage;
        return gLJPanel.offscreenImage;
    }

    static /* synthetic */ int access$2802(GLJPanel gLJPanel, int n2) {
        gLJPanel.glFormat = n2;
        return gLJPanel.glFormat;
    }

    static /* synthetic */ int access$2902(GLJPanel gLJPanel, int n2) {
        gLJPanel.glType = n2;
        return gLJPanel.glType;
    }

    static /* synthetic */ ByteBuffer access$3002(GLJPanel gLJPanel, ByteBuffer byteBuffer) {
        gLJPanel.readBackBytes = byteBuffer;
        return gLJPanel.readBackBytes;
    }

    static /* synthetic */ int access$3100(GLJPanel gLJPanel) {
        return gLJPanel.readBackWidthInPixels;
    }

    static /* synthetic */ int access$3200(GLJPanel gLJPanel) {
        return gLJPanel.readBackHeightInPixels;
    }

    static /* synthetic */ GLContextImpl access$3300(GLJPanel gLJPanel) {
        return gLJPanel.offscreenContext;
    }

    static /* synthetic */ IntBuffer access$3402(GLJPanel gLJPanel, IntBuffer intBuffer) {
        gLJPanel.readBackInts = intBuffer;
        return gLJPanel.readBackInts;
    }

    static /* synthetic */ int[] access$3500(GLJPanel gLJPanel) {
        return gLJPanel.swapbytes;
    }

    static /* synthetic */ int[] access$3600(GLJPanel gLJPanel) {
        return gLJPanel.rowlength;
    }

    static /* synthetic */ int[] access$3700(GLJPanel gLJPanel) {
        return gLJPanel.skiprows;
    }

    static /* synthetic */ int[] access$3800(GLJPanel gLJPanel) {
        return gLJPanel.skippixels;
    }

    static /* synthetic */ int[] access$3900(GLJPanel gLJPanel) {
        return gLJPanel.alignment;
    }

    static /* synthetic */ ByteBuffer access$3000(GLJPanel gLJPanel) {
        return gLJPanel.readBackBytes;
    }

    static /* synthetic */ int access$2800(GLJPanel gLJPanel) {
        return gLJPanel.glFormat;
    }

    static /* synthetic */ int access$2900(GLJPanel gLJPanel) {
        return gLJPanel.glType;
    }

    static /* synthetic */ IntBuffer access$3400(GLJPanel gLJPanel) {
        return gLJPanel.readBackInts;
    }

    static /* synthetic */ GLJPanel$Updater access$4000(GLJPanel gLJPanel) {
        return gLJPanel.updater;
    }

    static /* synthetic */ GLDrawableImpl access$4100(GLJPanel gLJPanel) {
        return gLJPanel.offscreenDrawable;
    }

    static {
        if (Java2D.isOGLPipelineActive() && Java2D.isFBOEnabled()) {
            Java2D.getShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        }
    }
}

