/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.spi.DDSImage;
import com.sun.opengl.util.texture.spi.TextureWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

class TextureIO$DDSTextureWriter
implements TextureWriter {
    TextureIO$DDSTextureWriter() {
    }

    @Override
    public boolean write(File file, TextureData textureData) {
        if ("dds".equals(FileUtil.getFileSuffix(file))) {
            ByteBuffer[] byteBufferArray;
            int n2 = textureData.getPixelFormat();
            int n3 = textureData.getPixelType();
            if (n3 != 5120 && n3 != 5121) {
                throw new IOException("DDS writer only supports byte / unsigned byte textures");
            }
            switch (n2) {
                case 6407: {
                    n2 = 20;
                    break;
                }
                case 6408: {
                    n2 = 21;
                    break;
                }
                case 33776: {
                    n2 = 827611204;
                    break;
                }
                case 33777: {
                    throw new IOException("RGBA DXT1 not yet supported");
                }
                case 33778: {
                    n2 = 861165636;
                    break;
                }
                case 33779: {
                    n2 = 894720068;
                    break;
                }
                default: {
                    throw new IOException("Unsupported pixel format 0x" + Integer.toHexString(n2) + " by DDS writer");
                }
            }
            if (textureData.getMipmapData() != null) {
                byteBufferArray = new ByteBuffer[textureData.getMipmapData().length];
                for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
                    byteBufferArray[i2] = (ByteBuffer)textureData.getMipmapData()[i2];
                }
            } else {
                byteBufferArray = new ByteBuffer[]{(ByteBuffer)textureData.getBuffer()};
            }
            DDSImage.createFromData(n2, textureData.getWidth(), textureData.getHeight(), byteBufferArray).write(file);
            return true;
        }
        return false;
    }
}

