/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.j2d;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class TextureRenderer {
    private boolean alpha;
    private boolean intensity;
    private boolean mipmap;
    private boolean smoothing = true;
    private boolean smoothingChanged;
    private BufferedImage image;
    private Texture texture;
    private TextureData textureData;
    private boolean mustReallocateTexture;
    private Rectangle dirtyRegion;
    private GLU glu = new GLU();
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float a = 1.0f;
    private float[] compArray;

    public TextureRenderer(int n2, int n3, boolean bl) {
        this(n2, n3, bl, false);
    }

    public TextureRenderer(int n2, int n3, boolean bl, boolean bl2) {
        this(n2, n3, bl, false, bl2);
    }

    private TextureRenderer(int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this.alpha = bl;
        this.intensity = bl2;
        this.mipmap = bl3;
        this.init(n2, n3);
    }

    public static TextureRenderer createAlphaOnlyRenderer(int n2, int n3) {
        return TextureRenderer.createAlphaOnlyRenderer(n2, n3, false);
    }

    public static TextureRenderer createAlphaOnlyRenderer(int n2, int n3, boolean bl) {
        return new TextureRenderer(n2, n3, false, true, bl);
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public Dimension getSize() {
        return this.getSize(null);
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        dimension.setSize(this.image.getWidth(), this.image.getHeight());
        return dimension;
    }

    public void setSize(int n2, int n3) {
        this.init(n2, n3);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSmoothing(boolean bl) {
        this.smoothing = bl;
        this.smoothingChanged = true;
    }

    public boolean getSmoothing() {
        return this.smoothing;
    }

    public Graphics2D createGraphics() {
        return this.image.createGraphics();
    }

    public Image getImage() {
        return this.image;
    }

    public void markDirty(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        if (this.dirtyRegion == null) {
            this.dirtyRegion = rectangle;
            return;
        }
        this.dirtyRegion.add(rectangle);
    }

    public Texture getTexture() {
        if (this.dirtyRegion != null) {
            this.sync(this.dirtyRegion.x, this.dirtyRegion.y, this.dirtyRegion.width, this.dirtyRegion.height);
            this.dirtyRegion = null;
        }
        this.ensureTexture();
        return this.texture;
    }

    public void dispose() {
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
    }

    public void beginOrthoRendering(int n2, int n3) {
        this.beginOrthoRendering(n2, n3, true);
    }

    public void beginOrthoRendering(int n2, int n3, boolean bl) {
        this.beginRendering(true, n2, n3, bl);
    }

    public void begin3DRendering() {
        this.beginRendering(false, 0, 0, false);
    }

    public void setColor(float f2, float f3, float f4, float f5) {
        GL gL = GLU.getCurrentGL();
        this.r = f2 * f5;
        this.g = f3 * f5;
        this.b = f4 * f5;
        this.a = f5;
        gL.glColor4f(this.r, this.g, this.b, this.a);
    }

    public void setColor(Color color) {
        if (this.compArray == null) {
            this.compArray = new float[4];
        }
        color.getRGBComponents(this.compArray);
        this.setColor(this.compArray[0], this.compArray[1], this.compArray[2], this.compArray[3]);
    }

    public void drawOrthoRect(int n2, int n3) {
        this.drawOrthoRect(n2, n3, 0, 0, this.getWidth(), this.getHeight());
    }

    public void drawOrthoRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw3DRect(n2, n3, 0.0f, n4, n5, n6, n7, 1.0f);
    }

    public void draw3DRect(float f2, float f3, float f4, int n2, int n3, int n4, int n5, float f5) {
        GL gL = GLU.getCurrentGL();
        TextureCoords textureCoords = this.getTexture().getSubImageTexCoords(n2, n3, n2 + n4, n3 + n5);
        gL.glBegin(7);
        gL.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
        gL.glVertex3f(f2, f3, f4);
        gL.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
        gL.glVertex3f(f2 + (float)n4 * f5, f3, f4);
        gL.glTexCoord2f(textureCoords.right(), textureCoords.top());
        gL.glVertex3f(f2 + (float)n4 * f5, f3 + (float)n5 * f5, f4);
        gL.glTexCoord2f(textureCoords.left(), textureCoords.top());
        gL.glVertex3f(f2, f3 + (float)n5 * f5, f4);
        gL.glEnd();
    }

    public void endOrthoRendering() {
        this.endRendering(true);
    }

    public void end3DRendering() {
        this.endRendering(false);
    }

    public boolean isUsingAutoMipmapGeneration() {
        return this.mipmap;
    }

    private void beginRendering(boolean bl, int n2, int n3, boolean bl2) {
        GL gL = GLU.getCurrentGL();
        int n4 = 0x46000 | (bl ? 4352 : 0);
        gL.glPushAttrib(n4);
        gL.glDisable(2896);
        if (bl) {
            if (bl2) {
                gL.glDisable(2929);
            }
            gL.glDisable(2884);
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            this.glu.gluOrtho2D(0.0, n2, 0.0, n3);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            gL.glMatrixMode(5890);
            gL.glPushMatrix();
            gL.glLoadIdentity();
        }
        gL.glEnable(3042);
        gL.glBlendFunc(1, 771);
        Texture texture = this.getTexture();
        texture.enable();
        texture.bind();
        gL.glTexEnvi(8960, 8704, 8448);
        gL.glColor4f(this.r, this.g, this.b, this.a);
        if (this.smoothingChanged) {
            this.smoothingChanged = false;
            if (this.smoothing) {
                texture.setTexParameteri(10240, 9729);
                if (this.mipmap) {
                    texture.setTexParameteri(10241, 9987);
                    return;
                }
                texture.setTexParameteri(10241, 9729);
                return;
            }
            texture.setTexParameteri(10241, 9728);
            texture.setTexParameteri(10240, 9728);
        }
    }

    private void endRendering(boolean bl) {
        GL gL = GLU.getCurrentGL();
        this.getTexture().disable();
        if (bl) {
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
            gL.glMatrixMode(5888);
            gL.glPopMatrix();
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
        }
        gL.glPopAttrib();
    }

    private void init(int n2, int n3) {
        int n4;
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        int n5 = n4 = this.intensity ? 32841 : 0;
        int n6 = this.intensity ? 10 : (this.alpha ? 3 : 1);
        this.image = new BufferedImage(n2, n3, n6);
        this.textureData = new TextureData(n4, 0, this.mipmap, this.image);
        this.mustReallocateTexture = true;
    }

    private void sync(int n2, int n3, int n4, int n5) {
        if (!this.ensureTexture()) {
            this.texture.updateSubImage(this.textureData, 0, n2, n3, n2, n3, n4, n5);
        }
    }

    private boolean ensureTexture() {
        if (this.mustReallocateTexture) {
            if (this.texture != null) {
                this.texture.dispose();
                this.texture = null;
            }
            this.mustReallocateTexture = false;
        }
        if (this.texture == null) {
            this.texture = TextureIO.newTexture(this.textureData);
            if (this.mipmap && !this.texture.isUsingAutoMipmapGeneration()) {
                this.texture.dispose();
                this.mipmap = false;
                this.textureData.setMipmap(false);
                this.texture = TextureIO.newTexture(this.textureData);
            }
            if (!this.smoothing) {
                this.texture.setTexParameteri(10241, 9728);
                this.texture.setTexParameteri(10240, 9728);
            }
            return true;
        }
        return false;
    }
}

