/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.gluegen.runtime.ProcAddressHelper;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.JAWT;
import com.sun.opengl.impl.Java2D;
import com.sun.opengl.impl.NativeLibLoader;
import com.sun.opengl.impl.x11.DRIHack;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.X11ExternalGLContext;
import com.sun.opengl.impl.x11.X11ExternalGLDrawable;
import com.sun.opengl.impl.x11.X11GLDrawableFactory$1;
import com.sun.opengl.impl.x11.X11GLDrawableFactory$2;
import com.sun.opengl.impl.x11.X11GLDrawableFactory$ScreenAndVisualIDKey;
import com.sun.opengl.impl.x11.X11OffscreenGLDrawable;
import com.sun.opengl.impl.x11.X11OnscreenGLDrawable;
import com.sun.opengl.impl.x11.X11SunJDKReflection;
import com.sun.opengl.impl.x11.XVisualInfo;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.AWTGraphicsConfiguration;
import javax.media.opengl.AWTGraphicsDevice;
import javax.media.opengl.AbstractGraphicsConfiguration;
import javax.media.opengl.AbstractGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;

public class X11GLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final boolean DEBUG = Debug.debug("X11GLDrawableFactory");
    private static boolean isVendorATI;
    private static boolean isHeadless;
    private static Map visualToGLCapsMap;
    private static final int MAX_ATTRIBS = 128;
    private boolean pbufferSupportInitialized = false;
    private boolean canCreateGLPbuffer = false;
    private static long staticDisplay;
    private static boolean checkedMultisample;
    private static boolean multisampleAvailable;
    private boolean checkedXinerama;
    private boolean xineramaEnabled;
    private boolean gotGammaRampLength;
    private int gammaRampLength;

    public X11GLDrawableFactory() {
        ProcAddressHelper.resetProcAddressTable(GLX.getGLXProcAddressTable(), this);
    }

    @Override
    public AbstractGraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities object, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsDevice object2) {
        int n2;
        int n3;
        GLCapabilities[] gLCapabilitiesArray;
        if (object == null) {
            object = new GLCapabilities();
        }
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        if (object2 != null && !(object2 instanceof AWTGraphicsDevice)) {
            throw new IllegalArgumentException("This GLDrawableFactory accepts only AWTGraphicsDevice objects");
        }
        object2 = object2 == null || ((AWTGraphicsDevice)object2).getGraphicsDevice() == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice() : ((AWTGraphicsDevice)object2).getGraphicsDevice();
        int n4 = this.isXineramaEnabled() ? 0 : X11SunJDKReflection.graphicsDeviceGetScreen((GraphicsDevice)object2);
        Object object3 = X11GLDrawableFactory.glCapabilities2AttribList(object, X11GLDrawableFactory.isMultisampleAvailable(), false, 0L, 0);
        int n5 = -1;
        this.lockToolkit();
        try {
            long l2 = X11GLDrawableFactory.getDisplayConnection();
            XVisualInfo xVisualInfo = GLX.glXChooseVisual(l2, n4, object3, 0);
            if (DEBUG) {
                System.err.print("!!! glXChooseVisual recommended ");
                if (xVisualInfo == null) {
                    System.err.println("null visual");
                } else {
                    System.err.println("visual id 0x" + Long.toHexString(xVisualInfo.visualid()));
                }
            }
            int[] nArray = new int[1];
            XVisualInfo xVisualInfo2 = XVisualInfo.create();
            object3 = xVisualInfo2;
            xVisualInfo2.screen(n4);
            XVisualInfo[] xVisualInfoArray = GLX.XGetVisualInfo(l2, 2L, (XVisualInfo)object3, nArray, 0);
            object3 = xVisualInfoArray;
            if (xVisualInfoArray == null) {
                throw new GLException("Error while enumerating available XVisualInfos");
            }
            gLCapabilitiesArray = new GLCapabilities[((int[])object3).length];
            for (n3 = 0; n3 < ((int[])object3).length; ++n3) {
                gLCapabilitiesArray[n3] = X11GLDrawableFactory.xvi2GLCapabilities(l2, (XVisualInfo)object3[n3]);
                if (xVisualInfo == null || xVisualInfo.visualid() != object3[n3].visualid()) continue;
                n5 = n3;
            }
        }
        finally {
            this.unlockToolkit();
        }
        for (n2 = 0; n2 < ((int[])object3).length; ++n2) {
            if (gLCapabilitiesArray[n2] == null) continue;
            visualToGLCapsMap.put(new X11GLDrawableFactory$ScreenAndVisualIDKey(n4, object3[n2].visualid()), gLCapabilitiesArray[n2].clone());
        }
        n2 = gLCapabilitiesChooser.chooseCapabilities((GLCapabilities)object, gLCapabilitiesArray, n5);
        if (n2 < 0 || n2 >= gLCapabilitiesArray.length) {
            throw new GLException("GLCapabilitiesChooser specified invalid index (expected 0.." + (gLCapabilitiesArray.length - 1) + ")");
        }
        int n6 = object3[n2];
        if (n6 == null) {
            throw new GLException("GLCapabilitiesChooser chose an invalid visual");
        }
        long l3 = n6.visualid();
        object3 = ((GraphicsDevice)object2).getConfigurations();
        for (n3 = 0; n3 < ((int[])object3).length; ++n3) {
            int n7 = object3[n3];
            object = n7;
            if (n7 == null || (long)X11SunJDKReflection.graphicsConfigurationGetVisualID((GraphicsConfiguration)object) != l3) continue;
            return new AWTGraphicsConfiguration((GraphicsConfiguration)object);
        }
        return null;
    }

    @Override
    public GLDrawable getGLDrawable(Object object, GLCapabilities object2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        if (object == null) {
            throw new IllegalArgumentException("Null target");
        }
        if (!(object instanceof Component)) {
            throw new IllegalArgumentException("GLDrawables not supported for objects of type " + object.getClass().getName() + " (only Components are supported in this implementation)");
        }
        object = (Component)object;
        object2 = new X11OnscreenGLDrawable((Component)object);
        if ((object = ((Component)object).getGraphicsConfiguration()) == null) {
            throw new IllegalArgumentException("GLDrawableFactory.chooseGraphicsConfiguration() was not used when creating this Component");
        }
        int n2 = X11SunJDKReflection.graphicsConfigurationGetVisualID((GraphicsConfiguration)object);
        int n3 = this.isXineramaEnabled() ? 0 : X11SunJDKReflection.graphicsDeviceGetScreen(((GraphicsConfiguration)object).getDevice());
        ((GLDrawableImpl)object2).setChosenGLCapabilities((GLCapabilities)visualToGLCapsMap.get(new X11GLDrawableFactory$ScreenAndVisualIDKey(n3, n2)));
        return object2;
    }

    @Override
    public GLDrawableImpl createOffscreenDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        return new X11OffscreenGLDrawable(gLCapabilities, gLCapabilitiesChooser);
    }

    @Override
    public boolean canCreateGLPbuffer() {
        if (!this.pbufferSupportInitialized) {
            X11GLDrawableFactory$1 x11GLDrawableFactory$1 = new X11GLDrawableFactory$1(this);
            this.maybeDoSingleThreadedWorkaround(x11GLDrawableFactory$1);
        }
        return this.canCreateGLPbuffer;
    }

    @Override
    public GLPbuffer createGLPbuffer(GLCapabilities object, GLCapabilitiesChooser object2, int n2, int n3, GLContext gLContext) {
        if (!this.canCreateGLPbuffer()) {
            throw new GLException("Pbuffer support not available with current graphics card");
        }
        object2 = new ArrayList();
        object = new X11GLDrawableFactory$2(this, (GLCapabilities)object, n2, n3, gLContext, (List)object2);
        this.maybeDoSingleThreadedWorkaround((Runnable)object);
        return (GLPbuffer)object2.get(0);
    }

    @Override
    public GLContext createExternalGLContext() {
        return new X11ExternalGLContext();
    }

    @Override
    public boolean canCreateExternalGLDrawable() {
        return this.canCreateGLPbuffer();
    }

    @Override
    public GLDrawable createExternalGLDrawable() {
        return new X11ExternalGLDrawable();
    }

    @Override
    public void loadGLULibrary() {
        GLX.dlopen("/usr/lib/libGLU.so");
    }

    @Override
    public long dynamicLookupFunction(String string) {
        long l2 = GLX.glXGetProcAddressARB(string);
        if (l2 == 0L) {
            l2 = GLX.dlsym(string);
        }
        return l2;
    }

    public static GLCapabilities xvi2GLCapabilities(long l2, XVisualInfo xVisualInfo) {
        int[] nArray = new int[1];
        if (X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 1, nArray, 0) == 0) {
            return null;
        }
        if (X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 4, nArray, 0) == 0) {
            return null;
        }
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 5, nArray, 0) != 0);
        gLCapabilities.setStereo(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 6, nArray, 0) != 0);
        gLCapabilities.setHardwareAccelerated(true);
        gLCapabilities.setDepthBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 12, nArray, 0));
        gLCapabilities.setStencilBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 13, nArray, 0));
        gLCapabilities.setRedBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 8, nArray, 0));
        gLCapabilities.setGreenBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 9, nArray, 0));
        gLCapabilities.setBlueBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 10, nArray, 0));
        gLCapabilities.setAlphaBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 11, nArray, 0));
        gLCapabilities.setAccumRedBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 14, nArray, 0));
        gLCapabilities.setAccumGreenBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 15, nArray, 0));
        gLCapabilities.setAccumBlueBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 16, nArray, 0));
        gLCapabilities.setAccumAlphaBits(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 17, nArray, 0));
        if (X11GLDrawableFactory.isMultisampleAvailable()) {
            gLCapabilities.setSampleBuffers(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 100000, nArray, 0) != 0);
            gLCapabilities.setNumSamples(X11GLDrawableFactory.glXGetConfig(l2, xVisualInfo, 100001, nArray, 0));
        }
        return gLCapabilities;
    }

    public static int[] glCapabilities2AttribList(GLCapabilities object, boolean bl, boolean bl2, long l2, int n2) {
        if (((GLCapabilities)object).getRedBits() + ((GLCapabilities)object).getGreenBits() + ((GLCapabilities)object).getBlueBits() < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        int[] nArray = new int[128];
        int n3 = 0;
        if (bl2) {
            ++n3;
            nArray[0] = 32784;
            ++n3;
            nArray[1] = 4;
            ++n3;
            nArray[2] = 32785;
            ++n3;
            nArray[3] = 1;
        } else {
            ++n3;
            nArray[0] = 4;
        }
        if (((GLCapabilities)object).getDoubleBuffered()) {
            nArray[n3++] = 5;
            if (bl2) {
                nArray[n3++] = 1;
            }
        } else if (bl2) {
            nArray[n3++] = 5;
            nArray[n3++] = 0;
        }
        if (((GLCapabilities)object).getStereo()) {
            nArray[n3++] = 6;
            if (bl2) {
                nArray[n3++] = 1;
            }
        }
        nArray[n3++] = 8;
        nArray[n3++] = ((GLCapabilities)object).getRedBits();
        nArray[n3++] = 9;
        nArray[n3++] = ((GLCapabilities)object).getGreenBits();
        nArray[n3++] = 10;
        nArray[n3++] = ((GLCapabilities)object).getBlueBits();
        nArray[n3++] = 11;
        nArray[n3++] = ((GLCapabilities)object).getAlphaBits();
        nArray[n3++] = 12;
        nArray[n3++] = ((GLCapabilities)object).getDepthBits();
        if (((GLCapabilities)object).getStencilBits() > 0) {
            nArray[n3++] = 13;
            nArray[n3++] = ((GLCapabilities)object).getStencilBits();
        }
        if (((GLCapabilities)object).getAccumRedBits() > 0 || ((GLCapabilities)object).getAccumGreenBits() > 0 || ((GLCapabilities)object).getAccumBlueBits() > 0 || ((GLCapabilities)object).getAccumAlphaBits() > 0) {
            nArray[n3++] = 14;
            nArray[n3++] = ((GLCapabilities)object).getAccumRedBits();
            nArray[n3++] = 15;
            nArray[n3++] = ((GLCapabilities)object).getAccumGreenBits();
            nArray[n3++] = 16;
            nArray[n3++] = ((GLCapabilities)object).getAccumBlueBits();
            nArray[n3++] = 17;
            nArray[n3++] = ((GLCapabilities)object).getAccumAlphaBits();
        }
        if (bl && ((GLCapabilities)object).getSampleBuffers()) {
            nArray[n3++] = 100000;
            nArray[n3++] = 1;
            nArray[n3++] = 100001;
            nArray[n3++] = ((GLCapabilities)object).getNumSamples();
        }
        if (bl2 && ((GLCapabilities)object).getPbufferFloatingPointBuffers()) {
            object = GLX.glXQueryExtensionsString(l2, n2);
            if (object == null || ((String)object).indexOf("GLX_NV_float_buffer") < 0) {
                throw new GLException("Floating-point pbuffers on X11 currently require NVidia hardware");
            }
            nArray[n3++] = 8368;
            nArray[n3++] = 1;
        }
        nArray[n3] = 0;
        return nArray;
    }

    public static GLCapabilities attribList2GLCapabilities(int[] nArray, int n2, int[] nArray2, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        block17: for (int i2 = 0; i2 < n2; ++i2) {
            switch (nArray[i2]) {
                case 5: {
                    gLCapabilities.setDoubleBuffered(nArray2[i2] != 0);
                    continue block17;
                }
                case 6: {
                    gLCapabilities.setStereo(nArray2[i2] != 0);
                    continue block17;
                }
                case 8: {
                    gLCapabilities.setRedBits(nArray2[i2]);
                    continue block17;
                }
                case 9: {
                    gLCapabilities.setGreenBits(nArray2[i2]);
                    continue block17;
                }
                case 10: {
                    gLCapabilities.setBlueBits(nArray2[i2]);
                    continue block17;
                }
                case 11: {
                    gLCapabilities.setAlphaBits(nArray2[i2]);
                    continue block17;
                }
                case 12: {
                    gLCapabilities.setDepthBits(nArray2[i2]);
                    continue block17;
                }
                case 13: {
                    gLCapabilities.setStencilBits(nArray2[i2]);
                    continue block17;
                }
                case 14: {
                    gLCapabilities.setAccumRedBits(nArray2[i2]);
                    continue block17;
                }
                case 15: {
                    gLCapabilities.setAccumGreenBits(nArray2[i2]);
                    continue block17;
                }
                case 16: {
                    gLCapabilities.setAccumBlueBits(nArray2[i2]);
                    continue block17;
                }
                case 17: {
                    gLCapabilities.setAccumAlphaBits(nArray2[i2]);
                    continue block17;
                }
                case 100000: {
                    gLCapabilities.setSampleBuffers(nArray2[i2] != 0);
                    continue block17;
                }
                case 100001: {
                    gLCapabilities.setNumSamples(nArray2[i2]);
                    continue block17;
                }
                case 8368: {
                    gLCapabilities.setPbufferFloatingPointBuffers(nArray2[i2] != 0);
                }
            }
        }
        return gLCapabilities;
    }

    public void lockToolkit() {
        if (isHeadless) {
            return;
        }
        if (!Java2D.isOGLPipelineActive() || !Java2D.isQueueFlusherThread()) {
            JAWT.getJAWT().Lock();
        }
    }

    public void unlockToolkit() {
        if (isHeadless) {
            return;
        }
        if (!Java2D.isOGLPipelineActive() || !Java2D.isQueueFlusherThread()) {
            JAWT.getJAWT().Unlock();
        }
    }

    @Override
    public void lockAWTForJava2D() {
        this.lockToolkit();
    }

    @Override
    public void unlockAWTForJava2D() {
        this.unlockToolkit();
    }

    public static long getDisplayConnection() {
        if (staticDisplay == 0L) {
            X11GLDrawableFactory.getX11Factory().lockToolkit();
            try {
                String string;
                staticDisplay = GLX.XOpenDisplay(null);
                if (DEBUG && staticDisplay != 0L) {
                    long l2 = staticDisplay;
                    System.err.println("!!! GLX server vendor : " + GLX.glXQueryServerString(l2, 0, 1));
                    System.err.println("!!! GLX server version: " + GLX.glXQueryServerString(l2, 0, 2));
                    System.err.println("!!! GLX client vendor : " + GLX.glXGetClientString(l2, 1));
                    System.err.println("!!! GLX client version: " + GLX.glXGetClientString(l2, 2));
                }
                if (staticDisplay != 0L && (string = GLX.glXGetClientString(staticDisplay, 1)) != null && string.startsWith("ATI")) {
                    isVendorATI = true;
                }
            }
            finally {
                X11GLDrawableFactory.getX11Factory().unlockToolkit();
            }
            if (staticDisplay == 0L) {
                throw new GLException("Unable to open default display, needed for visual selection and offscreen surface handling");
            }
        }
        return staticDisplay;
    }

    public static boolean isMultisampleAvailable() {
        if (!checkedMultisample) {
            String string = GLX.glXGetClientString(X11GLDrawableFactory.getDisplayConnection(), 3);
            if (string != null) {
                multisampleAvailable = string.indexOf("GLX_ARB_multisample") >= 0;
            }
            checkedMultisample = true;
        }
        return multisampleAvailable;
    }

    private static String glXGetConfigErrorCode(int n2) {
        switch (n2) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 1: {
                return "GLX_BAD_SCREEN";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
            case 4: {
                return "GLX_BAD_VISUAL";
            }
        }
        return "Unknown error code " + n2;
    }

    public static int glXGetConfig(long l2, XVisualInfo xVisualInfo, int n2, int[] nArray, int n3) {
        if (l2 == 0L) {
            throw new GLException("No display connection");
        }
        int n4 = GLX.glXGetConfig(l2, xVisualInfo, n2, nArray, n3);
        if (n4 != 0) {
            throw new GLException("glXGetConfig failed: error code " + X11GLDrawableFactory.glXGetConfigErrorCode(n4));
        }
        return nArray[n3];
    }

    public static X11GLDrawableFactory getX11Factory() {
        return (X11GLDrawableFactory)X11GLDrawableFactory.getFactory();
    }

    public static boolean isVendorATI() {
        return isVendorATI;
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
            return;
        }
        runnable.run();
    }

    @Override
    public boolean canCreateContextOnJava2DSurface() {
        return false;
    }

    @Override
    public GLContext createContextOnJava2DSurface(Graphics graphics, GLContext gLContext) {
        throw new GLException("Unimplemented on this platform");
    }

    protected synchronized boolean isXineramaEnabled() {
        if (!this.checkedXinerama) {
            this.checkedXinerama = true;
            this.lockToolkit();
            long l2 = X11GLDrawableFactory.getDisplayConnection();
            this.xineramaEnabled = GLX.XineramaEnabled(l2);
            this.unlockToolkit();
        }
        return this.xineramaEnabled;
    }

    @Override
    protected synchronized int getGammaRampLength() {
        if (this.gotGammaRampLength) {
            return this.gammaRampLength;
        }
        int[] nArray = new int[1];
        this.lockToolkit();
        long l2 = X11GLDrawableFactory.getDisplayConnection();
        boolean bl = GLX.XF86VidModeGetGammaRampSize(l2, GLX.DefaultScreen(l2), nArray, 0);
        this.unlockToolkit();
        if (!bl) {
            return 0;
        }
        this.gotGammaRampLength = true;
        this.gammaRampLength = nArray[0];
        return this.gammaRampLength;
    }

    @Override
    protected boolean setGammaRamp(float[] fArray) {
        int n2 = fArray.length;
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = (short)(fArray[i2] * 65535.0f);
        }
        this.lockToolkit();
        long l2 = X11GLDrawableFactory.getDisplayConnection();
        boolean bl = GLX.XF86VidModeSetGammaRamp(l2, GLX.DefaultScreen(l2), sArray.length, sArray, 0, sArray, 0, sArray, 0);
        this.unlockToolkit();
        return bl;
    }

    @Override
    protected Buffer getGammaRamp() {
        int n2 = this.getGammaRampLength();
        ShortBuffer shortBuffer = ShortBuffer.allocate(3 * n2);
        shortBuffer.position(0);
        shortBuffer.limit(n2);
        ShortBuffer shortBuffer2 = shortBuffer.slice();
        shortBuffer.position(n2);
        shortBuffer.limit(2 * n2);
        ShortBuffer shortBuffer3 = shortBuffer.slice();
        shortBuffer.position(2 * n2);
        shortBuffer.limit(3 * n2);
        ShortBuffer shortBuffer4 = shortBuffer.slice();
        this.lockToolkit();
        long l2 = X11GLDrawableFactory.getDisplayConnection();
        n2 = GLX.XF86VidModeGetGammaRamp(l2, GLX.DefaultScreen(l2), n2, shortBuffer2, shortBuffer3, shortBuffer4) ? 1 : 0;
        this.unlockToolkit();
        if (n2 == 0) {
            return null;
        }
        return shortBuffer;
    }

    @Override
    protected void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        int n2 = (buffer = (ShortBuffer)buffer).capacity();
        if (n2 % 3 != 0) {
            throw new IllegalArgumentException("Must not be the original gamma ramp");
        }
        ((ShortBuffer)buffer).position(0);
        ((ShortBuffer)buffer).limit(n2 /= 3);
        ShortBuffer shortBuffer = ((ShortBuffer)buffer).slice();
        ((ShortBuffer)buffer).position(n2);
        ((ShortBuffer)buffer).limit(2 * n2);
        ShortBuffer shortBuffer2 = ((ShortBuffer)buffer).slice();
        ((ShortBuffer)buffer).position(2 * n2);
        ((ShortBuffer)buffer).limit(3 * n2);
        buffer = ((ShortBuffer)buffer).slice();
        this.lockToolkit();
        long l2 = X11GLDrawableFactory.getDisplayConnection();
        GLX.XF86VidModeSetGammaRamp(l2, GLX.DefaultScreen(l2), n2, shortBuffer, shortBuffer2, (ShortBuffer)buffer);
        this.unlockToolkit();
    }

    static /* synthetic */ boolean access$000() {
        return DEBUG;
    }

    static /* synthetic */ boolean access$102(X11GLDrawableFactory x11GLDrawableFactory, boolean bl) {
        x11GLDrawableFactory.canCreateGLPbuffer = bl;
        return x11GLDrawableFactory.canCreateGLPbuffer;
    }

    static /* synthetic */ boolean access$202(X11GLDrawableFactory x11GLDrawableFactory, boolean bl) {
        x11GLDrawableFactory.pbufferSupportInitialized = bl;
        return x11GLDrawableFactory.pbufferSupportInitialized;
    }

    static {
        visualToGLCapsMap = Collections.synchronizedMap(new HashMap());
        DRIHack.begin();
        NativeLibLoader.loadCore();
        DRIHack.end();
        isHeadless = GraphicsEnvironment.isHeadless();
    }
}

