/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WindowsGLContext;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsExternalGLContext
extends WindowsGLContext {
    private boolean firstMakeCurrent = true;
    private boolean created = true;
    private GLContext lastContext;

    public WindowsExternalGLContext() {
        super(null, null, true);
        this.hglrc = WGL.wglGetCurrentContext();
        if (this.hglrc == 0L) {
            throw new GLException("Error: attempted to make an external GLContext without a drawable/context current");
        }
        if (DEBUG) {
            System.err.println(new StringBuffer().append(WindowsExternalGLContext.getThreadName()).append(": !!! Created external OpenGL context ").append(WindowsExternalGLContext.toHexString(this.hglrc)).append(" for ").append(this).toString());
        }
        GLContextShareSet.contextCreated(this);
        this.resetGLFunctionAvailability();
    }

    @Override
    public int makeCurrent() {
        GLContext gLContext = WindowsExternalGLContext.getCurrent();
        if (gLContext != null && gLContext != this) {
            this.lastContext = gLContext;
            WindowsExternalGLContext.setCurrent(null);
        }
        return super.makeCurrent();
    }

    @Override
    public void release() {
        super.release();
        WindowsExternalGLContext.setCurrent(this.lastContext);
        this.lastContext = null;
    }

    @Override
    protected int makeCurrentImpl() {
        if (this.firstMakeCurrent) {
            this.firstMakeCurrent = false;
            return 2;
        }
        return 1;
    }

    @Override
    protected void releaseImpl() {
    }

    @Override
    protected void destroyImpl() {
        this.created = false;
        GLContextShareSet.contextDestroyed(this);
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }
}

