/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.packrect;

import com.sun.opengl.impl.packrect.BackingStoreManager;
import com.sun.opengl.impl.packrect.Level$RectXComparator;
import com.sun.opengl.impl.packrect.LevelSet;
import com.sun.opengl.impl.packrect.Rect;
import com.sun.opengl.impl.packrect.RectVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Level {
    private int width;
    private int height;
    private int yPos;
    private LevelSet holder;
    private List rects = new ArrayList();
    private List freeList;
    private int nextAddX;
    private static final Comparator rectXComparator = new Level$RectXComparator();

    public Level(int n2, int n3, int n4, LevelSet levelSet) {
        this.width = n2;
        this.height = n3;
        this.yPos = n4;
        this.holder = levelSet;
    }

    public int w() {
        return this.width;
    }

    public int h() {
        return this.height;
    }

    public int yPos() {
        return this.yPos;
    }

    public boolean add(Rect rect) {
        if (rect.h() > this.height) {
            if (this.nextAddX + rect.w() > this.width) {
                return false;
            }
            if (!this.holder.canExpand(this, rect.h())) {
                return false;
            }
            this.holder.expand(this, this.height, rect.h());
            this.height = rect.h();
        }
        if (this.nextAddX + rect.w() <= this.width) {
            rect.setPosition(this.nextAddX, this.yPos);
            this.rects.add(rect);
            this.nextAddX += rect.w();
            return true;
        }
        if (this.freeList != null) {
            Rect rect2 = null;
            for (Rect rect3 : this.freeList) {
                if (!rect3.canContain(rect)) continue;
                rect2 = rect3;
                break;
            }
            if (rect2 != null) {
                this.freeList.remove(rect2);
                rect.setPosition(rect2.x(), rect2.y());
                this.rects.add(rect);
                if (rect2.w() > rect.w()) {
                    rect2.setPosition(rect2.x() + rect.w(), rect2.y());
                    rect2.setSize(rect2.w() - rect.w(), this.height);
                    this.freeList.add(rect2);
                }
                this.coalesceFreeList();
                return true;
            }
        }
        return false;
    }

    public boolean remove(Rect rect) {
        if (!this.rects.remove(rect)) {
            return false;
        }
        if (rect.maxX() + 1 == this.nextAddX) {
            this.nextAddX -= rect.w();
        } else {
            if (this.freeList == null) {
                this.freeList = new ArrayList();
            }
            this.freeList.add(new Rect(rect.x(), rect.y(), rect.w(), this.height, null));
            this.coalesceFreeList();
        }
        return true;
    }

    public boolean isEmpty() {
        return this.rects.isEmpty();
    }

    public boolean couldAllocateIfCompacted(Rect rect) {
        if (rect.h() > this.height) {
            return false;
        }
        if (this.freeList == null) {
            return false;
        }
        int n2 = 0;
        for (Rect rect2 : this.freeList) {
            n2 += rect2.w();
        }
        return n2 + (this.width - this.nextAddX) >= rect.w();
    }

    public void compact(Object object, BackingStoreManager backingStoreManager) {
        Collections.sort(this.rects, rectXComparator);
        int n2 = 0;
        backingStoreManager.beginMovement(object, object);
        for (Rect rect : this.rects) {
            if (rect.x() != n2) {
                backingStoreManager.move(object, rect, object, new Rect(n2, rect.y(), rect.w(), rect.h(), null));
                rect.setPosition(n2, rect.y());
            }
            n2 += rect.w();
        }
        this.nextAddX = n2;
        this.freeList.clear();
        backingStoreManager.endMovement(object, object);
    }

    public Iterator iterator() {
        return this.rects.iterator();
    }

    public void visit(RectVisitor rectVisitor) {
        for (Rect rect : this.rects) {
            rectVisitor.visit(rect);
        }
    }

    public void updateRectangleReferences() {
        for (int i2 = 0; i2 < this.rects.size(); ++i2) {
            Rect rect = (Rect)this.rects.get(i2);
            Rect rect2 = rect.getNextLocation();
            rect2.setPosition(rect.x(), rect.y());
            if (rect.w() != rect2.w() || rect.h() != rect2.h()) {
                throw new RuntimeException("Unexpected disparity in rectangle sizes during updateRectangleReferences");
            }
            this.rects.set(i2, rect2);
        }
    }

    private void coalesceFreeList() {
        Rect rect;
        if (this.freeList == null) {
            return;
        }
        if (this.freeList.isEmpty()) {
            return;
        }
        Collections.sort(this.freeList, rectXComparator);
        int n2 = 0;
        while (n2 < this.freeList.size() - 1) {
            rect = (Rect)this.freeList.get(n2);
            Rect rect2 = (Rect)this.freeList.get(n2 + 1);
            if (rect.maxX() + 1 == rect2.x()) {
                this.freeList.remove(n2 + 1);
                rect.setSize(rect.w() + rect2.w(), rect.h());
                continue;
            }
            ++n2;
        }
        rect = (Rect)this.freeList.get(this.freeList.size() - 1);
        if (rect.maxX() + 1 == this.nextAddX) {
            this.nextAddX -= rect.w();
            this.freeList.remove(this.freeList.size() - 1);
        }
        if (this.freeList.isEmpty()) {
            this.freeList = null;
        }
    }

    public void dumpFreeSpace() {
        int n2 = 0;
        for (Rect rect : this.freeList) {
            System.err.println(new StringBuffer(" Free rectangle at ").append(rect).toString());
            n2 += rect.w();
        }
        System.err.println(new StringBuffer(" Remaining free space ").append(this.width - this.nextAddX).toString());
        System.err.println(new StringBuffer(" Total free space ").append(n2 += this.width - this.nextAddX).toString());
    }
}

