/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.nurbs;

import com.sun.opengl.impl.nurbs.Backend;
import com.sun.opengl.impl.nurbs.CArrayOfFloats;

class Mapdesc {
    private static final int MAXCOORDS = 5;
    public Mapdesc next;
    public int isrational;
    public int ncoords;
    private int type;
    private int hcoords;
    private int inhcoords;
    private int mask;
    private float pixel_tolerance;
    private float error_tolerance;
    private float bbox_subdividing;
    private float culling_method;
    private float sampling_method;
    float clampfactor;
    private float minsavings;
    private float s_steps;
    private float t_steps;
    float maxrate;
    private float maxsrate;
    private float maxtrate;
    private float[][] bmat;
    private float[][] smat;
    private float[][] cmat;
    private float[] bboxsize;
    static final boolean $assertionsDisabled = !(class$com$sun$opengl$impl$nurbs$Mapdesc == null ? (class$com$sun$opengl$impl$nurbs$Mapdesc = Mapdesc.class$("com.sun.opengl.impl.nurbs.Mapdesc")) : class$com$sun$opengl$impl$nurbs$Mapdesc).desiredAssertionStatus();
    static Class class$com$sun$opengl$impl$nurbs$Mapdesc;

    public Mapdesc(int n2, int n3, int n4, Backend backend) {
        this.type = n2;
        this.isrational = n3;
        this.ncoords = n4;
        this.hcoords = n4 + (this.isrational > 0 ? 0 : 1);
        this.inhcoords = n4 - (this.isrational > 0 ? 1 : 0);
        this.mask = (1 << (this.inhcoords << 1)) - 1;
        this.next = null;
        if (!$assertionsDisabled && this.hcoords > 5) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inhcoords <= 0) {
            throw new AssertionError();
        }
        this.pixel_tolerance = 1.0f;
        this.error_tolerance = 1.0f;
        this.bbox_subdividing = 0.0f;
        this.culling_method = 0.0f;
        this.sampling_method = 0.0f;
        this.clampfactor = 0.0f;
        this.minsavings = 0.0f;
        this.s_steps = 0.0f;
        this.t_steps = 0.0f;
        this.maxrate = this.s_steps < 0.0f ? 0.0f : this.s_steps;
        this.maxsrate = this.s_steps < 0.0f ? 0.0f : this.s_steps;
        this.maxtrate = this.t_steps < 0.0f ? 0.0f : this.t_steps;
        this.bmat = new float[5][5];
        this.cmat = new float[5][5];
        this.smat = new float[5][5];
        this.identify(this.bmat);
        this.identify(this.cmat);
        this.identify(this.smat);
        this.bboxsize = new float[5];
        for (n2 = 0; n2 < this.inhcoords; ++n2) {
            this.bboxsize[n2] = 1.0f;
        }
    }

    private void identify(float[][] fArray) {
        int n2;
        for (n2 = 0; n2 < 5; ++n2) {
            for (int i2 = 0; i2 < 5; ++i2) {
                fArray[n2][i2] = 0.0f;
            }
        }
        for (n2 = 0; n2 < 5; ++n2) {
            fArray[n2][n2] = 1.0f;
        }
    }

    public boolean isProperty(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2 != 0;
    }

    public int getNCoords() {
        return this.ncoords;
    }

    public int getType() {
        return this.type;
    }

    public boolean isRangeSampling() {
        return this.isParametricDistanceSampling() || this.isPathLengthSampling() || this.isSurfaceAreaSampling() || this.isObjectSpaceParaSampling() || this.isObjectSpacePathSampling();
    }

    private boolean isObjectSpacePathSampling() {
        return this.sampling_method == 9.0f;
    }

    private boolean isObjectSpaceParaSampling() {
        return this.sampling_method == 8.0f;
    }

    private boolean isSurfaceAreaSampling() {
        return this.sampling_method == 7.0f;
    }

    boolean isPathLengthSampling() {
        return this.sampling_method == 6.0f;
    }

    boolean isParametricDistanceSampling() {
        return this.sampling_method == 5.0f;
    }

    public boolean isCulling() {
        return this.culling_method != 0.0f;
    }

    public boolean isConstantSampling() {
        return this.sampling_method == 3.0f;
    }

    public boolean isDomainSampling() {
        return this.sampling_method == 2.0f;
    }

    public float getProperty(int n2) {
        return 0.0f;
    }

    public void setProperty(int n2, float f2) {
        switch (n2) {
            case 1: {
                this.pixel_tolerance = f2;
                return;
            }
            case 20: {
                this.error_tolerance = f2;
                return;
            }
            case 2: {
                this.culling_method = f2;
                return;
            }
            case 17: {
                if (f2 <= 0.0f) {
                    f2 = 0.0f;
                }
                this.bbox_subdividing = f2;
                return;
            }
            case 6: {
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                this.s_steps = f2;
                this.maxrate = f2;
                this.maxsrate = f2;
                return;
            }
            case 7: {
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                this.t_steps = f2;
                this.maxtrate = f2;
                return;
            }
            case 10: {
                this.sampling_method = f2;
                return;
            }
            case 13: {
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                this.clampfactor = f2;
                return;
            }
            case 14: {
                if (f2 <= 0.0f) {
                    f2 = 0.0f;
                }
                this.minsavings = f2;
            }
        }
    }

    public void xformSampling(CArrayOfFloats cArrayOfFloats, int n2, int n3, float[] fArray, int n4) {
        this.xFormMat(this.smat, cArrayOfFloats, n2, n3, fArray, n4);
    }

    private void xFormMat(float[][] fArray, CArrayOfFloats cArrayOfFloats, int n2, int n3, float[] fArray2, int n4) {
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

