/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.mipmap;

import com.sun.opengl.impl.mipmap.BuildMipmap;
import com.sun.opengl.impl.mipmap.Image;
import com.sun.opengl.impl.mipmap.PixelStorageModes;
import com.sun.opengl.impl.mipmap.ScaleInternal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public class Mipmap {
    public static int computeLog(int n2) {
        int n3 = 0;
        if (n2 == 0) {
            return -1;
        }
        while (true) {
            if ((n2 & 1) > 0) {
                if (n2 != 1) {
                    return -1;
                }
                return n3;
            }
            n2 >>= 1;
            ++n3;
        }
    }

    public static int nearestPower(int n2) {
        int n3 = 1;
        if (n2 == 0) {
            return -1;
        }
        while (n2 != 1) {
            if (n2 == 3) {
                return n3 << 2;
            }
            n2 >>= 1;
            n3 <<= 1;
        }
        return n3;
    }

    public static short GLU_SWAP_2_BYTES(short s) {
        byte by = (byte)(s >>> 8);
        return (short)((short)(s << 8) | 0xFF & by);
    }

    public static int GLU_SWAP_4_BYTES(int n2) {
        return n2 << 24 | 0xFF0000 & n2 << 8 | 0xFF00 & n2 >>> 8 | 0xFF & n2 >>> 24;
    }

    public static float GLU_SWAP_4_BYTES(float f2) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(f2));
    }

    public static int checkMipmapArgs(int n2, int n3, int n4) {
        if (!Mipmap.legalFormat(n3) || !Mipmap.legalType(n4)) {
            return 100900;
        }
        if (n3 == 6401) {
            return 100900;
        }
        if (!Mipmap.isLegalFormatForPackedPixelType(n3, n4)) {
            return 100904;
        }
        return 0;
    }

    public static boolean legalFormat(int n2) {
        switch (n2) {
            case 6400: 
            case 6401: 
            case 6402: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6407: 
            case 6408: 
            case 6409: 
            case 6410: 
            case 32992: 
            case 32993: {
                return true;
            }
        }
        return false;
    }

    public static boolean legalType(int n2) {
        switch (n2) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5124: 
            case 5125: 
            case 5126: 
            case 6656: 
            case 32818: 
            case 32819: 
            case 32820: 
            case 32821: 
            case 32822: 
            case 33634: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: 
            case 33639: 
            case 33640: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTypePackedPixel(int n2) {
        assert (Mipmap.legalType(n2));
        return n2 == 32818 || n2 == 33634 || n2 == 33635 || n2 == 33636 || n2 == 32819 || n2 == 33637 || n2 == 32820 || n2 == 33638 || n2 == 32821 || n2 == 33639 || n2 == 32822 || n2 == 33640;
    }

    public static boolean isLegalFormatForPackedPixelType(int n2, int n3) {
        if (Mipmap.isTypePackedPixel(n3)) {
            return true;
        }
        if ((n3 == 32818 || n3 == 33634 || n3 == 33635 || n3 == 33636) & n2 != 6407) {
            return false;
        }
        return n3 != 32819 && n3 != 33637 && n3 != 32820 && n3 != 33638 && n3 != 32821 && n3 != 33639 && n3 != 32822 && n3 != 33640 || n2 == 6408 || n2 == 32993;
    }

    public static boolean isLegalLevels(int n2, int n3, int n4, int n5) {
        return n3 >= 0 && n3 >= n2 && n4 >= n3 && n5 >= n4;
    }

    public static void closestFit(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2) {
        if (Double.parseDouble(gL.glGetString(7938).trim().substring(0, 3)) >= 1.1) {
            int n8 = Mipmap.nearestPower(n3);
            int n9 = Mipmap.nearestPower(n4);
            int[] nArray3 = new int[1];
            boolean bl = false;
            try {
                do {
                    int n10;
                    int n11;
                    int n12 = n3 > 1 ? n8 >> 1 : n8;
                    int n13 = n11 = n4 > 1 ? n9 >> 1 : n9;
                    assert (n12 > 0);
                    assert (n11 > 0);
                    if (n2 == 3553 || n2 == 32868) {
                        n10 = 32868;
                        gL.glTexImage2D(32868, 1, n5, n12, n11, 0, n6, n7, null);
                    } else if (n2 == 34069 || n2 == 34070 || n2 == 34071 || n2 == 34072 || n2 == 34073 || n2 == 34074) {
                        n10 = 34075;
                        gL.glTexImage2D(34075, 1, n5, n12, n11, 0, n6, n7, null);
                    } else {
                        assert (n2 == 3552 || n2 == 32867);
                        n10 = 32867;
                        gL.glTexImage1D(32867, 1, n5, n12, 0, n6, n7, null);
                    }
                    gL.glGetTexLevelParameteriv(n10, 1, 4096, nArray3, 0);
                    if (nArray3[0] != 0) continue;
                    if (n8 == 1 && n9 == 1) {
                        bl = true;
                        break;
                    }
                    n8 = n12;
                    n9 = n11;
                } while (nArray3[0] == 0);
            }
            catch (GLException gLException) {
                bl = true;
            }
            if (!bl) {
                nArray[0] = n8;
                nArray2[0] = n9;
                return;
            }
        }
        int[] nArray4 = new int[1];
        gL.glGetIntegerv(3379, nArray4, 0);
        nArray[0] = Mipmap.nearestPower(n3);
        if (nArray[0] > nArray4[0]) {
            nArray[0] = nArray4[0];
        }
        nArray2[0] = Mipmap.nearestPower(n4);
        if (nArray2[0] > nArray4[0]) {
            nArray2[0] = nArray4[0];
        }
    }

    public static void closestFit3D(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, int[] nArray2, int[] nArray3) {
        n3 = Mipmap.nearestPower(n3);
        n4 = Mipmap.nearestPower(n4);
        n5 = Mipmap.nearestPower(n5);
        int[] nArray4 = new int[1];
        do {
            int n9 = n3 > 1 ? n3 >> 1 : n3;
            int n10 = n4 > 1 ? n4 >> 1 : n4;
            int n11 = n5 > 1 ? n5 >> 1 : n5;
            int n12 = 0;
            assert (n9 > 0);
            assert (n10 > 0);
            assert (n11 > 0);
            if (n2 == 32879 || n2 == 32880) {
                n12 = 32880;
                gL.glTexImage3D(32880, 1, n6, n9, n10, n11, 0, n7, n8, null);
            }
            gL.glGetTexLevelParameteriv(n12, 1, 4096, nArray4, 0);
            if (nArray4[0] != 0) continue;
            if (n3 == 1 && n4 == 1 && n5 == 1) {
                nArray3[0] = 1;
                nArray2[0] = 1;
                nArray[0] = 1;
                return;
            }
            n3 = n9;
            n4 = n10;
            n5 = n11;
        } while (nArray4[0] == 0);
        nArray[0] = n3;
        nArray2[0] = n4;
        nArray3[0] = n5;
    }

    public static int elements_per_group(int n2, int n3) {
        if (n3 == 32818 || n3 == 33634 || n3 == 33635 || n3 == 33636 || n3 == 32819 || n3 == 33637 || n3 == 32820 || n3 == 33638 || n3 == 32821 || n3 == 33639 || n3 == 32822 || n3 == 33640) {
            return 1;
        }
        switch (n2) {
            case 6407: 
            case 32992: {
                return 3;
            }
            case 6410: {
                return 2;
            }
            case 6408: 
            case 32993: {
                return 4;
            }
        }
        return 1;
    }

    public static int bytes_per_element(int n2) {
        switch (n2) {
            case 5120: 
            case 5121: 
            case 6656: 
            case 32818: 
            case 33634: {
                return 1;
            }
            case 5122: 
            case 5123: 
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: {
                return 2;
            }
            case 5124: 
            case 5125: 
            case 5126: 
            case 32821: 
            case 32822: 
            case 33639: 
            case 33640: {
                return 4;
            }
        }
        return 4;
    }

    public static boolean is_index(int n2) {
        return n2 == 6400 || n2 == 6401;
    }

    public static int image_size(int n2, int n3, int n4, int n5) {
        assert (n2 > 0);
        assert (n3 > 0);
        n4 = Mipmap.elements_per_group(n4, n5);
        n2 = n5 == 6656 ? (n2 + 7) / 8 : Mipmap.bytes_per_element(n5) * n2;
        return n2 * n3 * n4;
    }

    public static int imageSize3D(int n2, int n3, int n4, int n5, int n6) {
        n5 = Mipmap.elements_per_group(n5, n6);
        int n7 = Mipmap.bytes_per_element(n6) * n2;
        assert (n2 > 0 && n3 > 0 && n4 > 0);
        assert (n6 != 6656);
        return n7 * n3 * n4 * n5;
    }

    public static void retrieveStoreModes(GL gL, PixelStorageModes pixelStorageModes) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(3317, nArray, 0);
        pixelStorageModes.setUnpackAlignment(nArray[0]);
        gL.glGetIntegerv(3314, nArray, 0);
        pixelStorageModes.setUnpackRowLength(nArray[0]);
        gL.glGetIntegerv(3315, nArray, 0);
        pixelStorageModes.setUnpackSkipRows(nArray[0]);
        gL.glGetIntegerv(3316, nArray, 0);
        pixelStorageModes.setUnpackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3313, nArray, 0);
        pixelStorageModes.setUnpackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3312, nArray, 0);
        pixelStorageModes.setUnpackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(3333, nArray, 0);
        pixelStorageModes.setPackAlignment(nArray[0]);
        gL.glGetIntegerv(3330, nArray, 0);
        pixelStorageModes.setPackRowLength(nArray[0]);
        gL.glGetIntegerv(3331, nArray, 0);
        pixelStorageModes.setPackSkipRows(nArray[0]);
        gL.glGetIntegerv(3332, nArray, 0);
        pixelStorageModes.setPackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3329, nArray, 0);
        pixelStorageModes.setPackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3328, nArray, 0);
        pixelStorageModes.setPackSwapBytes(nArray[0] == 1);
    }

    public static void retrieveStoreModes3D(GL gL, PixelStorageModes pixelStorageModes) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(3317, nArray, 0);
        pixelStorageModes.setUnpackAlignment(nArray[0]);
        gL.glGetIntegerv(3314, nArray, 0);
        pixelStorageModes.setUnpackRowLength(nArray[0]);
        gL.glGetIntegerv(3315, nArray, 0);
        pixelStorageModes.setUnpackSkipRows(nArray[0]);
        gL.glGetIntegerv(3316, nArray, 0);
        pixelStorageModes.setUnpackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3313, nArray, 0);
        pixelStorageModes.setUnpackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3312, nArray, 0);
        pixelStorageModes.setUnpackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(32877, nArray, 0);
        pixelStorageModes.setUnpackSkipImages(nArray[0]);
        gL.glGetIntegerv(32878, nArray, 0);
        pixelStorageModes.setUnpackImageHeight(nArray[0]);
        gL.glGetIntegerv(3333, nArray, 0);
        pixelStorageModes.setPackAlignment(nArray[0]);
        gL.glGetIntegerv(3330, nArray, 0);
        pixelStorageModes.setPackRowLength(nArray[0]);
        gL.glGetIntegerv(3331, nArray, 0);
        pixelStorageModes.setPackSkipRows(nArray[0]);
        gL.glGetIntegerv(3332, nArray, 0);
        pixelStorageModes.setPackSkipPixels(nArray[0]);
        gL.glGetIntegerv(3329, nArray, 0);
        pixelStorageModes.setPackLsbFirst(nArray[0] == 1);
        gL.glGetIntegerv(3328, nArray, 0);
        pixelStorageModes.setPackSwapBytes(nArray[0] == 1);
        gL.glGetIntegerv(32875, nArray, 0);
        pixelStorageModes.setPackSkipImages(nArray[0]);
        gL.glGetIntegerv(32876, nArray, 0);
        pixelStorageModes.setPackImageHeight(nArray[0]);
    }

    public static int gluScaleImage(GL gL, int n2, int n3, int n4, int n5, ByteBuffer byteBuffer, int n6, int n7, int n8, ByteBuffer byteBuffer2) {
        PixelStorageModes pixelStorageModes;
        int n9;
        int n10;
        block13: {
            n10 = byteBuffer.position();
            n9 = byteBuffer2.position();
            pixelStorageModes = new PixelStorageModes();
            if (n3 != 0 && n4 != 0 && n6 != 0 && n7 != 0) break block13;
            byteBuffer.position(n10);
            byteBuffer2.position(n9);
            return 0;
        }
        if (n3 < 0 || n4 < 0 || n6 < 0 || n7 < 0) {
            byteBuffer.position(n10);
            byteBuffer2.position(n9);
            return 100901;
        }
        try {
            if (!(Mipmap.legalFormat(n2) && Mipmap.legalType(n5) && Mipmap.legalType(n8))) {
                return 100900;
            }
            if (!Mipmap.isLegalFormatForPackedPixelType(n2, n5)) {
                return 100904;
            }
            if (!Mipmap.isLegalFormatForPackedPixelType(n2, n8)) {
                return 100904;
            }
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(Mipmap.image_size(n3, n4, n2, 5123)).order(ByteOrder.nativeOrder());
            ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(Mipmap.image_size(n6, n7, n2, 5123)).order(ByteOrder.nativeOrder());
            if (byteBuffer3 == null || byteBuffer4 == null) {
                return 100902;
            }
            Mipmap.retrieveStoreModes(gL, pixelStorageModes);
            Image.fill_image(pixelStorageModes, n3, n4, n2, n5, Mipmap.is_index(n2), byteBuffer, byteBuffer3.asShortBuffer());
            ScaleInternal.scale_internal(Mipmap.elements_per_group(n2, 0), n3, n4, byteBuffer3.asShortBuffer(), n6, n7, byteBuffer4.asShortBuffer());
            Image.empty_image(pixelStorageModes, n6, n7, n2, n8, Mipmap.is_index(n2), byteBuffer4.asShortBuffer(), byteBuffer2);
            return 0;
        }
        finally {
            byteBuffer.position(n10);
            byteBuffer2.position(n9);
        }
    }

    public static int gluBuild1DMipmapLevels(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ByteBuffer byteBuffer) {
        int n10;
        int n11;
        block7: {
            n11 = byteBuffer.position();
            n10 = Mipmap.checkMipmapArgs(n3, n5, n6);
            if (n10 == 0) break block7;
            byteBuffer.position(n11);
            return n10;
        }
        if (n4 <= 0) {
            byteBuffer.position(n11);
            return 100901;
        }
        try {
            n10 = Mipmap.computeLog(n4) + n7;
            if (!Mipmap.isLegalLevels(n7, n8, n9, n10)) {
                return 100901;
            }
            int n12 = BuildMipmap.gluBuild1DMipmapLevelsCore(gL, n2, n3, n4, n4, n5, n6, n7, n8, n9, byteBuffer);
            return n12;
        }
        finally {
            byteBuffer.position(n11);
        }
    }

    public static int gluBuild1DMipmaps(GL gL, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        int[] nArray;
        int[] nArray2;
        int n7;
        block5: {
            n7 = byteBuffer.position();
            nArray2 = new int[1];
            nArray = new int[1];
            int n8 = Mipmap.checkMipmapArgs(n3, n5, n6);
            if (n8 == 0) break block5;
            byteBuffer.position(n7);
            return n8;
        }
        if (n4 <= 0) {
            byteBuffer.position(n7);
            return 100901;
        }
        try {
            Mipmap.closestFit(gL, n2, n4, 1, n3, n5, n6, nArray2, nArray);
            int n9 = Mipmap.computeLog(nArray2[0]);
            int n10 = BuildMipmap.gluBuild1DMipmapLevelsCore(gL, n2, n3, n4, nArray2[0], n5, n6, 0, 0, n9, byteBuffer);
            return n10;
        }
        finally {
            byteBuffer.position(n7);
        }
    }

    public static int gluBuild2DMipmapLevels(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object) {
        int n11 = 0;
        int n12 = Mipmap.checkMipmapArgs(n3, n6, n7);
        if (n12 != 0) {
            return n12;
        }
        if (n4 <= 0 || n5 <= 0) {
            return 100901;
        }
        int n13 = Mipmap.computeLog(n4);
        n12 = Mipmap.computeLog(n5);
        if (n12 > n13) {
            n13 = n12;
        }
        if (!Mipmap.isLegalLevels(n8, n9, n10, n13 += n8)) {
            return 100901;
        }
        ByteBuffer byteBuffer = null;
        if (object instanceof ByteBuffer) {
            byteBuffer = (ByteBuffer)object;
            n11 = byteBuffer.position();
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            object = byArray;
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.put((byte[])object);
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            object = sArray;
            byteBuffer = ByteBuffer.allocateDirect(sArray.length << 1);
            byteBuffer.asShortBuffer().put((short[])object);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            object = nArray;
            byteBuffer = ByteBuffer.allocateDirect(nArray.length << 2);
            byteBuffer.asIntBuffer().put((int[])object);
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            object = fArray;
            byteBuffer = ByteBuffer.allocateDirect(fArray.length << 2);
            byteBuffer.asFloatBuffer().put((float[])object);
        }
        try {
            int n14 = BuildMipmap.gluBuild2DMipmapLevelsCore(gL, n2, n3, n4, n5, n4, n5, n6, n7, n8, n9, n10, byteBuffer);
            return n14;
        }
        finally {
            byteBuffer.position(n11);
        }
    }

    public static int gluBuild2DMipmaps(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        int n8 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n9 = Mipmap.checkMipmapArgs(n3, n6, n7);
        if (n9 != 0) {
            return n9;
        }
        if (n4 <= 0 || n5 <= 0) {
            return 100901;
        }
        Mipmap.closestFit(gL, n2, n4, n5, n3, n6, n7, nArray, nArray2);
        int n10 = Mipmap.computeLog(nArray[0]);
        n9 = Mipmap.computeLog(nArray2[0]);
        if (n9 > n10) {
            n10 = n9;
        }
        ByteBuffer byteBuffer = null;
        if (object instanceof ByteBuffer) {
            byteBuffer = (ByteBuffer)object;
            n8 = byteBuffer.position();
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            object = byArray;
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.put((byte[])object);
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            object = sArray;
            byteBuffer = ByteBuffer.allocateDirect(sArray.length << 1);
            byteBuffer.asShortBuffer().put((short[])object);
        } else if (object instanceof int[]) {
            int[] nArray3 = (int[])object;
            object = nArray3;
            byteBuffer = ByteBuffer.allocateDirect(nArray3.length << 2);
            byteBuffer.asIntBuffer().put((int[])object);
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            object = fArray;
            byteBuffer = ByteBuffer.allocateDirect(fArray.length << 2);
            byteBuffer.asFloatBuffer().put((float[])object);
        }
        try {
            int n11 = BuildMipmap.gluBuild2DMipmapLevelsCore(gL, n2, n3, n4, n5, nArray[0], nArray2[0], n6, n7, 0, 0, n10, byteBuffer);
            return n11;
        }
        finally {
            byteBuffer.position(n8);
        }
    }

    public static int gluBuild3DMipmaps(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        int n9;
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int n10;
        block8: {
            n10 = byteBuffer.position();
            nArray3 = new int[1];
            nArray2 = new int[1];
            nArray = new int[1];
            n9 = Mipmap.checkMipmapArgs(n3, n7, n8);
            if (n9 == 0) break block8;
            byteBuffer.position(n10);
            return n9;
        }
        if (n4 <= 0 || n5 <= 0 || n6 <= 0) {
            byteBuffer.position(n10);
            return 100901;
        }
        if (n8 == 6656) {
            byteBuffer.position(n10);
            return 100900;
        }
        try {
            Mipmap.closestFit3D(gL, n2, n4, n5, n6, n3, n7, n8, nArray3, nArray2, nArray);
            int n11 = Mipmap.computeLog(nArray3[0]);
            n9 = Mipmap.computeLog(nArray2[0]);
            if (n9 > n11) {
                n11 = n9;
            }
            if ((n9 = Mipmap.computeLog(nArray[0])) > n11) {
                n11 = n9;
            }
            int n12 = BuildMipmap.gluBuild3DMipmapLevelsCore(gL, n2, n3, n4, n5, n6, nArray3[0], nArray2[0], nArray[0], n7, n8, 0, 0, n11, byteBuffer);
            return n12;
        }
        finally {
            byteBuffer.position(n10);
        }
    }

    public static int gluBuild3DMipmapLevels(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, ByteBuffer byteBuffer) {
        int n12;
        int n13;
        block10: {
            n13 = byteBuffer.position();
            n12 = Mipmap.checkMipmapArgs(n3, n7, n8);
            if (n12 == 0) break block10;
            byteBuffer.position(n13);
            return n12;
        }
        if (n4 <= 0 || n5 <= 0 || n6 <= 0) {
            byteBuffer.position(n13);
            return 100901;
        }
        if (n8 == 6656) {
            byteBuffer.position(n13);
            return 100900;
        }
        try {
            int n14 = Mipmap.computeLog(n4);
            n12 = Mipmap.computeLog(n5);
            if (n12 > n14) {
                n14 = n12;
            }
            if ((n12 = Mipmap.computeLog(n6)) > n14) {
                n14 = n12;
            }
            if (!Mipmap.isLegalLevels(n9, n10, n11, n14 += n9)) {
                return 100901;
            }
            int n15 = BuildMipmap.gluBuild3DMipmapLevelsCore(gL, n2, n3, n4, n5, n6, n4, n5, n6, n7, n8, n9, n10, n11, byteBuffer);
            return n15;
        }
        finally {
            byteBuffer.position(n13);
        }
    }
}

