/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.Java2D$1;
import com.sun.opengl.impl.Java2D$2;
import com.sun.opengl.impl.Java2D$3;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class Java2D {
    private static boolean DEBUG = Debug.debug("Java2D");
    private static boolean VERBOSE = Debug.verbose();
    private static boolean isHeadless;
    private static boolean isOGLPipelineActive;
    private static Method invokeWithOGLContextCurrentMethod;
    private static Method isQueueFlusherThreadMethod;
    private static Method getOGLViewportMethod;
    private static Method getOGLScissorBoxMethod;
    private static Method getOGLSurfaceIdentifierMethod;
    private static Method getOGLTextureTypeMethod;
    private static boolean fbObjectSupportInitialized;
    private static Method invokeWithOGLSharedContextCurrentMethod;
    private static Method getOGLSurfaceTypeMethod;
    public static final int UNDEFINED;
    public static final int WINDOW;
    public static final int PBUFFER;
    public static final int TEXTURE;
    public static final int FLIP_BACKBUFFER;
    public static final int FBOBJECT;
    private static boolean initializedJ2DFBOShareContext;
    private static GLContext j2dFBOShareContext;
    private static Method createOGLContextOnSurfaceMethod;
    private static Method makeOGLContextCurrentOnSurfaceMethod;
    private static Method destroyOGLContextMethod;
    static Class class$java$awt$Graphics;
    static Class class$java$lang$Runnable;
    static Class class$java$awt$GraphicsConfiguration;

    public static boolean isOGLPipelineActive() {
        return isOGLPipelineActive;
    }

    public static boolean isFBOEnabled() {
        return fbObjectSupportInitialized;
    }

    public static boolean isQueueFlusherThread() {
        Java2D.checkActive();
        try {
            return (Boolean)isQueueFlusherThreadMethod.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static void invokeWithOGLContextCurrent(Graphics graphics, Runnable runnable) {
        Java2D.checkActive();
        try {
            Java2D.initFBOShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            GLDrawableFactoryImpl.getFactoryImpl().lockAWTForJava2D();
            try {
                invokeWithOGLContextCurrentMethod.invoke(null, graphics, runnable);
                return;
            }
            finally {
                GLDrawableFactoryImpl.getFactoryImpl().unlockAWTForJava2D();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static boolean invokeWithOGLSharedContextCurrent(GraphicsConfiguration graphicsConfiguration, Runnable runnable) {
        Java2D.checkActive();
        GLDrawableFactoryImpl.getFactoryImpl().lockAWTForJava2D();
        try {
            boolean bl = (Boolean)invokeWithOGLSharedContextCurrentMethod.invoke(null, graphicsConfiguration, runnable);
            GLDrawableFactoryImpl.getFactoryImpl().unlockAWTForJava2D();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                GLDrawableFactoryImpl.getFactoryImpl().unlockAWTForJava2D();
                throw throwable;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw (InternalError)new InternalError().initCause(exception);
            }
        }
    }

    public static Rectangle getOGLViewport(Graphics graphics, int n2, int n3) {
        Java2D.checkActive();
        try {
            return (Rectangle)getOGLViewportMethod.invoke(null, graphics, new Integer(n2), new Integer(n3));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static Rectangle getOGLScissorBox(Graphics graphics) {
        Java2D.checkActive();
        try {
            return (Rectangle)getOGLScissorBoxMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static Object getOGLSurfaceIdentifier(Graphics graphics) {
        Java2D.checkActive();
        try {
            return getOGLSurfaceIdentifierMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static int getOGLSurfaceType(Graphics graphics) {
        Java2D.checkActive();
        try {
            if (!fbObjectSupportInitialized) {
                return 0;
            }
            return (Integer)getOGLSurfaceTypeMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static int getOGLTextureType(Graphics graphics) {
        Java2D.checkActive();
        if (getOGLTextureTypeMethod == null) {
            return 3553;
        }
        try {
            return (Integer)getOGLTextureTypeMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static GLContext filterShareContext(GLContext gLContext) {
        if (isHeadless) {
            return gLContext;
        }
        Java2D.initFBOShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        if (j2dFBOShareContext != null) {
            return j2dFBOShareContext;
        }
        return gLContext;
    }

    public static GLContext getShareContext(GraphicsConfiguration graphicsConfiguration) {
        Java2D.initFBOShareContext(graphicsConfiguration);
        return j2dFBOShareContext;
    }

    public static long createOGLContextOnSurface(Graphics graphics, long l2) {
        Java2D.checkActive();
        try {
            return (Long)createOGLContextOnSurfaceMethod.invoke(null, graphics, new Long(l2));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static boolean makeOGLContextCurrentOnSurface(Graphics graphics, long l2) {
        Java2D.checkActive();
        try {
            return (Boolean)makeOGLContextCurrentOnSurfaceMethod.invoke(null, graphics, new Long(l2));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static void destroyOGLContext(long l2) {
        Java2D.checkActive();
        try {
            destroyOGLContextMethod.invoke(null, new Long(l2));
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    private static void checkActive() {
        if (!Java2D.isOGLPipelineActive()) {
            throw new GLException("Java2D OpenGL pipeline not active (or necessary support not present)");
        }
    }

    private static int getOGLUtilitiesIntField(String string) {
        Integer n2 = (Integer)AccessController.doPrivileged(new Java2D$2(string));
        if (n2 == null) {
            return 0;
        }
        if (DEBUG && VERBOSE) {
            System.err.println(new StringBuffer("OGLUtilities.").append(string).append(" = ").append(n2).toString());
        }
        return n2;
    }

    private static void initFBOShareContext(GraphicsConfiguration graphicsConfiguration) {
        if (Java2D.isOGLPipelineActive() && Java2D.isFBOEnabled() && !initializedJ2DFBOShareContext) {
            initializedJ2DFBOShareContext = true;
            if (DEBUG) {
                System.err.println("Starting initialization of J2D FBO share context");
            }
            Java2D.invokeWithOGLSharedContextCurrent(graphicsConfiguration, new Java2D$3());
            if (DEBUG) {
                System.err.println("Ending initialization of J2D FBO share context");
            }
        }
    }

    static boolean access$000() {
        return DEBUG;
    }

    static boolean access$100() {
        return VERBOSE;
    }

    static boolean access$202(boolean bl) {
        isHeadless = bl;
        return isHeadless;
    }

    static boolean access$302(boolean bl) {
        isOGLPipelineActive = bl;
        return isOGLPipelineActive;
    }

    static boolean access$300() {
        return isOGLPipelineActive;
    }

    static Method access$402(Method method) {
        invokeWithOGLContextCurrentMethod = method;
        return invokeWithOGLContextCurrentMethod;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static Method access$400() {
        return invokeWithOGLContextCurrentMethod;
    }

    static Method access$502(Method method) {
        isQueueFlusherThreadMethod = method;
        return isQueueFlusherThreadMethod;
    }

    static Method access$500() {
        return isQueueFlusherThreadMethod;
    }

    static Method access$602(Method method) {
        getOGLViewportMethod = method;
        return getOGLViewportMethod;
    }

    static Method access$600() {
        return getOGLViewportMethod;
    }

    static Method access$702(Method method) {
        getOGLScissorBoxMethod = method;
        return getOGLScissorBoxMethod;
    }

    static Method access$700() {
        return getOGLScissorBoxMethod;
    }

    static Method access$802(Method method) {
        getOGLSurfaceIdentifierMethod = method;
        return getOGLSurfaceIdentifierMethod;
    }

    static Method access$800() {
        return getOGLSurfaceIdentifierMethod;
    }

    static boolean access$902(boolean bl) {
        fbObjectSupportInitialized = bl;
        return fbObjectSupportInitialized;
    }

    static Method access$1002(Method method) {
        invokeWithOGLSharedContextCurrentMethod = method;
        return invokeWithOGLSharedContextCurrentMethod;
    }

    static Method access$1000() {
        return invokeWithOGLSharedContextCurrentMethod;
    }

    static Method access$1102(Method method) {
        getOGLSurfaceTypeMethod = method;
        return getOGLSurfaceTypeMethod;
    }

    static Method access$1100() {
        return getOGLSurfaceTypeMethod;
    }

    static Method access$1202(Method method) {
        getOGLTextureTypeMethod = method;
        return getOGLTextureTypeMethod;
    }

    static Method access$1200() {
        return getOGLTextureTypeMethod;
    }

    static Method access$1302(Method method) {
        createOGLContextOnSurfaceMethod = method;
        return createOGLContextOnSurfaceMethod;
    }

    static Method access$1300() {
        return createOGLContextOnSurfaceMethod;
    }

    static Method access$1402(Method method) {
        makeOGLContextCurrentOnSurfaceMethod = method;
        return makeOGLContextCurrentOnSurfaceMethod;
    }

    static Method access$1400() {
        return makeOGLContextCurrentOnSurfaceMethod;
    }

    static Method access$1502(Method method) {
        destroyOGLContextMethod = method;
        return destroyOGLContextMethod;
    }

    static Method access$1500() {
        return destroyOGLContextMethod;
    }

    static GLContext access$1602(GLContext gLContext) {
        j2dFBOShareContext = gLContext;
        return j2dFBOShareContext;
    }

    static {
        UNDEFINED = Java2D.getOGLUtilitiesIntField("UNDEFINED");
        WINDOW = Java2D.getOGLUtilitiesIntField("WINDOW");
        PBUFFER = Java2D.getOGLUtilitiesIntField("PBUFFER");
        TEXTURE = Java2D.getOGLUtilitiesIntField("TEXTURE");
        FLIP_BACKBUFFER = Java2D.getOGLUtilitiesIntField("FLIP_BACKBUFFER");
        FBOBJECT = Java2D.getOGLUtilitiesIntField("FBOBJECT");
        AccessController.doPrivileged(new Java2D$1());
    }
}

