/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUquadric;

public class GLUquadricImpl
implements GLUquadric {
    private int drawStyle = 100012;
    private int orientation = 100020;
    private boolean textureFlag = false;
    private int normals = 100000;
    private static final float PI = (float)Math.PI;
    private static final int CACHE_SIZE = 240;

    public void setDrawStyle(int n2) {
        this.drawStyle = n2;
    }

    public void setNormals(int n2) {
        this.normals = n2;
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
    }

    public void setTextureFlag(boolean bl) {
        this.textureFlag = bl;
    }

    public int getDrawStyle() {
        return this.drawStyle;
    }

    public int getNormals() {
        return this.normals;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean getTextureFlag() {
        return this.textureFlag;
    }

    public void drawCylinder(GL gL, float f2, float f3, float f4, int n2, int n3) {
        float f5 = this.orientation == 100021 ? -1.0f : 1.0f;
        float f6 = (float)Math.PI * 2 / (float)n2;
        float f7 = (f3 - f2) / (float)n3;
        float f8 = f4 / (float)n3;
        float f9 = (f2 - f3) / f4;
        if (this.drawStyle == 100010) {
            gL.glBegin(0);
            for (int i2 = 0; i2 < n2; ++i2) {
                float f10 = this.cos((float)i2 * f6);
                float f11 = this.sin((float)i2 * f6);
                this.normal3f(gL, f10 * f5, f11 * f5, f9 * f5);
                float f12 = 0.0f;
                float f13 = f2;
                for (int i3 = 0; i3 <= n3; ++i3) {
                    gL.glVertex3f(f10 * f13, f11 * f13, f12);
                    f12 += f8;
                    f13 += f7;
                }
            }
            gL.glEnd();
            return;
        }
        if (this.drawStyle == 100011 || this.drawStyle == 100013) {
            float f14;
            float f15;
            int n4;
            if (this.drawStyle == 100011) {
                float f16 = 0.0f;
                float f17 = f2;
                for (int i4 = 0; i4 <= n3; ++i4) {
                    gL.glBegin(2);
                    for (n4 = 0; n4 < n2; ++n4) {
                        f15 = this.cos((float)n4 * f6);
                        f14 = this.sin((float)n4 * f6);
                        this.normal3f(gL, f15 * f5, f14 * f5, f9 * f5);
                        gL.glVertex3f(f15 * f17, f14 * f17, f16);
                    }
                    gL.glEnd();
                    f16 += f8;
                    f17 += f7;
                }
            } else if ((double)f2 != 0.0) {
                gL.glBegin(2);
                for (n4 = 0; n4 < n2; ++n4) {
                    f15 = this.cos((float)n4 * f6);
                    f14 = this.sin((float)n4 * f6);
                    this.normal3f(gL, f15 * f5, f14 * f5, f9 * f5);
                    gL.glVertex3f(f15 * f2, f14 * f2, 0.0f);
                }
                gL.glEnd();
                gL.glBegin(2);
                for (n4 = 0; n4 < n2; ++n4) {
                    f15 = this.cos((float)n4 * f6);
                    f14 = this.sin((float)n4 * f6);
                    this.normal3f(gL, f15 * f5, f14 * f5, f9 * f5);
                    gL.glVertex3f(f15 * f3, f14 * f3, f4);
                }
                gL.glEnd();
            }
            gL.glBegin(1);
            for (n4 = 0; n4 < n2; ++n4) {
                f15 = this.cos((float)n4 * f6);
                f14 = this.sin((float)n4 * f6);
                this.normal3f(gL, f15 * f5, f14 * f5, f9 * f5);
                gL.glVertex3f(f15 * f2, f14 * f2, 0.0f);
                gL.glVertex3f(f15 * f3, f14 * f3, f4);
            }
            gL.glEnd();
            return;
        }
        if (this.drawStyle == 100012) {
            f3 = 1.0f / (float)n2;
            f4 = 1.0f / (float)n3;
            float f18 = 0.0f;
            float f19 = 0.0f;
            float f20 = f2;
            for (int i5 = 0; i5 < n3; ++i5) {
                f2 = 0.0f;
                gL.glBegin(8);
                for (int i6 = 0; i6 <= n2; ++i6) {
                    float f21;
                    float f22;
                    if (i6 == n2) {
                        f22 = this.sin(0.0f);
                        f21 = this.cos(0.0f);
                    } else {
                        f22 = this.sin((float)i6 * f6);
                        f21 = this.cos((float)i6 * f6);
                    }
                    this.normal3f(gL, f22 * f5, f21 * f5, f9 * f5);
                    this.TXTR_COORD(gL, f2, f18);
                    gL.glVertex3f(f22 * f20, f21 * f20, f19);
                    this.normal3f(gL, f22 * f5, f21 * f5, f9 * f5);
                    this.TXTR_COORD(gL, f2, f18 + f4);
                    gL.glVertex3f(f22 * (f20 + f7), f21 * (f20 + f7), f19 + f8);
                    f2 += f3;
                }
                gL.glEnd();
                f20 += f7;
                f18 += f4;
                f19 += f8;
            }
        }
    }

    public void drawDisk(GL gL, float f2, float f3, int n2, int n3) {
        if (this.normals != 100002) {
            if (this.orientation == 100020) {
                gL.glNormal3f(0.0f, 0.0f, 1.0f);
            } else {
                gL.glNormal3f(0.0f, 0.0f, -1.0f);
            }
        }
        float f4 = (float)Math.PI * 2 / (float)n2;
        float f5 = (f3 - f2) / (float)n3;
        switch (this.drawStyle) {
            case 100012: {
                float f6 = f3 * 2.0f;
                f3 = f2;
                for (int i2 = 0; i2 < n3; ++i2) {
                    float f7;
                    float f8;
                    int n4;
                    float f9 = f3 + f5;
                    if (this.orientation == 100020) {
                        gL.glBegin(8);
                        for (n4 = 0; n4 <= n2; ++n4) {
                            f8 = n4 == n2 ? 0.0f : (float)n4 * f4;
                            f7 = this.sin(f8);
                            f8 = this.cos(f8);
                            this.TXTR_COORD(gL, 0.5f + f7 * f9 / f6, 0.5f + f8 * f9 / f6);
                            gL.glVertex2f(f9 * f7, f9 * f8);
                            this.TXTR_COORD(gL, 0.5f + f7 * f3 / f6, 0.5f + f8 * f3 / f6);
                            gL.glVertex2f(f3 * f7, f3 * f8);
                        }
                        gL.glEnd();
                    } else {
                        gL.glBegin(8);
                        for (n4 = n2; n4 >= 0; --n4) {
                            f8 = n4 == n2 ? 0.0f : (float)n4 * f4;
                            f7 = this.sin(f8);
                            f8 = this.cos(f8);
                            this.TXTR_COORD(gL, 0.5f - f7 * f9 / f6, 0.5f + f8 * f9 / f6);
                            gL.glVertex2f(f9 * f7, f9 * f8);
                            this.TXTR_COORD(gL, 0.5f - f7 * f3 / f6, 0.5f + f8 * f3 / f6);
                            gL.glVertex2f(f3 * f7, f3 * f8);
                        }
                        gL.glEnd();
                    }
                    f3 = f9;
                }
                break;
            }
            case 100011: {
                int n5;
                float f10;
                int n6;
                for (n6 = 0; n6 <= n3; ++n6) {
                    f10 = f2 + (float)n6 * f5;
                    gL.glBegin(2);
                    for (n5 = 0; n5 < n2; ++n5) {
                        f3 = (float)n5 * f4;
                        gL.glVertex2f(f10 * this.sin(f3), f10 * this.cos(f3));
                    }
                    gL.glEnd();
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    f10 = (float)n5 * f4;
                    f3 = this.sin(f10);
                    float f11 = this.cos(f10);
                    gL.glBegin(3);
                    for (n6 = 0; n6 <= n3; ++n6) {
                        float f12 = f2 + (float)n6 * f5;
                        gL.glVertex2f(f12 * f3, f12 * f11);
                    }
                    gL.glEnd();
                }
                break;
            }
            case 100010: {
                gL.glBegin(0);
                for (int i3 = 0; i3 < n2; ++i3) {
                    float f13 = (float)i3 * f4;
                    float f14 = this.sin(f13);
                    f3 = this.cos(f13);
                    for (int i4 = 0; i4 <= n3; ++i4) {
                        float f15 = f2 * (float)i4 * f5;
                        gL.glVertex2f(f15 * f14, f15 * f3);
                    }
                }
                gL.glEnd();
                return;
            }
            case 100013: {
                float f16;
                float f17;
                float f18;
                if ((double)f2 != 0.0) {
                    gL.glBegin(2);
                    f18 = 0.0f;
                    while ((double)f18 < 6.2831854820251465) {
                        f17 = f2 * this.sin(f18);
                        f16 = f2 * this.cos(f18);
                        gL.glVertex2f(f17, f16);
                        f18 += f4;
                    }
                    gL.glEnd();
                }
                gL.glBegin(2);
                for (f18 = 0.0f; f18 < (float)Math.PI * 2; f18 += f4) {
                    f17 = f3 * this.sin(f18);
                    f16 = f3 * this.cos(f18);
                    gL.glVertex2f(f17, f16);
                }
                gL.glEnd();
                return;
            }
            default: {
                return;
            }
        }
    }

    public void drawPartialDisk(GL gL, float f2, float f3, int n2, int n3, float f4, float f5) {
        float f6;
        int n4;
        float[] fArray = new float[240];
        float[] fArray2 = new float[240];
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (n2 >= 240) {
            n2 = 239;
        }
        if (n2 < 2 || n3 <= 0 || f3 <= 0.0f || f2 < 0.0f || f2 > f3) {
            System.err.println("PartialDisk: GLU_INVALID_VALUE");
            return;
        }
        if (f5 < -360.0f) {
            f5 = 360.0f;
        }
        if (f5 > 360.0f) {
            f5 = 360.0f;
        }
        if (f5 < 0.0f) {
            f4 += f5;
            f5 = -f5;
        }
        int n5 = f5 == 360.0f ? n2 : n2 + 1;
        float f9 = f3 - f2;
        float f10 = f4 / 180.0f * (float)Math.PI;
        for (n4 = 0; n4 <= n2; ++n4) {
            f6 = f10 + (float)Math.PI * f5 / 180.0f * (float)n4 / (float)n2;
            fArray[n4] = this.sin(f6);
            fArray2[n4] = this.cos(f6);
        }
        if (f5 == 360.0f) {
            fArray[n2] = fArray[0];
            fArray2[n2] = fArray2[0];
        }
        switch (this.normals) {
            case 100000: 
            case 100001: {
                if (this.orientation == 100020) {
                    gL.glNormal3f(0.0f, 0.0f, 1.0f);
                    break;
                }
                gL.glNormal3f(0.0f, 0.0f, -1.0f);
            }
        }
        block3 : switch (this.drawStyle) {
            case 100012: {
                int n6;
                if (f2 == 0.0f) {
                    n6 = n3 - 1;
                    gL.glBegin(6);
                    if (this.textureFlag) {
                        gL.glTexCoord2f(0.5f, 0.5f);
                    }
                    gL.glVertex3f(0.0f, 0.0f, 0.0f);
                    f10 = f3 - f9 * ((float)n6 / (float)n3);
                    if (this.textureFlag) {
                        f7 = f10 / f3 / 2.0f;
                    }
                    if (this.orientation == 100020) {
                        for (n4 = n2; n4 >= 0; --n4) {
                            if (this.textureFlag) {
                                gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                            }
                            gL.glVertex3f(f10 * fArray[n4], f10 * fArray2[n4], 0.0f);
                        }
                    } else {
                        for (n4 = 0; n4 <= n2; ++n4) {
                            if (this.textureFlag) {
                                gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                            }
                            gL.glVertex3f(f10 * fArray[n4], f10 * fArray2[n4], 0.0f);
                        }
                    }
                    gL.glEnd();
                } else {
                    n6 = n3;
                }
                for (int i2 = 0; i2 < n6; ++i2) {
                    f10 = f3 - f9 * ((float)i2 / (float)n3);
                    f2 = f3 - f9 * ((float)(i2 + 1) / (float)n3);
                    if (this.textureFlag) {
                        f7 = f10 / f3 / 2.0f;
                        f8 = f2 / f3 / 2.0f;
                    }
                    gL.glBegin(8);
                    for (n4 = 0; n4 <= n2; ++n4) {
                        if (this.orientation == 100020) {
                            if (this.textureFlag) {
                                gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                            }
                            gL.glVertex3f(f10 * fArray[n4], f10 * fArray2[n4], 0.0f);
                            if (this.textureFlag) {
                                gL.glTexCoord2f(f8 * fArray[n4] + 0.5f, f8 * fArray2[n4] + 0.5f);
                            }
                            gL.glVertex3f(f2 * fArray[n4], f2 * fArray2[n4], 0.0f);
                            continue;
                        }
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f8 * fArray[n4] + 0.5f, f8 * fArray2[n4] + 0.5f);
                        }
                        gL.glVertex3f(f2 * fArray[n4], f2 * fArray2[n4], 0.0f);
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                        }
                        gL.glVertex3f(f10 * fArray[n4], f10 * fArray2[n4], 0.0f);
                    }
                    gL.glEnd();
                }
                break;
            }
            case 100010: {
                gL.glBegin(0);
                for (n4 = 0; n4 < n5; ++n4) {
                    f6 = fArray[n4];
                    f8 = fArray2[n4];
                    for (int i3 = 0; i3 <= n3; ++i3) {
                        f10 = f3 - f9 * ((float)i3 / (float)n3);
                        if (this.textureFlag) {
                            f7 = f10 / f3 / 2.0f;
                            gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                        }
                        gL.glVertex3f(f10 * f6, f10 * f8, 0.0f);
                    }
                }
                gL.glEnd();
                return;
            }
            case 100011: {
                int n7;
                if (f2 == f3) {
                    gL.glBegin(3);
                    for (n4 = 0; n4 <= n2; ++n4) {
                        if (this.textureFlag) {
                            gL.glTexCoord2f(fArray[n4] / 2.0f + 0.5f, fArray2[n4] / 2.0f + 0.5f);
                        }
                        gL.glVertex3f(f2 * fArray[n4], f2 * fArray2[n4], 0.0f);
                    }
                    gL.glEnd();
                    return;
                }
                for (n7 = 0; n7 <= n3; ++n7) {
                    f10 = f3 - f9 * ((float)n7 / (float)n3);
                    if (this.textureFlag) {
                        f7 = f10 / f3 / 2.0f;
                    }
                    gL.glBegin(3);
                    for (n4 = 0; n4 <= n2; ++n4) {
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                        }
                        gL.glVertex3f(f10 * fArray[n4], f10 * fArray2[n4], 0.0f);
                    }
                    gL.glEnd();
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    f6 = fArray[n4];
                    f8 = fArray2[n4];
                    gL.glBegin(3);
                    for (n7 = 0; n7 <= n3; ++n7) {
                        f10 = f3 - f9 * ((float)n7 / (float)n3);
                        if (this.textureFlag) {
                            f7 = f10 / f3 / 2.0f;
                        }
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                        }
                        gL.glVertex3f(f10 * f6, f10 * f8, 0.0f);
                    }
                    gL.glEnd();
                }
                break;
            }
            case 100013: {
                if (f5 < 360.0f) {
                    for (n4 = 0; n4 <= n2; n4 += n2) {
                        f6 = fArray[n4];
                        f8 = fArray2[n4];
                        gL.glBegin(3);
                        for (int i4 = 0; i4 <= n3; ++i4) {
                            f10 = f3 - f9 * ((float)i4 / (float)n3);
                            if (this.textureFlag) {
                                f7 = f10 / f3 / 2.0f;
                                gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                            }
                            gL.glVertex3f(f10 * f6, f10 * f8, 0.0f);
                        }
                        gL.glEnd();
                    }
                }
                for (int i5 = 0; i5 <= n3; i5 += n3) {
                    f10 = f3 - f9 * ((float)i5 / (float)n3);
                    if (this.textureFlag) {
                        f7 = f10 / f3 / 2.0f;
                    }
                    gL.glBegin(3);
                    for (n4 = 0; n4 <= n2; ++n4) {
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                        }
                        gL.glVertex3f(f10 * fArray[n4], f10 * fArray2[n4], 0.0f);
                    }
                    gL.glEnd();
                    if (f2 == f3) break block3;
                }
                break;
            }
        }
    }

    public void drawSphere(GL gL, float f2, int n2, int n3) {
        boolean bl = this.normals != 100002;
        float f3 = this.orientation == 100021 ? -1.0f : 1.0f;
        float f4 = (float)Math.PI / (float)n3;
        float f5 = (float)Math.PI * 2 / (float)n2;
        if (this.drawStyle == 100012) {
            int n4;
            int n5;
            float f6;
            float f7;
            float f8;
            float f9;
            int n6;
            if (!this.textureFlag) {
                gL.glBegin(6);
                gL.glNormal3f(0.0f, 0.0f, 1.0f);
                gL.glVertex3f(0.0f, 0.0f, f3 * f2);
                for (n6 = 0; n6 <= n2; ++n6) {
                    f9 = n6 == n2 ? 0.0f : (float)n6 * f5;
                    f8 = -this.sin(f9) * this.sin(f4);
                    f7 = this.cos(f9) * this.sin(f4);
                    f6 = f3 * this.cos(f4);
                    if (bl) {
                        gL.glNormal3f(f8 * f3, f7 * f3, f6 * f3);
                    }
                    gL.glVertex3f(f8 * f2, f7 * f2, f6 * f2);
                }
                gL.glEnd();
            }
            float f10 = 1.0f / (float)n2;
            float f11 = 1.0f / (float)n3;
            float f12 = 1.0f;
            if (this.textureFlag) {
                n5 = 0;
                n4 = n3;
            } else {
                n5 = 1;
                n4 = n3 - 1;
            }
            for (int i2 = n5; i2 < n4; ++i2) {
                float f13 = (float)i2 * f4;
                gL.glBegin(8);
                float f14 = 0.0f;
                for (n6 = 0; n6 <= n2; ++n6) {
                    f9 = n6 == n2 ? 0.0f : (float)n6 * f5;
                    f8 = -this.sin(f9) * this.sin(f13);
                    f7 = this.cos(f9) * this.sin(f13);
                    f6 = f3 * this.cos(f13);
                    if (bl) {
                        gL.glNormal3f(f8 * f3, f7 * f3, f6 * f3);
                    }
                    this.TXTR_COORD(gL, f14, f12);
                    gL.glVertex3f(f8 * f2, f7 * f2, f6 * f2);
                    f8 = -this.sin(f9) * this.sin(f13 + f4);
                    f7 = this.cos(f9) * this.sin(f13 + f4);
                    f6 = f3 * this.cos(f13 + f4);
                    if (bl) {
                        gL.glNormal3f(f8 * f3, f7 * f3, f6 * f3);
                    }
                    this.TXTR_COORD(gL, f14, f12 - f11);
                    f14 += f10;
                    gL.glVertex3f(f8 * f2, f7 * f2, f6 * f2);
                }
                gL.glEnd();
                f12 -= f11;
            }
            if (!this.textureFlag) {
                gL.glBegin(6);
                gL.glNormal3f(0.0f, 0.0f, -1.0f);
                gL.glVertex3f(0.0f, 0.0f, -f2 * f3);
                float f15 = (float)Math.PI - f4;
                for (n6 = n2; n6 >= 0; --n6) {
                    f9 = n6 == n2 ? 0.0f : (float)n6 * f5;
                    f8 = -this.sin(f9) * this.sin(f15);
                    f7 = this.cos(f9) * this.sin(f15);
                    f6 = f3 * this.cos(f15);
                    if (bl) {
                        gL.glNormal3f(f8 * f3, f7 * f3, f6 * f3);
                    }
                    gL.glVertex3f(f8 * f2, f7 * f2, f6 * f2);
                }
                gL.glEnd();
                return;
            }
        } else if (this.drawStyle == 100011 || this.drawStyle == 100013) {
            float f16;
            float f17;
            float f18;
            float f19;
            int n7;
            float f20;
            int n8;
            for (n8 = 1; n8 < n3; ++n8) {
                f20 = (float)n8 * f4;
                gL.glBegin(2);
                for (n7 = 0; n7 < n2; ++n7) {
                    f19 = (float)n7 * f5;
                    f18 = this.cos(f19) * this.sin(f20);
                    f17 = this.sin(f19) * this.sin(f20);
                    f16 = this.cos(f20);
                    if (bl) {
                        gL.glNormal3f(f18 * f3, f17 * f3, f16 * f3);
                    }
                    gL.glVertex3f(f18 * f2, f17 * f2, f16 * f2);
                }
                gL.glEnd();
            }
            for (n7 = 0; n7 < n2; ++n7) {
                f19 = (float)n7 * f5;
                gL.glBegin(3);
                for (n8 = 0; n8 <= n3; ++n8) {
                    f20 = (float)n8 * f4;
                    f18 = this.cos(f19) * this.sin(f20);
                    f17 = this.sin(f19) * this.sin(f20);
                    f16 = this.cos(f20);
                    if (bl) {
                        gL.glNormal3f(f18 * f3, f17 * f3, f16 * f3);
                    }
                    gL.glVertex3f(f18 * f2, f17 * f2, f16 * f2);
                }
                gL.glEnd();
            }
        } else if (this.drawStyle == 100010) {
            gL.glBegin(0);
            if (bl) {
                gL.glNormal3f(0.0f, 0.0f, f3);
            }
            gL.glVertex3f(0.0f, 0.0f, f2);
            if (bl) {
                gL.glNormal3f(0.0f, 0.0f, -f3);
            }
            gL.glVertex3f(0.0f, 0.0f, -f2);
            for (int i3 = 1; i3 < n3 - 1; ++i3) {
                float f21 = (float)i3 * f4;
                for (int i4 = 0; i4 < n2; ++i4) {
                    float f22 = (float)i4 * f5;
                    float f23 = this.cos(f22) * this.sin(f21);
                    float f24 = this.sin(f22) * this.sin(f21);
                    float f25 = this.cos(f21);
                    if (bl) {
                        gL.glNormal3f(f23 * f3, f24 * f3, f25 * f3);
                    }
                    gL.glVertex3f(f23 * f2, f24 * f2, f25 * f2);
                }
            }
            gL.glEnd();
        }
    }

    private void normal3f(GL gL, float f2, float f3, float f4) {
        float f5;
        float f6 = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        if (f5 > 1.0E-5f) {
            f2 /= f6;
            f3 /= f6;
            f4 /= f6;
        }
        gL.glNormal3f(f2, f3, f4);
    }

    private void TXTR_COORD(GL gL, float f2, float f3) {
        if (this.textureFlag) {
            gL.glTexCoord2f(f2, f3);
        }
    }

    private float sin(float f2) {
        return (float)Math.sin(f2);
    }

    private float cos(float f2) {
        return (float)Math.cos(f2);
    }
}

