/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.gluegen.runtime.ProcAddressHelper;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.FunctionAvailabilityCache;
import com.sun.opengl.impl.GLBufferSizeTracker;
import com.sun.opengl.impl.GLContextImpl$1;
import com.sun.opengl.impl.GLContextLock;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLImpl;
import com.sun.opengl.impl.GLObjectTracker;
import com.sun.opengl.impl.GLProcAddressTable;
import com.sun.opengl.impl.GLWorkerThread;
import com.sun.opengl.impl.Java2D;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public abstract class GLContextImpl
extends GLContext {
    protected GLContextLock lock = new GLContextLock();
    protected static final boolean DEBUG = Debug.debug("GLContextImpl");
    protected static final boolean VERBOSE = Debug.verbose();
    protected static final boolean NO_FREE = Debug.isPropertyDefined("jogl.GLContext.nofree");
    protected boolean optimizationEnabled = Debug.isPropertyDefined("jogl.GLContext.optimize");
    protected FunctionAvailabilityCache functionAvailability = new FunctionAvailabilityCache(this);
    private GLProcAddressTable glProcAddressTable;
    private GLBufferSizeTracker bufferSizeTracker;
    private GLObjectTracker tracker;
    private GLObjectTracker deletedObjectTracker;
    protected GL gl;

    public GLContextImpl(GLContext gLContext) {
        this(gLContext, false);
    }

    public GLContextImpl(GLContext gLContext, boolean bl) {
        GLContext gLContext2 = gLContext;
        if (!bl) {
            gLContext2 = Java2D.filterShareContext(gLContext);
        }
        if (gLContext2 != null) {
            GLContextShareSet.registerSharing(this, gLContext2);
        }
        if (gLContext2 == null) {
            gLContext2 = Java2D.filterShareContext(gLContext);
        }
        GLContextShareSet.registerForObjectTracking(gLContext, this, gLContext2);
        GLContextShareSet.registerForBufferObjectSharing(gLContext, this);
        this.setGL(this.createGL());
    }

    @Override
    public int makeCurrent() {
        int n2;
        GLContext gLContext = GLContextImpl.getCurrent();
        if (gLContext != null) {
            if (gLContext == this) {
                this.update();
                return 1;
            }
            gLContext.release();
        }
        if (GLWorkerThread.isStarted() && !GLWorkerThread.isWorkerThread()) {
            GLWorkerThread.invokeLater(new GLContextImpl$1(this));
        }
        this.lock.lock();
        try {
            n2 = this.makeCurrentImpl();
            if (this.tracker != null && n2 == 2) {
                this.tracker.ref();
            }
        }
        catch (GLException gLException) {
            this.lock.unlock();
            throw gLException;
        }
        if (n2 == 0) {
            this.lock.unlock();
        } else {
            GLContextImpl.setCurrent(this);
            if (this.deletedObjectTracker != null) {
                this.deletedObjectTracker.clean(this.getGL());
            }
        }
        return n2;
    }

    protected abstract int makeCurrentImpl();

    @Override
    public void release() {
        if (!this.lock.isHeld()) {
            throw new GLException("Context not current on current thread");
        }
        GLContextImpl.setCurrent(null);
        try {
            this.releaseImpl();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void releaseImpl();

    @Override
    public void destroy() {
        if (this.lock.isHeld()) {
            throw new GLException("Can not destroy context while it is current");
        }
        if (this.tracker != null && this.isCreated()) {
            this.tracker.unref(this.deletedObjectTracker);
        }
        this.bufferSizeTracker.clearCachedBufferSizes();
        this.lock.lock();
        try {
            this.destroyImpl();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void destroyImpl();

    protected void update() {
    }

    @Override
    public boolean isSynchronized() {
        return !this.lock.getFailFastMode();
    }

    @Override
    public void setSynchronized(boolean bl) {
        this.lock.setFailFastMode(!bl);
    }

    @Override
    public GL getGL() {
        return this.gl;
    }

    @Override
    public void setGL(GL gL) {
        this.gl = gL;
    }

    public abstract Object getPlatformGLExtensions();

    protected GL createGL() {
        GLImpl gLImpl = new GLImpl(this);
        if (this.tracker != null) {
            gLImpl.setObjectTracker(this.tracker);
        }
        return gLImpl;
    }

    public GLProcAddressTable getGLProcAddressTable() {
        if (this.glProcAddressTable == null) {
            this.glProcAddressTable = new GLProcAddressTable();
        }
        return this.glProcAddressTable;
    }

    public abstract void bindPbufferToTexture();

    public abstract void releasePbufferFromTexture();

    public abstract ByteBuffer glAllocateMemoryNV(int var1, float var2, float var3, float var4);

    public void setSwapInterval(int n2) {
    }

    protected abstract String mapToRealGLFunctionName(String var1);

    protected abstract String mapToRealGLExtensionName(String var1);

    public abstract String getPlatformExtensionsString();

    protected void resetProcAddressTable(Object object) {
        ProcAddressHelper.resetProcAddressTable(object, GLDrawableFactoryImpl.getFactoryImpl());
    }

    public abstract boolean isCreated();

    public void resetGLFunctionAvailability() {
        this.setGL(this.createGL());
        this.functionAvailability.flush();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! Initializing OpenGL extension address table for " + this);
        }
        this.resetProcAddressTable(this.getGLProcAddressTable());
    }

    public boolean isFunctionAvailable(String string) {
        return this.functionAvailability.isFunctionAvailable(this.mapToRealGLFunctionName(string));
    }

    public boolean isExtensionAvailable(String string) {
        return this.functionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
    }

    public int getFloatingPointMode() {
        throw new GLException("Not supported on non-pbuffer contexts");
    }

    public abstract boolean offscreenImageNeedsVerticalFlip();

    public abstract int getOffscreenContextPixelDataType();

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static String toHexString(long l2) {
        return "0x" + Long.toHexString(l2);
    }

    public void setBufferSizeTracker(GLBufferSizeTracker gLBufferSizeTracker) {
        this.bufferSizeTracker = gLBufferSizeTracker;
    }

    public GLBufferSizeTracker getBufferSizeTracker() {
        return this.bufferSizeTracker;
    }

    public void setObjectTracker(GLObjectTracker gLObjectTracker) {
        this.tracker = gLObjectTracker;
    }

    public GLObjectTracker getObjectTracker() {
        return this.tracker;
    }

    public void setDeletedObjectTracker(GLObjectTracker gLObjectTracker) {
        this.deletedObjectTracker = gLObjectTracker;
    }

    public GLObjectTracker getDeletedObjectTracker() {
        return this.deletedObjectTracker;
    }

    public boolean isOptimizable() {
        return this.optimizationEnabled;
    }

    public boolean hasWaiters() {
        return this.lock.hasWaiters();
    }
}

