/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.InfoResidue0;
import com.jcraft.jorbis.LookResidue0;

class Residue0
extends FuncResidue {
    static int[][][] partword = new int[2][][];

    Residue0() {
    }

    @Override
    void pack(Object object, Buffer buffer) {
        int n2;
        object = (InfoResidue0)object;
        int n3 = 0;
        buffer.write(((InfoResidue0)object).begin, 24);
        buffer.write(((InfoResidue0)object).end, 24);
        buffer.write(((InfoResidue0)object).grouping - 1, 24);
        buffer.write(((InfoResidue0)object).partitions - 1, 6);
        buffer.write(((InfoResidue0)object).groupbook, 8);
        for (n2 = 0; n2 < ((InfoResidue0)object).partitions; ++n2) {
            if (Residue0.ilog(((InfoResidue0)object).secondstages[n2]) > 3) {
                buffer.write(((InfoResidue0)object).secondstages[n2], 3);
                buffer.write(1, 1);
                buffer.write(((InfoResidue0)object).secondstages[n2] >>> 3, 5);
            } else {
                buffer.write(((InfoResidue0)object).secondstages[n2], 4);
            }
            n3 += Residue0.icount(((InfoResidue0)object).secondstages[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            buffer.write(((InfoResidue0)object).booklist[n2], 8);
        }
    }

    @Override
    Object unpack(Info info, Buffer buffer) {
        int n2;
        int n3 = 0;
        InfoResidue0 infoResidue0 = new InfoResidue0();
        new InfoResidue0().begin = buffer.read(24);
        infoResidue0.end = buffer.read(24);
        infoResidue0.grouping = buffer.read(24) + 1;
        infoResidue0.partitions = buffer.read(6) + 1;
        infoResidue0.groupbook = buffer.read(8);
        for (n2 = 0; n2 < infoResidue0.partitions; ++n2) {
            int n4 = buffer.read(3);
            if (buffer.read(1) != 0) {
                n4 |= buffer.read(5) << 3;
            }
            infoResidue0.secondstages[n2] = n4;
            n3 += Residue0.icount(n4);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            infoResidue0.booklist[n2] = buffer.read(8);
        }
        if (infoResidue0.groupbook >= info.books) {
            this.free_info(infoResidue0);
            return null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (infoResidue0.booklist[n2] < info.books) continue;
            this.free_info(infoResidue0);
            return null;
        }
        return infoResidue0;
    }

    @Override
    Object look(DspState dspState, InfoMode infoMode, Object object) {
        int n2;
        int n3;
        int n4;
        object = (InfoResidue0)object;
        LookResidue0 lookResidue0 = new LookResidue0();
        int n5 = 0;
        int n6 = 0;
        lookResidue0.info = object;
        lookResidue0.map = infoMode.mapping;
        lookResidue0.parts = ((InfoResidue0)object).partitions;
        lookResidue0.fullbooks = dspState.fullbooks;
        lookResidue0.phrasebook = dspState.fullbooks[((InfoResidue0)object).groupbook];
        int n7 = lookResidue0.phrasebook.dim;
        lookResidue0.partbooks = new int[lookResidue0.parts][];
        for (n4 = 0; n4 < lookResidue0.parts; ++n4) {
            n3 = Residue0.ilog(((InfoResidue0)object).secondstages[n4]);
            if (n3 == 0) continue;
            if (n3 > n6) {
                n6 = n3;
            }
            lookResidue0.partbooks[n4] = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                if ((((InfoResidue0)object).secondstages[n4] & 1 << n2) == 0) continue;
                lookResidue0.partbooks[n4][n2] = ((InfoResidue0)object).booklist[n5++];
            }
        }
        lookResidue0.partvals = (int)Math.rint(Math.pow(lookResidue0.parts, n7));
        lookResidue0.stages = n6;
        lookResidue0.decodemap = new int[lookResidue0.partvals][];
        for (n4 = 0; n4 < lookResidue0.partvals; ++n4) {
            n3 = n4;
            n2 = lookResidue0.partvals / lookResidue0.parts;
            lookResidue0.decodemap[n4] = new int[n7];
            for (int i2 = 0; i2 < n7; ++i2) {
                n5 = n3 / n2;
                n3 -= n5 * n2;
                n2 /= lookResidue0.parts;
                lookResidue0.decodemap[n4][i2] = n5;
            }
        }
        return lookResidue0;
    }

    @Override
    void free_info(Object object) {
    }

    @Override
    void free_look(Object object) {
    }

    @Override
    int forward(Block block, Object object, float[][] fArray, int n2) {
        System.err.println("Residue0.forward: not implemented");
        return 0;
    }

    static synchronized int _01inverse(Block block, Object object, float[][] fArray, int n2, int n3) {
        int n4;
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n5 = infoResidue0.grouping;
        int n6 = lookResidue0.phrasebook.dim;
        int n7 = (infoResidue0.end - infoResidue0.begin) / n5;
        int n8 = (n7 + n6 - 1) / n6;
        if (partword.length < n2) {
            partword = new int[n2][][];
            for (n4 = 0; n4 < n2; ++n4) {
                Residue0.partword[n4] = new int[n8][];
            }
        } else {
            for (n4 = 0; n4 < n2; ++n4) {
                if (partword[n4] != null && partword[n4].length >= n8) continue;
                Residue0.partword[n4] = new int[n8][];
            }
        }
        for (int i2 = 0; i2 < lookResidue0.stages; ++i2) {
            n8 = 0;
            int n9 = 0;
            while (n8 < n7) {
                int n10;
                if (i2 == 0) {
                    for (n4 = 0; n4 < n2; ++n4) {
                        n10 = lookResidue0.phrasebook.decode(block.opb);
                        if (n10 == -1) {
                            return 0;
                        }
                        Residue0.partword[n4][n9] = lookResidue0.decodemap[n10];
                        if (partword[n4][n9] != null) continue;
                        return 0;
                    }
                }
                for (int i3 = 0; i3 < n6 && n8 < n7; ++i3, ++n8) {
                    for (n4 = 0; n4 < n2; ++n4) {
                        CodeBook codeBook;
                        n10 = infoResidue0.begin + n8 * n5;
                        if ((infoResidue0.secondstages[partword[n4][n9][i3]] & 1 << i2) == 0 || (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[partword[n4][n9][i3]][i2]]) == null || !(n3 == 0 ? codeBook.decodevs_add(fArray[n4], n10, block.opb, n5) == -1 : n3 == 1 && codeBook.decodev_add(fArray[n4], n10, block.opb, n5) == -1)) continue;
                        return 0;
                    }
                }
                ++n9;
            }
        }
        return 0;
    }

    static int _2inverse(Block block, Object object, float[][] fArray, int n2) {
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n3 = infoResidue0.grouping;
        int n4 = lookResidue0.phrasebook.dim;
        int n5 = (infoResidue0.end - infoResidue0.begin) / n3;
        int[][] nArrayArray = new int[(n5 + n4 - 1) / n4][];
        for (int i2 = 0; i2 < lookResidue0.stages; ++i2) {
            int n6 = 0;
            int n7 = 0;
            while (n6 < n5) {
                int n8;
                if (i2 == 0) {
                    n8 = lookResidue0.phrasebook.decode(block.opb);
                    if (n8 == -1) {
                        return 0;
                    }
                    nArrayArray[n7] = lookResidue0.decodemap[n8];
                    if (nArrayArray[n7] == null) {
                        return 0;
                    }
                }
                for (int i3 = 0; i3 < n4 && n6 < n5; ++i3, ++n6) {
                    CodeBook codeBook;
                    n8 = infoResidue0.begin + n6 * n3;
                    if ((infoResidue0.secondstages[nArrayArray[n7][i3]] & 1 << i2) == 0 || (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[nArrayArray[n7][i3]][i2]]) == null || codeBook.decodevv_add(fArray, n8, n2, block.opb, n3) != -1) continue;
                    return 0;
                }
                ++n7;
            }
        }
        return 0;
    }

    @Override
    int inverse(Block block, Object object, float[][] fArray, int[] nArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == 0) continue;
            fArray[n3++] = fArray[i2];
        }
        if (n3 != 0) {
            return Residue0._01inverse(block, object, fArray, n3, 0);
        }
        return 0;
    }

    private static int ilog(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }

    private static int icount(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            n3 += n2 & 1;
            n2 >>>= 1;
        }
        return n3;
    }
}

