/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __ModelSettings_h
#define __ModelSettings_h

#include "ModuleDLL.h"

/** @brief Namespace SuperQuadrics for the Super Quadric algorithmic shapes.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace SuperQuadrics
{
  /** @brief ModelSettings class which holds information for the settings of a SuperQuadrics model.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  struct SUPER_QUADRICS_MODULE_API ModelSettings final
  {
    /**
    *  ModelSettings usingCCW variable.
    */
    bool usingCCW = true;

    /**
    *  ModelSettings usingNormals variable.
    */
    bool usingNormals = false;

    /**
    *  ModelSettings usingTexCoords variable.
    */
    bool usingTexCoords = false;

    /**
    *  ModelSettings usingManipulateGeometry variable.
    */
    bool usingManipulateGeometry = false;

    /**
    *  ModelSettings shrinkGeometryFactor variable.
    */
    double shrinkGeometryFactor = 0.0;

    /**
    *  ModelSettings usingGeometryExplosionFactor variable.
    */
    bool usingGeometryExplosionFactor = false;

    /*
    *  Normal 1st constructor to be used (fully Standard conformant: names in the expression-list of a mem-initializer are evaluated in the scope of the constructor for which the mem-initializer is specified).
    */
    ModelSettings(bool usingNormals, bool usingTexCoords) noexcept
      : usingNormals(usingNormals)
      , usingTexCoords(usingTexCoords)
    {}

    /*
    *  Normal 2nd constructor to be used (fully Standard conformant: names in the expression-list of a mem-initializer are evaluated in the scope of the constructor for which the mem-initializer is specified).
    */
    ModelSettings(bool usingCCW, bool usingNormals, bool usingTexCoords, bool usingManipulateGeometry, double shrinkGeometryFactor, bool usingGeometryExplosionFactor) noexcept
      : usingCCW(usingCCW)
      , usingNormals(usingNormals)
      , usingTexCoords(usingTexCoords)
      , usingManipulateGeometry(usingManipulateGeometry)
      , shrinkGeometryFactor(shrinkGeometryFactor)
      , usingGeometryExplosionFactor(usingGeometryExplosionFactor)
    {}

    ModelSettings()  = default;
    ~ModelSettings() = default;
    ModelSettings(const ModelSettings&) = default;
    ModelSettings(ModelSettings&&)      = default;
    ModelSettings& operator=(const ModelSettings&) = default;
    ModelSettings& operator=(ModelSettings&&)      = default;
  };
} // namespace SuperQuadrics

#endif // __ModelSettings_h