# ************************************************************
#
#  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
#  Released Under a Simplified BSD (FreeBSD) License
#  for academic, personal & non-commercial use.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions are met:
#
#  1. Redistributions of source code must retain the above copyright notice, this
#  list of conditions and the following disclaimer.
#
#  2. Redistributions in binary form must reproduce the above copyright notice,
#  this list of conditions and the following disclaimer in the documentation
#  and/or other materials provided with the distribution.
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
#  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
#  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  The views and conclusions contained in the software and documentation are those
#  of the author and should not be interpreted as representing official policies,
#  either expressed or implied, of the FreeBSD Project.
#
#  A Commercial License is also available for commercial use with
#  special restrictions and obligations at a one-off fee. See links at:
#  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
#  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
#  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.
#
# ************************************************************

# GPU Framework version 14.0.0

# Custom FindGLEW for the GPU Framework version 14.0.0
# ----------------------------------------------------
#
# Find the OpenGL Extension Wrangler Library (GLEW)
#
# Result Variables
# ^^^^^^^^^^^^^^^^
#
# This module defines the following variables:
#
#   GLEW_INCLUDE_HEADERS - include directory for GLEW
#   GLEW_LIBRARIES       - library file (glew32.lib) to link against GLEW
#   GLEW_BINARIES        - binary  directory for GLEW
#   GLEW_FOUND           - true if GLEW has been found and can be used

set(GLEW_VERSION "2.1.0")

# find the path of GLEW headers
find_path(GLEW_INCLUDE_HEADERS glew.h eglew.h glxew.h wglew.h
  ${CMAKE_SOURCE_DIR}/GL/glew/include
  NO_DEFAULT_PATH
  )

if (WIN32)
  find_library(GLEW_LIBRARIES NAMES glew32.lib
    PATHS
    ${CMAKE_SOURCE_DIR}/GL/glew/bin/win/lib64
    NO_DEFAULT_PATH
    )
  find_path(GLEW_BINARIES glew32.dll
    ${CMAKE_SOURCE_DIR}/GL/glew/bin/win/dll64
    NO_DEFAULT_PATH
    )
elseif (UNIX)
  find_library(GLEW_LIBRARIES NAMES libGLEW.so.2.1
    PATHS
    ${CMAKE_SOURCE_DIR}/GL/glew/bin/linux/so64
    NO_DEFAULT_PATH
    )
  find_path(GLEW_BINARIES libGLEW.so.2.1
    ${CMAKE_SOURCE_DIR}/GL/glew/bin/linux/so64
    NO_DEFAULT_PATH
    )
endif()

if (GLEW_INCLUDE_HEADERS AND GLEW_LIBRARIES AND GLEW_BINARIES)
  set(GLEW_FOUND TRUE)
else()
  set(GLEW_FOUND FALSE CACHE BOOL "GLEW not found")
  message(FATAL_ERROR "Could NOT find GLEW, fatal error!")
endif()

mark_as_advanced(
  GLEW_INCLUDE_HEADERS
  GLEW_LIBRARIES
  GLEW_BINARIES
  )
