# ************************************************************
#
#  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
#  Released Under a Simplified BSD (FreeBSD) License
#  for academic, personal & non-commercial use.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions are met:
#
#  1. Redistributions of source code must retain the above copyright notice, this
#  list of conditions and the following disclaimer.
#
#  2. Redistributions in binary form must reproduce the above copyright notice,
#  this list of conditions and the following disclaimer in the documentation
#  and/or other materials provided with the distribution.
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
#  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
#  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  The views and conclusions contained in the software and documentation are those
#  of the author and should not be interpreted as representing official policies,
#  either expressed or implied, of the FreeBSD Project.
#
#  A Commercial License is also available for commercial use with
#  special restrictions and obligations at a one-off fee. See links at:
#  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
#  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
#  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.
#
# ************************************************************

# GPU Framework version 14.0.0

# Custom FindFreeGLUT for the GPU Framework version 14.0.0
# --------------------------------------------------------
#
# Find the Free GL Utility Library (FreeGLUT)
#
# Result Variables
# ^^^^^^^^^^^^^^^^
#
# This module defines the following variables:
#
#   FREEGLUT_INCLUDE_HEADERS - include directory for FreeGLUT
#   FREEGLUT_LIBRARIES       - library file (freeglut.lib) to link against FreeGLUT
#   FREEGLUT_BINARIES        - binary  directory for FreeGLUT
#   FREEGLUT_FOUND           - true if FreeGLUT has been found and can be used

set(FREEGLUT_VERSION "3.0.0")

# find the path of GLEW headers
find_path(FREEGLUT_INCLUDE_HEADERS glut.h freeglut.h freeglut_ext.h freeglut_std.h
  ${CMAKE_SOURCE_DIR}/GL/freeglut/include
  NO_DEFAULT_PATH
  )

if (WIN32)
  find_library(FREEGLUT_LIBRARIES NAMES freeglut.lib
    PATHS
    ${CMAKE_SOURCE_DIR}/GL/freeglut/bin/win/lib64
    NO_DEFAULT_PATH
    )
  find_path(FREEGLUT_BINARIES freeglut.dll
    ${CMAKE_SOURCE_DIR}/GL/freeglut/bin/win/dll64
    NO_DEFAULT_PATH
    )
elseif (UNIX)
  find_library(FREEGLUT_LIBRARIES libglut.so.3.10
  	PATHS
    ${CMAKE_SOURCE_DIR}/GL/freeglut/bin/linux/so64
    NO_DEFAULT_PATH
    )
  find_path(FREEGLUT_BINARIES libglut.so.3.10
    ${CMAKE_SOURCE_DIR}/GL/freeglut/bin/linux/so64
    NO_DEFAULT_PATH
    )
endif()

if (FREEGLUT_INCLUDE_HEADERS AND FREEGLUT_LIBRARIES AND FREEGLUT_BINARIES)
  set(FREEGLUT_FOUND TRUE)
else()
  set(FREEGLUT_FOUND FALSE CACHE BOOL "FreeGLUT not found")
  message(FATAL_ERROR "Could NOT find FreeGLUT, fatal error!")
endif()

mark_as_advanced(
  FREEGLUT_INCLUDE_HEADERS
  FREEGLUT_LIBRARIES
  FREEGLUT_BINARIES
  )
