# ************************************************************
#
#  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
#  Released Under a Simplified BSD (FreeBSD) License
#  for academic, personal & non-commercial use.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions are met:
#
#  1. Redistributions of source code must retain the above copyright notice, this
#  list of conditions and the following disclaimer.
#
#  2. Redistributions in binary form must reproduce the above copyright notice,
#  this list of conditions and the following disclaimer in the documentation
#  and/or other materials provided with the distribution.
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
#  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
#  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  The views and conclusions contained in the software and documentation are those
#  of the author and should not be interpreted as representing official policies,
#  either expressed or implied, of the FreeBSD Project.
#
#  A Commercial License is also available for commercial use with
#  special restrictions and obligations at a one-off fee. See links at:
#  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
#  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
#  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.
#
# ************************************************************

# GPU Framework version 14.0.0

# Custom FindDevIL for the GPU Framework version 14.0.0
# -----------------------------------------------------
#
# Find the Developers Image Library (once called "OpenIL") (DevIL)
#
# Result Variables
# ^^^^^^^^^^^^^^^^
#
# This module defines the following variables:
#
#   DEVIL_INCLUDE_HEADERS - include directory for DevIL
#   DEVIL_LIBRARY_1       - library file 1 (DevIL.lib) to link against DevIL
#   DEVIL_LIBRARY_2       - library file 2 (ILU.lib)   to link against DevIL
#   DEVIL_LIBRARY_3       - library file 3 (ILUT.lib)  to link against DevIL
#   DEVIL_BINARIES        - binary  directory for DevIL
#   DEVIL_FOUND           - true if DevIL has been found and can be used

set(DEVIL_VERSION "1.8.0")

# find the path of GLEW headers
find_path(DEVIL_INCLUDE_HEADERS devil_internal_exports.h il.h il_wrap.h ilu.h ilu_region.h ilut.h ilut_config.h devil_cpp_wrapper.hpp
  ${CMAKE_SOURCE_DIR}/GL/devIL/include
  NO_DEFAULT_PATH
  )

if (UNIX)
  # for future Linux support
endif()

if (WIN32)
  find_library(DEVIL_LIBRARY_1 NAMES DevIL.lib
    PATHS
    ${CMAKE_SOURCE_DIR}/GL/devIL/bin/win/lib64
    NO_DEFAULT_PATH
    )
  find_library(DEVIL_LIBRARY_2 NAMES ILU.lib
    PATHS
    ${CMAKE_SOURCE_DIR}/GL/devIL/bin/win/lib64
    NO_DEFAULT_PATH
    )
  find_library(DEVIL_LIBRARY_3 NAMES ILUT.lib
    PATHS
    ${CMAKE_SOURCE_DIR}/GL/devIL/bin/win/lib64
    NO_DEFAULT_PATH
    )
  find_path(DEVIL_BINARIES DevIL.dll ILU.dll ILUT.dll
    ${CMAKE_SOURCE_DIR}/GL/devIL/bin/win/dll64
    NO_DEFAULT_PATH
    )
endif()

if (DEVIL_INCLUDE_HEADERS AND DEVIL_LIBRARY_1 AND DEVIL_LIBRARY_2 AND DEVIL_LIBRARY_3 AND DEVIL_BINARIES)
  set(DEVIL_FOUND TRUE)
else()
  set(DEVIL_FOUND FALSE CACHE BOOL "DevIL not found")
  message(FATAL_ERROR "Could NOT find DevIL, fatal error!")
endif()

mark_as_advanced(
  DEVIL_INCLUDE_HEADERS
  DEVIL_LIBRARY_1
  DEVIL_LIBRARY_2
  DEVIL_LIBRARY_3
  DEVIL_BINARIES
  )