# ************************************************************
#
#  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
#  Released Under a Simplified BSD (FreeBSD) License
#  for academic, personal & non-commercial use.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions are met:
#
#  1. Redistributions of source code must retain the above copyright notice, this
#  list of conditions and the following disclaimer.
#
#  2. Redistributions in binary form must reproduce the above copyright notice,
#  this list of conditions and the following disclaimer in the documentation
#  and/or other materials provided with the distribution.
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
#  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
#  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  The views and conclusions contained in the software and documentation are those
#  of the author and should not be interpreted as representing official policies,
#  either expressed or implied, of the FreeBSD Project.
#
#  A Commercial License is also available for commercial use with
#  special restrictions and obligations at a one-off fee. See links at:
#  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
#  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
#  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.
#
# ************************************************************

# GPU Framework version 14.0.0

# Custom FindAssimp for the GPU Framework version 14.0.0
# ------------------------------------------------------
#
# Find the Open Asset Import Library (Assimp)
#
# Result Variables
# ^^^^^^^^^^^^^^^^
#
# This module defines the following variables:
#
#   ASSIMP_INCLUDE_HEADERS - include directory for Assimp
#   ASSIMP_LIBRARIES       - library file (assimp.lib) to link against Assimp
#   ASSIMP_BINARIES        - binary  directory for Assimp
#   ASSIMP_FOUND           - true if Assimp has been found and can be used

set(ASSIMP_VERSION "3.0.1270")

# find the path of GLEW headers
find_path(ASSIMP_INCLUDE_HEADERS config.h defs.h
  ${CMAKE_SOURCE_DIR}/GL/assimp/include
  NO_DEFAULT_PATH
  )

if (UNIX)
  # for future Linux support
endif()

if (WIN32)
  find_library(ASSIMP_LIBRARIES NAMES assimp.lib
    PATHS
    ${CMAKE_SOURCE_DIR}/GL/assimp/bin/win/lib64
    NO_DEFAULT_PATH
    )
  find_path(ASSIMP_BINARIES Assimp64.dll
    ${CMAKE_SOURCE_DIR}/GL/assimp/bin/win/dll64
    NO_DEFAULT_PATH
    )
endif()

if (ASSIMP_INCLUDE_HEADERS AND ASSIMP_LIBRARIES AND ASSIMP_BINARIES)
  set(ASSIMP_FOUND TRUE)
else()
  set(ASSIMP_FOUND FALSE CACHE BOOL "Assimp not found")
  message(FATAL_ERROR "Could NOT find Assimp, fatal error!")
endif()

mark_as_advanced(
  ASSIMP_INCLUDE_HEADERS
  ASSIMP_LIBRARIES
  ASSIMP_BINARIES
  )